/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.OutOfSourcesChecker;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class CheckinHandlerUtil {
    public static List<VirtualFile> filterOutGeneratedAndExcludedFiles(@NotNull Collection<? extends VirtualFile> files, @NotNull Project project) {
        if (files == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(1);
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(files.size());
        for (VirtualFile virtualFile : files) {
            if (fileIndex.isExcluded(virtualFile) || GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)virtualFile, (Project)project)) continue;
            result2.add(virtualFile);
        }
        return result2;
    }

    public static PsiFile[] getPsiFiles(Project project, Collection<? extends VirtualFile> selectedFiles) {
        ArrayList<PsiFile> result2 = new ArrayList<PsiFile>();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        IProjectStore projectStore = ProjectKt.getStateStore((Project)project);
        for (VirtualFile virtualFile : selectedFiles) {
            PsiFile psiFile;
            if (!virtualFile.isValid() || projectStore.isProjectFile(virtualFile) || !CheckinHandlerUtil.isFileUnderSourceRoot(project, virtualFile) || CheckinHandlerUtil.isOutOfSources(project, virtualFile) || (psiFile = psiManager.findFile(virtualFile)) == null) continue;
            result2.add(psiFile);
        }
        return PsiUtilCore.toPsiFileArray(result2);
    }

    private static boolean isFileUnderSourceRoot(@NotNull Project project, @NotNull VirtualFile file) {
        ProjectFileIndex index;
        if (project == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(2);
        }
        if (file == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(3);
        }
        return (index = ProjectRootManager.getInstance((Project)project).getFileIndex()).isInContent(file) && !index.isInLibrarySource(file);
    }

    private static boolean isOutOfSources(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(4);
        }
        if (file == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(5);
        }
        return OutOfSourcesChecker.EP_NAME.getExtensionList().stream().anyMatch(checker -> FileTypeRegistry.getInstance().isFileOfType(file, checker.getFileType()) && checker.isOutOfSources(project, file));
    }

    public static void disableWhenDumb(@NotNull Project project, @NotNull JCheckBox checkBox, @NotNull @Nls String tooltip) {
        boolean dumb;
        if (project == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(6);
        }
        if (checkBox == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(7);
        }
        if (tooltip == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(8);
        }
        checkBox.setEnabled(!(dumb = DumbService.isDumb((Project)project)));
        checkBox.setToolTipText(dumb ? tooltip : "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkBox";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/checkin/CheckinHandlerUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "filterOutGeneratedAndExcludedFiles";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileUnderSourceRoot";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isOutOfSources";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "disableWhenDumb";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

