/*
 * Decompiled with CFR 0.152.
 */
package cucumber.api;

import cucumber.runtime.CucumberException;
import cucumber.runtime.ParameterInfo;
import cucumber.runtime.table.DiffableRow;
import cucumber.runtime.table.TableConverter;
import cucumber.runtime.table.TableDiffException;
import cucumber.runtime.table.TableDiffer;
import cucumber.runtime.xstream.LocalizedXStreams;
import gherkin.formatter.PrettyFormatter;
import gherkin.formatter.model.DataTableRow;
import gherkin.formatter.model.Row;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DataTable {
    private final List<List<String>> raw;
    private final List<DataTableRow> gherkinRows;
    private final TableConverter tableConverter;

    public static DataTable create(List<?> raw) {
        return DataTable.create(raw, Locale.getDefault(), null, new String[0]);
    }

    public static DataTable create(List<?> raw, String format, String ... columnNames) {
        return DataTable.create(raw, Locale.getDefault(), format, columnNames);
    }

    public static DataTable create(List<?> raw, Locale locale, String ... columnNames) {
        return DataTable.create(raw, locale, null, columnNames);
    }

    private static DataTable create(List<?> raw, Locale locale, String format, String ... columnNames) {
        ParameterInfo parameterInfo = new ParameterInfo(null, format, null, null);
        TableConverter tableConverter = new TableConverter(new LocalizedXStreams(Thread.currentThread().getContextClassLoader()).get(locale), parameterInfo);
        return tableConverter.toTable(raw, columnNames);
    }

    public DataTable(List<DataTableRow> gherkinRows, TableConverter tableConverter) {
        this.gherkinRows = gherkinRows;
        this.tableConverter = tableConverter;
        int columns = gherkinRows.isEmpty() ? 0 : gherkinRows.get(0).getCells().size();
        ArrayList raw = new ArrayList();
        for (Row row : gherkinRows) {
            ArrayList list = new ArrayList();
            list.addAll(row.getCells());
            if (columns != row.getCells().size()) {
                throw new CucumberException(String.format("Table is unbalanced: expected %s column(s) but found %s.", columns, row.getCells().size()));
            }
            raw.add(Collections.unmodifiableList(list));
        }
        this.raw = Collections.unmodifiableList(raw);
    }

    private DataTable(List<DataTableRow> gherkinRows, List<List<String>> raw, TableConverter tableConverter) {
        this.gherkinRows = gherkinRows;
        this.tableConverter = tableConverter;
        this.raw = Collections.unmodifiableList(raw);
    }

    public List<List<String>> raw() {
        return this.raw;
    }

    public <K, V> List<Map<K, V>> asMaps(Class<K> keyType, Class<V> valueType) {
        return this.tableConverter.toMaps(this, keyType, valueType);
    }

    public <K, V> Map<K, V> asMap(Class<K> keyType, Class<V> valueType) {
        return this.tableConverter.toMap(this, keyType, valueType);
    }

    public <T> List<T> asList(Class<T> itemType) {
        return this.tableConverter.toList(this, itemType);
    }

    public <T> List<List<T>> asLists(Class<T> itemType) {
        return this.tableConverter.toLists(this, itemType);
    }

    public List<String> topCells() {
        return this.raw.isEmpty() ? Collections.emptyList() : this.raw.get(0);
    }

    public List<List<String>> cells(int firstRow) {
        return this.raw.subList(firstRow, this.raw.size());
    }

    public DataTable toTable(List<?> raw, String ... columnNames) {
        return this.tableConverter.toTable(raw, columnNames);
    }

    public void diff(List<?> other) throws TableDiffException {
        List<String> topCells = this.topCells();
        DataTable otherTable = this.toTable(other, topCells.toArray(new String[topCells.size()]));
        this.diff(otherTable);
    }

    public void diff(DataTable other) throws TableDiffException {
        new TableDiffer(this, other).calculateDiffs();
    }

    public void unorderedDiff(DataTable other) throws TableDiffException {
        new TableDiffer(this, other).calculateUnorderedDiffs();
    }

    public void unorderedDiff(List<?> other) throws TableDiffException {
        List<String> topCells = this.topCells();
        DataTable otherTable = this.toTable(other, topCells.toArray(new String[topCells.size()]));
        this.unorderedDiff(otherTable);
    }

    public List<DataTableRow> getGherkinRows() {
        return Collections.unmodifiableList(this.gherkinRows);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        PrettyFormatter pf = new PrettyFormatter((Appendable)result, true, false);
        pf.table(this.getGherkinRows());
        pf.eof();
        return result.toString();
    }

    public List<DiffableRow> diffableRows() {
        ArrayList<DiffableRow> result = new ArrayList<DiffableRow>();
        List<List<String>> convertedRows = this.raw();
        for (int i = 0; i < convertedRows.size(); ++i) {
            result.add(new DiffableRow((Row)this.getGherkinRows().get(i), convertedRows.get(i)));
        }
        return result;
    }

    public TableConverter getTableConverter() {
        return this.tableConverter;
    }

    public DataTable transpose() {
        ArrayList<List<String>> transposed = new ArrayList<List<String>>();
        for (int i = 0; i < this.gherkinRows.size(); ++i) {
            Row gherkinRow = (Row)this.gherkinRows.get(i);
            for (int j = 0; j < gherkinRow.getCells().size(); ++j) {
                ArrayList row = null;
                if (j < transposed.size()) {
                    row = (ArrayList)transposed.get(j);
                }
                if (row == null) {
                    row = new ArrayList();
                    transposed.add(row);
                }
                row.add(gherkinRow.getCells().get(j));
            }
        }
        return new DataTable(this.gherkinRows, transposed, this.tableConverter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataTable)) {
            return false;
        }
        DataTable dataTable = (DataTable)o;
        return this.raw.equals(dataTable.raw);
    }

    public int hashCode() {
        return this.raw.hashCode();
    }
}

