/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.services;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.web.config.ServletFileSet;
import com.intellij.spring.web.mvc.mapping.UrlMapping;
import com.intellij.spring.web.mvc.mapping.UrlMappingElement;
import com.intellij.spring.web.mvc.views.ViewResolver;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class SpringMvcService {
    public static SpringMvcService getInstance() {
        return (SpringMvcService)ApplicationManager.getApplication().getService(SpringMvcService.class);
    }

    public abstract Set<SpringBeanPointer> getControllers(@NotNull Module var1);

    public abstract Set<SpringBeanPointer> getBeanControllers(@NotNull Module var1);

    public abstract Set<SpringBeanPointer> getFunctionalRoutes(@NotNull Module var1);

    public abstract Set<ViewResolver> getViewResolvers(@NotNull Module var1);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public Set<UrlMapping<?>> getUrlMappings(@NotNull Module module) {
        if (module == null) {
            SpringMvcService.$$$reportNull$$$0(0);
        }
        return new HashSet(this.getUrlMappingsElements(module));
    }

    public abstract Set<UrlMappingElement> getUrlMappingsElements(@NotNull Module var1);

    public static Set<SpringModel> getServletModels(@NotNull Module module) {
        if (module == null) {
            SpringMvcService.$$$reportNull$$$0(1);
        }
        return SpringManager.getInstance((Project)module.getProject()).getAllModels(module).stream().filter(model -> model.getFileSet() instanceof ServletFileSet).collect(Collectors.toSet());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "module";
        objectArray2[1] = "com/intellij/spring/web/mvc/services/SpringMvcService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getUrlMappings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getServletModels";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

