/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.tomcat.TomcatBundle;
import org.jetbrains.idea.tomcat.TomcatUtil;

public class TomcatServerXmlWrapper {
    @NonNls
    private static final String SERVICE_ELEMENT_NAME = "Service";
    @NonNls
    private static final String CONNECTOR_ELEMENT_NAME = "Connector";
    @NonNls
    private static final String PROTOCOL_ATTR = "protocol";
    @NonNls
    private static final String CLASS_NAME_ATTR = "className";
    @NonNls
    private static final String SSL_ATTR_ANY_VALUE = "sslProtocol";
    @NonNls
    private static final String[] SSL_ATTR_NEEDS_TRUE = new String[]{"secure", "SSLEnabled"};
    @NonNls
    private static final List<String> HTTP_CONNECTOR_CLASS_NAMES = Arrays.asList("org.apache.catalina.connector.http.HttpConnector", "org.apache.coyote.tomcat4.CoyoteConnector");
    @NonNls
    private static final String PROTOCOL_HANDLER_ATTRIBUTE = "protocolHandlerClassName";
    @NonNls
    private static final String PORT_ATTR = "port";
    private static final Map<File, Pair<Long, Integer>> ourCachedHttpPort = new HashMap<File, Pair<Long, Integer>>();
    private static final int DEFAULT_HTTP_PORT = 8080;
    private static final int DEFAULT_SHUTDOWN_PORT = 8005;
    private final File myFile;
    private Element myRootElement;
    private ExecutionException myLoadException;
    private boolean myWasLoad;

    public TomcatServerXmlWrapper(String baseDirPath) {
        this(new File(TomcatUtil.baseConfigDir(baseDirPath), "server.xml"));
    }

    public TomcatServerXmlWrapper(File serverXml) {
        this.myFile = serverXml;
        this.myWasLoad = false;
    }

    private void loadDoc() throws ExecutionException {
        if (!this.myWasLoad) {
            this.doLoad();
            this.myWasLoad = true;
        }
        if (this.myLoadException != null) {
            throw this.myLoadException;
        }
    }

    private void doLoad() {
        this.myRootElement = null;
        this.myLoadException = null;
        try {
            this.myRootElement = TomcatUtil.loadXMLFile(this.myFile);
        }
        catch (ExecutionException e) {
            this.myLoadException = e;
        }
    }

    public int getHttpPort() {
        Pair<Long, Integer> cached = ourCachedHttpPort.get(this.myFile);
        if (cached != null && this.myFile.lastModified() == ((Long)cached.getFirst()).longValue()) {
            return (Integer)cached.getSecond();
        }
        int port = new HttpPortHandler().getPort();
        ourCachedHttpPort.put(this.myFile, (Pair<Long, Integer>)Pair.create((Object)this.myFile.lastModified(), (Object)port));
        return port;
    }

    public void setHttpPort(int httpPort) throws ExecutionException {
        new HttpPortHandler().setPort(httpPort);
    }

    public void setHttpsPort(int httpsPort) throws ExecutionException {
        new HttpsPortHandler().setPort(httpsPort);
    }

    public int getShutdownPort() {
        return new ShutdownPortHandler().getPort();
    }

    public void setShutdownPort(int shutdownPort) throws ExecutionException {
        new ShutdownPortHandler().setPort(shutdownPort);
    }

    public Integer getAjpPort() {
        return new AjpPortHandler().getPort();
    }

    public void setAjpPort(int ajpPort) throws ExecutionException {
        new AjpPortHandler().setPort(ajpPort);
    }

    public Element findLocalHost() throws ExecutionException {
        this.loadDoc();
        Element result = TomcatUtil.findElementByAttr(this.myRootElement, "Host", "name", "localhost");
        if (result == null) {
            throw new ExecutionException(TomcatBundle.message("exception.text.server.xml.does.not.contain.virtual.host.localhost", new Object[0]));
        }
        return result;
    }

    public void save() throws ExecutionException {
        this.loadDoc();
        TomcatUtil.saveXMLFile(this.myRootElement, this.myFile, true);
    }

    public void checkHttpConnectorsAmount() throws RuntimeConfigurationWarning {
        new HttpPortHandler().checkConnectorsAmount();
    }

    public void checkHttpsConnectorsAmount() throws RuntimeConfigurationWarning {
        new HttpsPortHandler().checkConnectorsAmount();
    }

    public void checkAjpConnectorsAmount() throws RuntimeConfigurationWarning {
        new AjpPortHandler().checkConnectorsAmount();
    }

    public boolean hasSourceLocalPort() {
        try {
            this.loadDoc();
        }
        catch (ExecutionException e) {
            return false;
        }
        return new HttpPortHandler().getPortNode() != null;
    }

    private class AjpPortHandler
    extends ConnectorPortHandler {
        private AjpPortHandler() {
        }

        @Override
        protected String getPortName() {
            return "AJP";
        }

        @Override
        protected boolean checkConnector(Element connector, Ref<Element> portNodeRef) {
            String protocol = connector.getAttributeValue(TomcatServerXmlWrapper.PROTOCOL_ATTR);
            if (protocol != null && protocol.equals("AJP/1.3")) {
                portNodeRef.set((Object)connector);
                return true;
            }
            return false;
        }

        @Override
        protected Integer getDefaultPort() {
            return null;
        }

        @Override
        protected String getNodeNotFoundMessage() {
            return TomcatBundle.message("error.message.ajp.connector.not.found", new Object[0]);
        }
    }

    private class ShutdownPortHandler
    extends PortHandler {
        private ShutdownPortHandler() {
        }

        @Override
        protected Element getPortNode() {
            return TomcatServerXmlWrapper.this.myRootElement;
        }

        @Override
        protected Integer getDefaultPort() {
            return 8005;
        }

        @Override
        protected String getNodeNotFoundMessage() {
            throw new UnsupportedOperationException();
        }
    }

    private class HttpsPortHandler
    extends HttpPortHandlerBase {
        private HttpsPortHandler() {
        }

        @Override
        protected String getPortName() {
            return "HTTPs";
        }

        @Override
        protected boolean checkConnector(Element connector, Ref<Element> portNodeRef) {
            if (!this.isConnectorSecured(connector)) {
                return false;
            }
            return super.checkConnector(connector, portNodeRef);
        }

        @Override
        protected Integer getDefaultPort() {
            return null;
        }

        @Override
        protected String getNodeNotFoundMessage() {
            return TomcatBundle.message("error.message.https.connector.not.found", new Object[0]);
        }
    }

    protected class HttpPortHandler
    extends HttpPortHandlerBase {
        protected HttpPortHandler() {
        }

        @Override
        protected String getPortName() {
            return "HTTP";
        }

        @Override
        protected boolean checkConnector(Element connector, Ref<Element> portNodeRef) {
            if (this.isConnectorSecured(connector)) {
                return false;
            }
            return super.checkConnector(connector, portNodeRef);
        }

        @Override
        protected Integer getDefaultPort() {
            return 8080;
        }

        @Override
        protected String getNodeNotFoundMessage() {
            return TomcatBundle.message("error.message.http.connector.not.found", new Object[0]);
        }
    }

    private abstract class HttpPortHandlerBase
    extends ConnectorPortHandler {
        private HttpPortHandlerBase() {
        }

        @Override
        protected boolean checkConnector(Element connector, Ref<Element> portNodeRef) {
            String protocol = connector.getAttributeValue(TomcatServerXmlWrapper.PROTOCOL_ATTR);
            if (protocol != null && (protocol.equals("HTTP/1.1") || protocol.startsWith("org.apache.coyote.http11."))) {
                portNodeRef.set((Object)connector);
                return true;
            }
            String className = connector.getAttributeValue(TomcatServerXmlWrapper.CLASS_NAME_ATTR);
            if (protocol == null && className == null || HTTP_CONNECTOR_CLASS_NAMES.contains(className) && connector.getAttributeValue(TomcatServerXmlWrapper.PROTOCOL_HANDLER_ATTRIBUTE) == null) {
                portNodeRef.set((Object)connector);
                return true;
            }
            return false;
        }

        protected boolean isConnectorSecured(Element connector) {
            if (connector.getAttributeValue(TomcatServerXmlWrapper.SSL_ATTR_ANY_VALUE) != null) {
                return true;
            }
            for (String nextNeedsTrue : SSL_ATTR_NEEDS_TRUE) {
                String secure = connector.getAttributeValue(nextNeedsTrue);
                if (!Boolean.TRUE.toString().equals(secure)) continue;
                return true;
            }
            return false;
        }
    }

    private abstract class ConnectorPortHandler
    extends PortHandler {
        private ConnectorPortHandler() {
        }

        @Override
        protected Element getPortNode() {
            List<Element> connectors = this.getConnectors();
            return (Element)ContainerUtil.getFirstItem(connectors);
        }

        protected List<Element> getConnectors() {
            ArrayList<Element> result = new ArrayList<Element>();
            Ref portNodeRef = new Ref();
            if (TomcatServerXmlWrapper.this.myRootElement == null) {
                return Collections.EMPTY_LIST;
            }
            for (Element service : TomcatServerXmlWrapper.this.myRootElement.getChildren(TomcatServerXmlWrapper.SERVICE_ELEMENT_NAME)) {
                for (Element connector : service.getChildren(TomcatServerXmlWrapper.CONNECTOR_ELEMENT_NAME)) {
                    if (!this.checkConnector(connector, (Ref<Element>)portNodeRef)) continue;
                    result.add((Element)portNodeRef.get());
                }
            }
            return result;
        }

        protected void checkConnectorsAmount() throws RuntimeConfigurationWarning {
            try {
                TomcatServerXmlWrapper.this.loadDoc();
            }
            catch (ExecutionException e) {
                return;
            }
            if (this.getConnectors().size() > 1) {
                throw new RuntimeConfigurationWarning(TomcatBundle.message("TomcatServerXmlWrapper.http.connectors.more.than.one", this.getPortName()));
            }
        }

        protected abstract String getPortName();

        protected abstract boolean checkConnector(Element var1, Ref<Element> var2);
    }

    private abstract class PortHandler {
        private PortHandler() {
        }

        public Integer getPort() {
            String portAttribute;
            try {
                TomcatServerXmlWrapper.this.loadDoc();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            Integer result = this.getDefaultPort();
            Element portNode = this.getPortNode();
            if (portNode != null && (portAttribute = portNode.getAttributeValue(TomcatServerXmlWrapper.PORT_ATTR)) != null) {
                try {
                    result = this.parsePort(portAttribute);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return result;
        }

        public void setPort(int port) throws ExecutionException {
            TomcatServerXmlWrapper.this.loadDoc();
            Element portNode = this.getPortNode();
            if (portNode == null) {
                throw new ExecutionException(this.getNodeNotFoundMessage());
            }
            portNode.setAttribute(TomcatServerXmlWrapper.PORT_ATTR, String.valueOf(port));
        }

        protected int parsePort(String portAttribute) throws NumberFormatException {
            return Integer.parseInt(portAttribute);
        }

        protected abstract Element getPortNode();

        protected abstract Integer getDefaultPort();

        @Nls
        protected abstract String getNodeNotFoundMessage();
    }
}

