/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.lifecycle.mappings.model.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.LiveDispatcherServlet;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.LiveHandlerMethod;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.LiveRequestMapping;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.impl.LiveHandlerMethodImpl;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.impl.LiveRequestMappingPredicate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveRequestMappingImpl
implements LiveRequestMapping {
    private final String myMapping;
    private final LiveRequestMappingPredicate myPredicate;
    private final String myBean;
    private final LiveHandlerMethod myMethod;
    private final LiveDispatcherServlet myDispatcherServlet;

    LiveRequestMappingImpl(@NotNull String mapping, @NotNull LiveRequestMappingPredicate predicate, @Nullable String bean, @Nullable String method, @NotNull LiveDispatcherServlet dispatcherServlet) {
        if (mapping == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(0);
        }
        if (predicate == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(1);
        }
        if (dispatcherServlet == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(2);
        }
        this.myMapping = mapping;
        this.myPredicate = predicate;
        this.myBean = bean;
        this.myMethod = method != null ? new LiveHandlerMethodImpl(method) : null;
        this.myDispatcherServlet = dispatcherServlet;
    }

    @Override
    @NotNull
    public String getMapping() {
        String string = this.myMapping;
        if (string == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPath() {
        String string = this.myPredicate.getPath();
        if (string == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public List<String> getRequestMethods() {
        List<String> list = Collections.unmodifiableList(this.myPredicate.getRequestMethods());
        if (list == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getHeaders() {
        List<Pair<String, String>> list = Collections.unmodifiableList(this.myPredicate.getHeaders());
        if (list == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getProduces() {
        List<String> list = Collections.unmodifiableList(this.myPredicate.getProduces());
        if (list == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getConsumes() {
        List<String> list = Collections.unmodifiableList(this.myPredicate.getConsumes());
        if (list == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getParams() {
        List<Pair<String, String>> list = Collections.unmodifiableList(this.myPredicate.getParams());
        if (list == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @Nullable
    public String getBean() {
        return this.myBean;
    }

    @Override
    @Nullable
    public LiveHandlerMethod getMethod() {
        return this.myMethod;
    }

    @Override
    public boolean canNavigate() {
        return this.myMethod != null && (this.myPredicate.getRequestMethods().isEmpty() || this.myPredicate.getRequestMethods().contains("GET"));
    }

    @Override
    @NotNull
    public LiveDispatcherServlet getDispatcherServlet() {
        LiveDispatcherServlet liveDispatcherServlet = this.myDispatcherServlet;
        if (liveDispatcherServlet == null) {
            LiveRequestMappingImpl.$$$reportNull$$$0(10);
        }
        return liveDispatcherServlet;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LiveRequestMappingImpl) {
            LiveRequestMappingImpl liveMapping = (LiveRequestMappingImpl)obj;
            return this.myMapping.equals(liveMapping.myMapping) && this.myPredicate.getPath().equals(liveMapping.myPredicate.getPath()) && Objects.equals(this.myBean, liveMapping.myBean) && Comparing.equal((Object)this.myMethod, (Object)liveMapping.myMethod) && this.myDispatcherServlet.equals(liveMapping.myDispatcherServlet);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.myMapping.hashCode();
        result = 31 * result + this.myPredicate.getPath().hashCode();
        result = 31 * result + (this.myBean != null ? this.myBean.hashCode() : 0);
        result = 31 * result + (this.myMethod != null ? this.myMethod.hashCode() : 0);
        result = 31 * result + this.myDispatcherServlet.hashCode();
        return result;
    }

    public String toString() {
        return this.myMapping;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dispatcherServlet";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/mvc/lifecycle/mappings/model/impl/LiveRequestMappingImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/mvc/lifecycle/mappings/model/impl/LiveRequestMappingImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapping";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestMethods";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaders";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProduces";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsumes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getParams";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDispatcherServlet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

