/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.lifecycle.mappings.gutter;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.mvc.SpringBootMvcBundle;
import com.intellij.spring.boot.mvc.lifecycle.mappings.RequestMappingsEndpoint;
import com.intellij.spring.boot.mvc.lifecycle.mappings.gutter.LiveRequestMappingsNavigationHandler;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.LiveRequestMapping;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.LiveRequestMappingsModel;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationServerConfiguration;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.settings.SpringGeneralSettings;
import com.intellij.spring.web.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.web.mvc.request.SpringMergingMvcRequestMappingLineMarkerProvider;
import com.intellij.util.SmartList;
import icons.SpringApiIcons;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public class LiveRequestMappingsLineMarkerProvider
implements SpringMergingMvcRequestMappingLineMarkerProvider {
    public boolean collectLineMarkers(@NotNull PsiElement psiElement, @NotNull @NotNull Collection<@NotNull ? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        if (psiElement == null) {
            LiveRequestMappingsLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            LiveRequestMappingsLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (LiveRequestMappingsLineMarkerProvider.hasNotLiveMappingInProject(psiElement.getProject())) {
            return false;
        }
        PsiMethod psiMethod = LiveRequestMappingsLineMarkerProvider.getRequestMappingMethod(psiElement);
        if (psiMethod == null) {
            return false;
        }
        if (psiMethod.isConstructor()) {
            return false;
        }
        PsiClass psiClass = psiMethod.getContainingClass();
        if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)psiClass)) {
            return false;
        }
        Project project = psiMethod.getProject();
        SmartList items = new SmartList();
        List infos = SpringBootApplicationLifecycleManager.getInstance((Project)project).getSpringBootApplicationInfos();
        for (SpringBootApplicationInfo info : infos) {
            String servletPath;
            String applicationUrl;
            LiveRequestMappingsModel mappingsModel = (LiveRequestMappingsModel)info.getEndpointData(RequestMappingsEndpoint.getInstance()).getValue();
            if (mappingsModel == null || (applicationUrl = (String)info.getApplicationUrl().getValue()) == null) continue;
            SpringBootApplicationServerConfiguration applicationServerConfiguration = (SpringBootApplicationServerConfiguration)info.getServerConfiguration().getValue();
            String string = servletPath = applicationServerConfiguration == null ? null : applicationServerConfiguration.getServletPath();
            List<LiveRequestMapping> mappings = mappingsModel.getRequestMappingsByMethod(psiMethod);
            if (mappings.isEmpty()) continue;
            items.add(new LiveRequestMappingsNavigationHandler.MethodNavigationItem(project, info, applicationUrl, servletPath, mappings, "ICON_NAVIGATION"));
        }
        if (items.isEmpty()) {
            return false;
        }
        LiveRequestMappingsNavigationHandler navigationHandler = new LiveRequestMappingsNavigationHandler((List<LiveRequestMappingsNavigationHandler.MethodNavigationItem>)items);
        SpringGutterIconBuilder.CustomNavigationHandlerBuilder builder = SpringGutterIconBuilder.CustomNavigationHandlerBuilder.createBuilder((Icon)SpringApiIcons.Gutter.RequestMapping, (String)navigationHandler.getLiveMarkerInfoTooltipText(), (GutterIconNavigationHandler)navigationHandler, null);
        result.add((RelatedItemLineMarkerInfo<PsiElement>)builder.withElementPresentation(SpringBootMvcBundle.message("spring.boot.live.request.mapping.gutter.name", new Object[0])).withAdditionalGotoRelatedItems(navigationHandler.getRelatedItems((PsiElement)psiMethod)).createSpringRelatedMergeableLineMarkerInfo(psiElement));
        return true;
    }

    @Nullable
    private static PsiMethod getRequestMappingMethod(@NotNull PsiElement psiElement) {
        UIdentifier uIdentifier;
        if (psiElement == null) {
            LiveRequestMappingsLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if ((uIdentifier = (UIdentifier)UastContextKt.toUElement((PsiElement)psiElement, UIdentifier.class)) == null) {
            return null;
        }
        UElement uParent = UastUtils.getUParentForIdentifier((PsiElement)psiElement);
        if (!(uParent instanceof UMethod)) {
            return null;
        }
        UMethod uMethod = (UMethod)uParent;
        return (PsiMethod)UElementKt.getAsJavaPsiElement((UElement)uMethod, PsiMethod.class);
    }

    private static boolean hasNotLiveMappingInProject(@NotNull Project project) {
        if (project == null) {
            LiveRequestMappingsLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (!SpringCommonUtils.hasSpringFacets((Project)project) && !SpringGeneralSettings.getInstance((Project)project).isAllowAutoConfigurationMode() || !SpringBootLibraryUtil.hasSpringBootLibrary((Project)project) || !SpringMvcLibraryUtil.isSpringMVCEnabled((Project)project)) {
            return true;
        }
        List infos = SpringBootApplicationLifecycleManager.getInstance((Project)project).getSpringBootApplicationInfos();
        return infos.stream().noneMatch(info -> info.getEndpointData(RequestMappingsEndpoint.getInstance()).getValue() != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/mvc/lifecycle/mappings/gutter/LiveRequestMappingsLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectLineMarkers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getRequestMappingMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasNotLiveMappingInProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

