/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.config.viewresolver;

import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootConfigValueSearcher;
import com.intellij.spring.boot.mvc.config.SpringBootStaticWebFileReferenceHelper;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.web.mvc.views.UrlBasedViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolverFactory;
import com.intellij.util.containers.SmartHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class SpringBootAutoConfigurationViewResolverFactoryBase
extends ViewResolverFactory {
    SpringBootAutoConfigurationViewResolverFactoryBase() {
    }

    @Nullable
    protected final String getBeanClass() {
        return null;
    }

    @NotNull
    protected abstract String getViewResolverBeanName();

    @NotNull
    protected abstract Set<String> getViewResolverClassNames();

    @NotNull
    protected abstract Set<String> getAutoConfigurationClassNames();

    protected boolean isMine(@Nullable CommonSpringBean bean, @NotNull PsiClass beanClass) {
        if (beanClass == null) {
            SpringBootAutoConfigurationViewResolverFactoryBase.$$$reportNull$$$0(0);
        }
        return bean != null && this.matchesAutoConfigurationBean(bean, beanClass);
    }

    @NotNull
    protected Set<ViewResolver> createViewResolvers(@Nullable CommonSpringBean bean, CommonSpringModel model) {
        Module module = model.getModule();
        if (module == null) {
            return new SmartHashSet();
        }
        Set<ViewResolver> set = SpringBootStaticWebFileReferenceHelper.INSTANCE.getStaticResolvers(module);
        if (set == null) {
            SpringBootAutoConfigurationViewResolverFactoryBase.$$$reportNull$$$0(1);
        }
        return set;
    }

    protected boolean matchesAutoConfigurationBean(@NotNull CommonSpringBean bean, @NotNull PsiClass beanClass) {
        if (bean == null) {
            SpringBootAutoConfigurationViewResolverFactoryBase.$$$reportNull$$$0(2);
        }
        if (beanClass == null) {
            SpringBootAutoConfigurationViewResolverFactoryBase.$$$reportNull$$$0(3);
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary((Project)beanClass.getProject())) {
            return false;
        }
        if (!this.getViewResolverBeanName().equals(bean.getBeanName())) {
            return false;
        }
        if (!this.getViewResolverClassNames().contains(beanClass.getQualifiedName())) {
            return false;
        }
        PsiElement beanPsiElement = bean.getIdentifyingPsiElement();
        if (!(beanPsiElement instanceof PsiMethod)) {
            return false;
        }
        PsiMethod psiMethod = (PsiMethod)beanPsiElement;
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        return this.getAutoConfigurationClassNames().contains(psiClass.getQualifiedName());
    }

    protected ViewResolver createURLBasedViewResolver(Module module, String path, String viewPrefix, String viewSuffix) {
        return this.createURLBasedViewResolver(module, path, viewPrefix, viewSuffix, "SpringBoot: " + ((Object)((Object)this)).getClass().getSimpleName());
    }

    @NotNull
    protected UrlBasedViewResolver createURLBasedViewResolver(Module module, String path, String viewPrefix, String viewSuffix, String id) {
        return new UrlBasedViewResolver(module, id, path, viewPrefix, viewSuffix);
    }

    @Nullable
    protected static String getConfigurationValue(CommonSpringModel model, String key) {
        assert (model.getModule() != null);
        return SpringBootConfigValueSearcher.productionForProfiles((Module)model.getModule(), (String)key, (Set)model.getActiveProfiles()).findValueText();
    }

    @Nullable
    protected static String getConfigurationOrDefaultValue(CommonSpringModel model, String key) {
        String value = SpringBootAutoConfigurationViewResolverFactoryBase.getConfigurationValue(model, key);
        if (value != null) {
            return value;
        }
        return SpringBootAutoConfigurationViewResolverFactoryBase.getDefaultValue(model, key);
    }

    @Nullable
    protected static String getDefaultValue(CommonSpringModel model, String key) {
        MetaConfigKey metaConfigKey = SpringBootApplicationMetaConfigKeyManager.getInstance().findCanonicalApplicationMetaConfigKey(model.getModule(), key);
        return metaConfigKey == null ? null : metaConfigKey.getDefaultValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/mvc/config/viewresolver/SpringBootAutoConfigurationViewResolverFactoryBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/mvc/config/viewresolver/SpringBootAutoConfigurationViewResolverFactoryBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createViewResolvers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "matchesAutoConfigurationBean";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

