/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.config.viewresolver;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.mvc.config.viewresolver.TemplateAvailabilityProvider;
import com.intellij.spring.model.utils.SpringCommonUtils;

class GroovyTemplateAvailabilityProvider
extends TemplateAvailabilityProvider {
    GroovyTemplateAvailabilityProvider() {
    }

    @Override
    public boolean isTemplateAvailable(ConditionalOnEvaluationContext context, String viewName) {
        if (SpringCommonUtils.findLibraryClass((Module)context.getModule(), (String)"groovy.text.markup.MarkupTemplateEngine") == null) {
            return false;
        }
        boolean isAtLeastSB13 = SpringBootLibraryUtil.isAtLeastVersion((Module)context.getModule(), (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0);
        String prefix = StringUtil.notNullize((String)GroovyTemplateAvailabilityProvider.getConfigurationOrDefaultValue(context, "spring.groovy.template.prefix"), (String)(isAtLeastSB13 ? "" : "classpath:/templates/"));
        String suffix = StringUtil.notNullize((String)GroovyTemplateAvailabilityProvider.getConfigurationOrDefaultValue(context, "spring.groovy.template.suffix"), (String)".tpl");
        String resourceLoaderPath = isAtLeastSB13 ? GroovyTemplateAvailabilityProvider.getConfigurationOrDefaultValue(context, "spring.groovy.template.resource-loader-path") : "";
        return GroovyTemplateAvailabilityProvider.isResourceAvailable(context, resourceLoaderPath + prefix + viewName + suffix);
    }
}

