/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.config.viewresolver;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.SpringBootConfigValueSearcher;
import com.intellij.spring.boot.mvc.config.viewresolver.SpringBootAutoConfigurationViewResolverFactoryBase;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FreemarkerWebAutoConfigurationViewResolverFactory
extends SpringBootAutoConfigurationViewResolverFactoryBase {
    private static final Set<String> VIEW_RESOLVER_CLASS_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"org.springframework.web.servlet.view.freemarker.FreeMarkerViewResolver"});
    private static final Set<String> AUTOCONFIG_CLASSES = ContainerUtil.immutableSet((Object[])new String[]{"org.springframework.boot.autoconfigure.freemarker.FreeMarkerAutoConfiguration.FreeMarkerWebConfiguration", "org.springframework.boot.autoconfigure.freemarker.FreeMarkerServletWebConfiguration"});
    @NonNls
    static final String SPRING_FREEMARKER_PREFIX = "spring.freemarker.prefix";
    @NonNls
    static final String SPRING_FREEMARKER_SUFFIX = "spring.freemarker.suffix";
    @NonNls
    static final String SPRING_FREEMARKER_PREFIX_DEFAULT = "";
    @NonNls
    static final String SPRING_FREEMARKER_SUFFIX_DEFAULT = ".ftl";
    @NonNls
    static final String SPRING_FREEMARKER_TEMPLATE_LOADER_PATH = "spring.freemarker.template-loader-path";

    @Override
    @NotNull
    protected String getViewResolverBeanName() {
        return "freeMarkerViewResolver";
    }

    @Override
    @NotNull
    protected Set<String> getViewResolverClassNames() {
        Set<String> set = VIEW_RESOLVER_CLASS_NAMES;
        if (set == null) {
            FreemarkerWebAutoConfigurationViewResolverFactory.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @NotNull
    protected Set<String> getAutoConfigurationClassNames() {
        Set<String> set = AUTOCONFIG_CLASSES;
        if (set == null) {
            FreemarkerWebAutoConfigurationViewResolverFactory.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @NotNull
    protected Set<ViewResolver> createViewResolvers(@Nullable CommonSpringBean bean, CommonSpringModel model) {
        String prefix = StringUtil.notNullize((String)FreemarkerWebAutoConfigurationViewResolverFactory.getConfigurationOrDefaultValue(model, SPRING_FREEMARKER_PREFIX), (String)SPRING_FREEMARKER_PREFIX_DEFAULT);
        String suffix = StringUtil.notNullize((String)FreemarkerWebAutoConfigurationViewResolverFactory.getConfigurationOrDefaultValue(model, SPRING_FREEMARKER_SUFFIX), (String)SPRING_FREEMARKER_SUFFIX_DEFAULT);
        List<String> paths = FreemarkerWebAutoConfigurationViewResolverFactory.getTemplateLoaderPaths(model);
        Set<ViewResolver> staticResolvers = super.createViewResolvers(bean, model);
        LinkedHashSet<ViewResolver> resolvers = new LinkedHashSet<ViewResolver>(paths.size() + staticResolvers.size());
        resolvers.addAll(staticResolvers);
        for (String path : paths) {
            resolvers.add(this.createURLBasedViewResolver(model.getModule(), StringUtil.trim((String)path), prefix, suffix));
        }
        LinkedHashSet<ViewResolver> linkedHashSet = resolvers;
        if (linkedHashSet == null) {
            FreemarkerWebAutoConfigurationViewResolverFactory.$$$reportNull$$$0(2);
        }
        return linkedHashSet;
    }

    private static List<String> getTemplateLoaderPaths(CommonSpringModel model) {
        assert (model.getModule() != null);
        SmartList valueTexts = new SmartList();
        SpringBootConfigValueSearcher searcher = SpringBootConfigValueSearcher.productionForProfiles((Module)model.getModule(), (String)SPRING_FREEMARKER_TEMPLATE_LOADER_PATH, (Set)model.getActiveProfiles());
        searcher.process(arg_0 -> FreemarkerWebAutoConfigurationViewResolverFactory.lambda$getTemplateLoaderPaths$0((List)valueTexts, arg_0));
        if (valueTexts.isEmpty()) {
            ContainerUtil.addIfNotNull((Collection)valueTexts, (Object)FreemarkerWebAutoConfigurationViewResolverFactory.getDefaultValue(model, SPRING_FREEMARKER_TEMPLATE_LOADER_PATH));
        }
        SmartList clean = new SmartList();
        for (String value : valueTexts) {
            value = value.replace('[', ' ').replace(']', ' ').replace('\"', ' ');
            clean.addAll(StringUtil.split((String)value, (String)","));
        }
        return clean;
    }

    private static /* synthetic */ boolean lambda$getTemplateLoaderPaths$0(List valueTexts, ConfigurationValueResult result) {
        ContainerUtil.addIfNotNull((Collection)valueTexts, (Object)result.getValueText());
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/boot/mvc/config/viewresolver/FreemarkerWebAutoConfigurationViewResolverFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewResolverClassNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoConfigurationClassNames";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createViewResolvers";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

