/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections.model;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.BDDFrameworkType;
import org.jetbrains.plugins.cucumber.inspections.model.FileTypeComboboxItem;

public class CreateStepDefinitionFileModel {
    private String myFileName;
    private final Map<BDDFrameworkType, String> myFileTypeToDefaultDirectoryMap;
    private final DefaultComboBoxModel<FileTypeComboboxItem> myFileTypeModel;
    private String myDirectory;
    private final Project myProject;
    @NotNull
    private final PsiFile myContext;

    public CreateStepDefinitionFileModel(@NotNull PsiFile context, @NotNull Map<BDDFrameworkType, String> fileTypeToDefaultNameMap, @NotNull Map<BDDFrameworkType, String> fileTypeToDefaultDirectoryMap) {
        if (context == null) {
            CreateStepDefinitionFileModel.$$$reportNull$$$0(0);
        }
        if (fileTypeToDefaultNameMap == null) {
            CreateStepDefinitionFileModel.$$$reportNull$$$0(1);
        }
        if (fileTypeToDefaultDirectoryMap == null) {
            CreateStepDefinitionFileModel.$$$reportNull$$$0(2);
        }
        this.myContext = context;
        this.myProject = context.getProject();
        ArrayList<FileTypeComboboxItem> myFileTypeList = new ArrayList<FileTypeComboboxItem>();
        for (Map.Entry<BDDFrameworkType, String> entry : fileTypeToDefaultNameMap.entrySet()) {
            if (this.myFileName == null) {
                this.myFileName = entry.getValue();
            }
            FileTypeComboboxItem item = new FileTypeComboboxItem(entry.getKey(), entry.getValue());
            myFileTypeList.add(item);
        }
        this.myFileTypeToDefaultDirectoryMap = fileTypeToDefaultDirectoryMap;
        this.myFileTypeModel = new DefaultComboBoxModel<FileTypeComboboxItem>(myFileTypeList.toArray(new FileTypeComboboxItem[0]));
        this.myDirectory = fileTypeToDefaultDirectoryMap.get(this.getSelectedFileType());
    }

    public String getFilePath() {
        return FileUtil.join((String[])new String[]{this.getStepDefinitionFolderPath(), this.getFileNameWithExtension()});
    }

    public String getFileNameWithExtension() {
        return this.myFileName + "." + this.getSelectedFileType().getFileType().getDefaultExtension();
    }

    public String getFileName() {
        return this.myFileName;
    }

    public void setFileName(@NotNull String fileName) {
        if (fileName == null) {
            CreateStepDefinitionFileModel.$$$reportNull$$$0(3);
        }
        this.myFileName = fileName;
    }

    public String getDefaultDirectory() {
        return this.myFileTypeToDefaultDirectoryMap.get(this.getSelectedFileType());
    }

    public String getStepDefinitionFolderPath() {
        return this.myDirectory;
    }

    public void setDirectory(@Nullable String directory) {
        this.myDirectory = directory;
    }

    public BDDFrameworkType getSelectedFileType() {
        FileTypeComboboxItem selectedItem = (FileTypeComboboxItem)this.myFileTypeModel.getSelectedItem();
        return selectedItem != null ? selectedItem.getFrameworkType() : null;
    }

    public DefaultComboBoxModel<FileTypeComboboxItem> getFileTypeModel() {
        return this.myFileTypeModel;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public PsiFile getContext() {
        PsiFile psiFile = this.myContext;
        if (psiFile == null) {
            CreateStepDefinitionFileModel.$$$reportNull$$$0(4);
        }
        return psiFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeToDefaultNameMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeToDefaultDirectoryMap";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/inspections/model/CreateStepDefinitionFileModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/inspections/model/CreateStepDefinitionFileModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setFileName";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

