/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.psi.GherkinTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTableRow;

public class RemoveTableColumnFix
implements LocalQuickFix {
    private final SmartPsiElementPointer<GherkinTable> myTable;
    private final int myColumnIndex;

    public RemoveTableColumnFix(@NotNull GherkinTable table, int columnIndex) {
        if (table == null) {
            RemoveTableColumnFix.$$$reportNull$$$0(0);
        }
        this.myTable = SmartPointerManager.createPointer((PsiElement)table);
        this.myColumnIndex = columnIndex;
    }

    @NotNull
    public String getName() {
        String string = CucumberBundle.message("intention.name.remove.unused.column", new Object[0]);
        if (string == null) {
            RemoveTableColumnFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return "RemoveTableColumnFix";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        GherkinTable table;
        if (project == null) {
            RemoveTableColumnFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            RemoveTableColumnFix.$$$reportNull$$$0(3);
        }
        if ((table = (GherkinTable)this.myTable.getElement()) == null) {
            return;
        }
        GherkinTableRow headerRow = table.getHeaderRow();
        if (headerRow != null) {
            headerRow.deleteCell(this.myColumnIndex);
        }
        for (GherkinTableRow row : table.getDataRows()) {
            row.deleteCell(this.myColumnIndex);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/inspections/RemoveTableColumnFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/inspections/RemoveTableColumnFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

