/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.variables;

import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.files.FtlFileType;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlLightVariable
extends FakePsiElement
implements FtlVariable {
    private final String myName;
    private final PsiElement myParent;
    private final FtlType myType;

    public FtlLightVariable(@NotNull @NonNls String name, @NotNull PsiElement parent, @NotNull @NonNls String psiType) {
        if (name == null) {
            FtlLightVariable.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            FtlLightVariable.$$$reportNull$$$0(1);
        }
        if (psiType == null) {
            FtlLightVariable.$$$reportNull$$$0(2);
        }
        this(name, parent, FtlLightVariable.createFtlType(parent, psiType));
    }

    public FtlLightVariable(@NotNull @NonNls String name, @NotNull PsiElement parent, @Nullable FtlType type) {
        if (name == null) {
            FtlLightVariable.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            FtlLightVariable.$$$reportNull$$$0(4);
        }
        this.myName = name;
        this.myParent = parent;
        this.myType = type;
    }

    @Nullable
    private static FtlPsiType createFtlType(@NotNull PsiElement context, @NonNls String text) {
        if (context == null) {
            FtlLightVariable.$$$reportNull$$$0(5);
        }
        try {
            return FtlPsiType.wrap(JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory().createTypeFromText(text, context));
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)super.getUseScope()), (FileType[])new FileType[]{FtlFileType.INSTANCE});
        if (globalSearchScope == null) {
            FtlLightVariable.$$$reportNull$$$0(6);
        }
        return globalSearchScope;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            FtlLightVariable.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = this.myParent;
        if (psiElement == null) {
            FtlLightVariable.$$$reportNull$$$0(8);
        }
        return psiElement;
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    public Icon getIcon(boolean open) {
        return PlatformIcons.VARIABLE_ICON;
    }

    @Override
    public FtlType getType() {
        return this.myType;
    }

    public boolean isEquivalentTo(PsiElement o) {
        return o instanceof FtlLightVariable && this.myName.equals(((FtlLightVariable)o).myName) && this.myParent.equals(((FtlLightVariable)o).myParent);
    }

    public String toString() {
        return "FtlLightVariable{name='" + this.myName + "', type=" + this.myType + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/psi/variables/FtlLightVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/psi/variables/FtlLightVariable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFtlType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

