/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.freemarker.FtlBuiltInDescriptor;
import com.intellij.freemarker.psi.FtlCollectionType;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.directives.FtlDirective;
import com.intellij.freemarker.psi.directives.FtlLoopVariable;
import com.intellij.freemarker.psi.variables.FtlCompositeType;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlListDirective
extends FtlDirective {
    public FtlListDirective(ASTNode node) {
        super(node);
    }

    @Nullable
    private FtlType getComponentType() {
        PsiElement parent;
        FtlExpression expression = this.getListExpression();
        if (expression == null && "items".equals(this.getDirectiveName()) && (parent = this.getParent()) instanceof FtlListDirective && "list".equals(((FtlListDirective)parent).getDirectiveName())) {
            expression = ((FtlListDirective)parent).getListExpression();
        }
        if (expression == null) {
            return null;
        }
        return FtlListDirective.getComponentType(expression.getType());
    }

    @Nullable
    public static FtlType getComponentType(FtlType type) {
        FtlCollectionType collectionType = FtlPsiUtil.asInstanceOf(type, FtlCollectionType.class);
        if (collectionType != null) {
            FtlType componentType = collectionType.getComponentType();
            return componentType == null ? FtlListDirective.unknownComponentType() : FtlListDirective.unboxIfNeeded(componentType);
        }
        FtlPsiType ftlPsiType = FtlPsiUtil.asInstanceOf(type, FtlPsiType.class);
        if (ftlPsiType == null) {
            return null;
        }
        PsiType psiType = ftlPsiType.getPsiType();
        if (psiType instanceof PsiArrayType) {
            return FtlListDirective.unboxIfNeeded(FtlPsiType.wrap(((PsiArrayType)psiType).getComponentType()));
        }
        return FtlListDirective.unboxIfNeeded(FtlPsiType.wrap(PsiUtil.extractIterableTypeParameter((PsiType)psiType, (boolean)true)));
    }

    private static FtlCompositeType unknownComponentType() {
        return new FtlCompositeType(new FtlType[0]);
    }

    public static boolean isCollectionType(FtlType type) {
        FtlCollectionType collectionType = FtlPsiUtil.asInstanceOf(type, FtlCollectionType.class);
        if (collectionType != null) {
            return true;
        }
        FtlPsiType ftlPsiType = FtlPsiUtil.asInstanceOf(type, FtlPsiType.class);
        if (ftlPsiType == null) {
            return false;
        }
        PsiType psiType = ftlPsiType.getPsiType();
        return psiType instanceof PsiArrayType || InheritanceUtil.isInheritor((PsiType)psiType, (String)"java.util.Collection") || InheritanceUtil.isInheritor((PsiType)psiType, (String)"java.lang.Iterable");
    }

    private static FtlType unboxIfNeeded(FtlType type) {
        FtlPsiType psiType;
        PsiPrimitiveType primitiveType;
        if (type instanceof FtlPsiType && (primitiveType = PsiPrimitiveType.getUnboxedType((PsiType)(psiType = (FtlPsiType)type).getPsiType())) != null) {
            return new FtlPsiType((PsiType)primitiveType);
        }
        return type;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            FtlListDirective.$$$reportNull$$$0(0);
        }
        if (state == null) {
            FtlListDirective.$$$reportNull$$$0(1);
        }
        if (place == null) {
            FtlListDirective.$$$reportNull$$$0(2);
        }
        if (lastParent == this.getListExpression()) {
            return true;
        }
        for (FtlLoopVariable variable : this.getMainLoopVariables()) {
            if (!processor.execute((PsiElement)variable, state)) {
                return false;
            }
            for (FtlLoopVariable depVariable : variable.getDependents()) {
                if (processor.execute((PsiElement)depVariable, state)) continue;
                return false;
            }
        }
        return this.processDirectiveDeclarations(processor, state, lastParent, false);
    }

    @Nullable
    public FtlExpression getListExpression() {
        return (FtlExpression)this.findChildByClass(FtlExpression.class);
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = (PsiReference[])ContainerUtil.map2Array(this.getMainLoopVariables(), PsiReference.class, var -> this.createReference((FtlLoopVariable)var, var.getNavigationElement()));
        if (psiReferenceArray == null) {
            FtlListDirective.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    @NotNull
    private PsiReferenceBase<PsiElement> createReference(final FtlLoopVariable var, final PsiElement nameElement) {
        TextRange range = TextRange.from((int)0, (int)nameElement.getTextLength()).shiftRight(nameElement.getStartOffsetInParent());
        return new PsiReferenceBase<PsiElement>((PsiElement)this, range){

            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                if (newElementName == null) {
                    1.$$$reportNull$$$0(0);
                }
                return nameElement;
            }

            public PsiElement resolve() {
                return var;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElementName", "com/intellij/freemarker/psi/directives/FtlListDirective$1", "handleElementRename"));
            }
        };
    }

    public List<PsiElement> getNameElements() {
        return this.findChildrenByType((IElementType)FtlElementTypes.IDENTIFIER);
    }

    public List<FtlLoopVariable> getMainLoopVariables() {
        return (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.calcMainLoopVariables(), (Object[])new Object[]{this}));
    }

    private List<FtlLoopVariable> calcMainLoopVariables() {
        List<PsiElement> nameElements = this.getNameElements();
        if (nameElements.size() == 1) {
            PsiElement id = nameElements.get(0);
            return Collections.singletonList(new FtlLoopVariable(this, id, true, (Computable<? extends FtlType>)((Computable)this::getComponentType)));
        }
        if (nameElements.size() == 2) {
            return Arrays.asList(new FtlLoopVariable(this, nameElements.get(0), false, (Computable<? extends FtlType>)((Computable)() -> this.getHashComponentType(0))), new FtlLoopVariable(this, nameElements.get(1), false, (Computable<? extends FtlType>)((Computable)() -> this.getHashComponentType(1))));
        }
        return Collections.emptyList();
    }

    @Nullable
    private FtlPsiType getHashComponentType(int typeParam) {
        FtlExpression expression = this.getListExpression();
        return expression == null ? null : FtlBuiltInDescriptor.HashBuiltIn.getHashComponentType(expression.getType(), typeParam);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/psi/directives/FtlListDirective";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/psi/directives/FtlListDirective";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

