/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi;

import com.intellij.freemarker.psi.FtlArgumentList;
import com.intellij.freemarker.psi.FtlEnumReference;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlIndexExpression;
import com.intellij.freemarker.psi.FtlInterpolation;
import com.intellij.freemarker.psi.FtlLiteralExpression;
import com.intellij.freemarker.psi.FtlMethodCallExpression;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.FtlReferenceExpression;
import com.intellij.freemarker.psi.FtlReferenceQualifier;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.directives.FtlFileReferenceDirective;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.tree.injected.StringLiteralEscaper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class FtlStringLiteral
extends FtlLiteralExpression
implements PsiLanguageInjectionHost {
    public FtlStringLiteral(ASTNode node) {
        super(node);
    }

    @Override
    public Object getConstantValue() {
        String s = this.getValueText();
        return !this.isRaw() && (s.contains("$") || s.contains("#")) ? null : s;
    }

    private boolean isRaw() {
        return this.getText().startsWith("r");
    }

    @NotNull
    public String getValueText() {
        String s = this.getText();
        if ((s = StringUtil.trimStart((String)s, (String)"r")).startsWith("\"") || s.startsWith("'")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"") || s.endsWith("'")) {
            s = s.substring(0, s.length() - 1);
        }
        String string = s;
        if (string == null) {
            FtlStringLiteral.$$$reportNull$$$0(0);
        }
        return string;
    }

    public int getValueStartOffset() {
        return this.getText().startsWith("r") ? 2 : 1;
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.calcReferences(), (Object[])new Object[]{this}));
        if (psiReferenceArray == null) {
            FtlStringLiteral.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    private PsiReference[] calcReferences() {
        FtlIndexExpression expression;
        for (PsiElement element : this.getChildren()) {
            if (!(element instanceof FtlInterpolation)) continue;
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement parent = this.getParent();
        final String valueText = this.getValueText();
        if (parent instanceof FtlIndexExpression && this == (expression = (FtlIndexExpression)parent).getExpression(1)) {
            return new PsiReference[]{new FtlQualifiedReference(expression){

                @Override
                public String getReferenceName() {
                    return valueText;
                }

                @Override
                @NotNull
                public FtlExpression getElement() {
                    FtlStringLiteral ftlStringLiteral = FtlStringLiteral.this;
                    if (ftlStringLiteral == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return ftlStringLiteral;
                }

                @Override
                public FtlReferenceQualifier getReferenceQualifier() {
                    return expression.getReferenceQualifier();
                }

                @NotNull
                public TextRange getRangeInElement() {
                    TextRange textRange = FtlStringLiteral.this.getValueRange();
                    if (textRange == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return textRange;
                }

                @Override
                public PsiElement doHandleElementRename(String newElementName) throws IncorrectOperationException {
                    return FtlStringLiteral.this.setStringValue(this.getRangeInElement(), newElementName);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/freemarker/psi/FtlStringLiteral$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getElement";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getRangeInElement";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            }};
        }
        if ((parent instanceof FtlFileReferenceDirective || this.isOptionalTemplateReference()) && StringUtil.isNotEmpty((String)valueText)) {
            return FtlFileReferenceDirective.createFileReferences(this);
        }
        if (!valueText.contains(" ")) {
            return new PsiReference[]{new FtlEnumReference(this), new PropertyReference(valueText, this, null, false){

                @NotNull
                public TextRange getRangeInElement() {
                    TextRange textRange = FtlStringLiteral.this.getValueRange();
                    if (textRange == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return textRange;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/FtlStringLiteral$2", "getRangeInElement"));
                }
            }};
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public boolean isOptionalTemplateReference() {
        PsiElement parent = this.getParent();
        if (parent instanceof FtlArgumentList && parent.getParent() instanceof FtlMethodCallExpression) {
            String got;
            FtlExpression called = ((FtlMethodCallExpression)parent.getParent()).getMethodExpression();
            String string = got = FtlPsiUtil.isUsingCamelCase(this.getContainingFtlFile()) ? ".getOptionalTemplate" : FtlPsiUtil.camelToSnakeCase(".getOptionalTemplate");
            assert (got != null);
            return called instanceof FtlReferenceExpression && got.equals(((FtlReferenceExpression)called).getReference().getReferenceName()) && ((FtlReferenceExpression)called).getReference().getReferenceQualifier() == null;
        }
        return false;
    }

    @Override
    public FtlType getType() {
        return FtlPsiType.wrap((PsiType)PsiType.getJavaLangString((PsiManager)this.getManager(), (GlobalSearchScope)this.getResolveScope()));
    }

    public TextRange getValueRange() {
        int start = 0;
        String text = this.getText();
        if (text.length() > 0 && text.charAt(0) == 'r') {
            ++start;
        }
        if (text.length() > start && FtlStringLiteral.isQuote(text.charAt(start))) {
            ++start;
        }
        int end = text.length();
        if (text.length() > 0 && end > start && FtlStringLiteral.isQuote(text.charAt(end - 1))) {
            --end;
        }
        return new TextRange(start, end);
    }

    public boolean isValidHost() {
        return true;
    }

    public FtlStringLiteral updateText(@NotNull String text) {
        if (text == null) {
            FtlStringLiteral.$$$reportNull$$$0(2);
        }
        this.setStringValue(this.getValueRange(), text);
        return this;
    }

    @NotNull
    public LiteralTextEscaper<FtlStringLiteral> createLiteralTextEscaper() {
        return new StringLiteralEscaper((PsiLanguageInjectionHost)this);
    }

    private static boolean isQuote(char c) {
        return c == '\"' || c == '\'';
    }

    public FtlStringLiteral setStringValue(TextRange range, String newContent) {
        String oldText = this.getText();
        String newText = oldText.substring(0, range.getStartOffset()) + newContent + oldText.substring(range.getEndOffset());
        PsiElement newElement = FtlPsiUtil.parseFtlExpression(newText, this.getProject());
        PsiElement parent = this.getParent();
        ASTNode newNode = newElement.getNode();
        parent.getNode().replaceChild(this.getNode(), newNode);
        return (FtlStringLiteral)newNode.getPsi();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/psi/FtlStringLiteral";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/psi/FtlStringLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

