/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PlatformIcons;
import icons.FreemarkerIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FtlCallableLookupElement
extends LookupElement {
    private final String myName;
    private final FtlCallableType myType;
    private final boolean myBuiltIn;
    private final Icon myIcon;

    public FtlCallableLookupElement(@NotNull String name, FtlCallableType type, boolean isBuiltIn) {
        if (name == null) {
            FtlCallableLookupElement.$$$reportNull$$$0(0);
        }
        this.myName = name;
        this.myType = type;
        this.myBuiltIn = isBuiltIn;
        this.myIcon = FtlCallableLookupElement.getCallableIcon(type, isBuiltIn);
    }

    public static Icon getCallableIcon(FtlCallableType type, boolean isBuiltIn) {
        return type.isMacro() ? FreemarkerIcons.Macro : (type.isFunction() || isBuiltIn ? PlatformIcons.FUNCTION_ICON : PlatformIcons.METHOD_ICON);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FtlCallableLookupElement)) {
            return false;
        }
        FtlCallableLookupElement that = (FtlCallableLookupElement)((Object)o);
        if (!this.myIcon.equals(that.myIcon)) {
            return false;
        }
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        return this.myType.equals(that.myType);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + this.myType.hashCode();
        result = 31 * result + this.myIcon.hashCode();
        return result;
    }

    @NotNull
    public String getLookupString() {
        String string = this.myName;
        if (string == null) {
            FtlCallableLookupElement.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void handleInsert(@NotNull InsertionContext context) {
        boolean hasParams;
        if (context == null) {
            FtlCallableLookupElement.$$$reportNull$$$0(2);
        }
        boolean bl = hasParams = this.myType.getParameters().length > 0;
        if (!(this.myType.isMacro() || this.myBuiltIn && !hasParams)) {
            (hasParams ? ParenthesesInsertHandler.WITH_PARAMETERS : ParenthesesInsertHandler.NO_PARAMETERS).handleInsert(context, (LookupElement)this);
        }
    }

    public void renderElement(LookupElementPresentation presentation) {
        presentation.setIcon(this.myIcon);
        presentation.setItemText(this.myName);
        presentation.setTailText(FtlCallableLookupElement.getSignature(this.myType));
        FtlType resultType = this.myType.getResultType();
        if (resultType != null) {
            presentation.setTypeText(resultType.getPresentableText());
        }
    }

    public static String getSignature(FtlCallableType type) {
        return "(" + StringUtil.join((Object[])type.getParameters(), variable -> {
            FtlType ftlType = variable.getType();
            return (String)(ftlType == null ? "" : ftlType.getPresentableText() + " ") + variable.getName();
        }, (String)", ") + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/psi/FtlCallableLookupElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/psi/FtlCallableLookupElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

