/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteSmartMacro;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.inspections.DefineInCommentIntentionBase;
import com.intellij.freemarker.lexer.FtlDirectiveStyle;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.directives.FtlFileReference;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class DefineFtlRootIntention
extends DefineInCommentIntentionBase {
    protected DefineFtlRootIntention(@Nls String text) {
        super(text);
    }

    @NotNull
    public String getFamilyName() {
        String string = FreeMarkerBundle.message("define.template.root.fix.name", new Object[0]);
        if (string == null) {
            DefineFtlRootIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiReference reference;
        if (project == null) {
            DefineFtlRootIntention.$$$reportNull$$$0(1);
        }
        if (!FtlPsiUtil.hasFtlViewProvider(file)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        CharSequence charSequence = editor.getDocument().getCharsSequence();
        if (charSequence.length() > offset && !Character.isJavaIdentifierPart(charSequence.charAt(offset))) {
            --offset;
        }
        if (!((reference = file.findReferenceAt(offset)) instanceof PsiMultiReference)) {
            return false;
        }
        FtlFileReference fileReference = (FtlFileReference)((Object)ContainerUtil.findInstance((Object[])((PsiMultiReference)reference).getReferences(), FtlFileReference.class));
        if (fileReference == null) {
            return false;
        }
        if (!fileReference.getFileReferenceSet().isAbsolutePathReference()) {
            return false;
        }
        if (fileReference.resolve() != null) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        return module != null;
    }

    @Override
    protected void fillTemplate(Template template, PsiFile targetFile, PsiFile sourceFile, FtlDirectiveStyle style, Editor editor) throws IncorrectOperationException {
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)targetFile.getProject());
        Document document = documentManager.getDocument(targetFile);
        assert (document != null);
        template.addTextSegment(style.getDirectiveStartChar() + "#-- @ftlroot \"");
        MacroCallNode pathExpression = new MacroCallNode((Macro)new CompleteSmartMacro());
        template.addVariable("NAME", (Expression)pathExpression, (Expression)pathExpression, true);
        template.addTextSegment("\" --" + style.getDirectiveEndChar() + "\n");
        template.addEndVariable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/inspections/DefineFtlRootIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/inspections/DefineFtlRootIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ModuleWide
    extends DefineFtlRootIntention {
        public ModuleWide() {
            super(FreeMarkerBundle.message("define.template.root.fix.name.module.wide", new Object[0]));
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                ModuleWide.$$$reportNull$$$0(0);
            }
            this.chooseTargetFile(file, editor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/freemarker/inspections/DefineFtlRootIntention$ModuleWide", "invoke"));
        }
    }

    public static class Local
    extends DefineFtlRootIntention {
        public Local() {
            super(FreeMarkerBundle.message("define.template.root.fix.name.local", new Object[0]));
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                Local.$$$reportNull$$$0(0);
            }
            this.addDeclaration(file, editor, file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/freemarker/inspections/DefineFtlRootIntention$Local", "invoke"));
        }
    }
}

