/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.inspections.CreateFromUsageIntentionBase;
import com.intellij.freemarker.lexer.FtlDirectiveStyle;
import com.intellij.freemarker.lexer.FtlLexer;
import com.intellij.freemarker.psi.FtlArgumentList;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlMethodCallExpression;
import com.intellij.freemarker.psi.FtlNameValuePair;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.FtlReferenceQualifier;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.directives.FtlMacro;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.freemarker.psi.variables.FtlTemplateType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class CreateSignatureDirectiveFromUsage
extends CreateFromUsageIntentionBase
implements IntentionAction {
    protected boolean myMacro;
    protected String myName;
    private String[] myParameterNames;
    private boolean mySkipParameterNames;

    @NotNull
    public String getFamilyName() {
        String string = FreeMarkerBundle.message("create.macro.or.function.from.usage", new Object[0]);
        if (string == null) {
            CreateSignatureDirectiveFromUsage.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            CreateSignatureDirectiveFromUsage.$$$reportNull$$$0(1);
        }
        if (!(file instanceof FtlFile)) {
            return false;
        }
        FtlQualifiedReference reference = CreateSignatureDirectiveFromUsage.findQualifiedReference(editor, file);
        if (reference == null) {
            return false;
        }
        FtlReferenceQualifier qualifier = reference.getReferenceQualifier();
        if (qualifier != null && FtlPsiUtil.asInstanceOf(qualifier.getType(), FtlTemplateType.class) == null) {
            return false;
        }
        FtlCallableType callableType = FtlPsiUtil.asInstanceOf(reference.getType(), FtlCallableType.class);
        this.myName = reference.getReferenceName();
        PsiElement parent = reference.getExpressionParent();
        if (parent instanceof FtlMacro) {
            if (callableType != null && callableType.isMacro()) {
                return false;
            }
            this.myMacro = true;
            FtlArgumentList argumentList = ((FtlMacro)parent).getArgumentList();
            if (argumentList.isPositional()) {
                this.fillPositionalArguments(argumentList);
            } else {
                this.mySkipParameterNames = true;
                FtlNameValuePair[] arguments = argumentList.getNamedArguments();
                this.myParameterNames = ArrayUtil.newStringArray((int)arguments.length);
                for (int i = 0; i < arguments.length; ++i) {
                    this.myParameterNames[i] = arguments[i].getName();
                }
            }
            return true;
        }
        if (parent instanceof FtlMethodCallExpression) {
            if (callableType != null && !callableType.isMacro()) {
                return false;
            }
            this.myMacro = false;
            this.fillPositionalArguments(((FtlMethodCallExpression)parent).getArgumentList());
            return true;
        }
        return false;
    }

    public final void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        FtlFile nsFile;
        FtlQualifiedReference reference;
        if (project == null) {
            CreateSignatureDirectiveFromUsage.$$$reportNull$$$0(2);
        }
        if ((reference = CreateSignatureDirectiveFromUsage.findQualifiedReference(editor, file)) == null) {
            return;
        }
        FtlReferenceQualifier qualifier = reference.getReferenceQualifier();
        if (qualifier != null) {
            FtlTemplateType type = FtlPsiUtil.asInstanceOf(qualifier.getType(), FtlTemplateType.class);
            if (type == null) {
                return;
            }
            nsFile = type.getTemplateFile();
        } else {
            nsFile = (FtlFile)file;
        }
        this.doCreateSignatureDirective(project, editor, file, nsFile);
    }

    public abstract void doCreateSignatureDirective(@NotNull Project var1, Editor var2, PsiFile var3, FtlFile var4) throws IncorrectOperationException;

    private void fillPositionalArguments(FtlArgumentList argumentList) {
        this.mySkipParameterNames = false;
        FtlExpression[] arguments = argumentList.getPositionalArguments();
        THashSet usedNames = new THashSet();
        JavaCodeStyleManager manager = JavaCodeStyleManager.getInstance((Project)argumentList.getProject());
        this.myParameterNames = ArrayUtil.newStringArray((int)arguments.length);
        for (int i = 0; i < arguments.length; ++i) {
            Object paramName;
            FtlExpression argument = arguments[i];
            FtlType type = argument.getType();
            FtlPsiType psiType = FtlPsiUtil.asInstanceOf(type, FtlPsiType.class);
            if (psiType != null) {
                paramName = CreateSignatureDirectiveFromUsage.suggestParameterName((Set<? super String>)usedNames, manager, psiType.getPsiType());
            } else {
                paramName = "param" + i;
                usedNames.add(paramName);
            }
            this.myParameterNames[i] = paramName;
        }
    }

    public static String suggestParameterName(Set<? super String> usedNames, JavaCodeStyleManager manager, PsiType type) {
        Object paramName;
        String candidate = manager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)type).names[0];
        assert (candidate != null);
        if (usedNames.contains(candidate)) {
            int j = 2;
            while (usedNames.contains(candidate + j)) {
                ++j;
            }
            paramName = candidate + j;
        } else {
            paramName = candidate;
        }
        usedNames.add((String)paramName);
        return paramName;
    }

    @Override
    protected void addDeclaration(PsiFile sourceFile, Editor sourceEditor, PsiFile targetFile, Editor editor) {
        Project project = sourceFile.getProject();
        CreateSignatureDirectiveFromUsage.prepareInsertionPlace(sourceFile, targetFile, editor);
        FtlDirectiveStyle style = FtlLexer.guessDirectiveStyle(editor.getDocument().getCharsSequence());
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        Template template = manager.createTemplate("", "");
        @NonNls String directiveName = "#" + (this.myMacro ? "macro" : "function");
        template.addTextSegment(style.getDirectiveStartChar() + directiveName + " " + this.myName);
        for (int i = 0; i < this.myParameterNames.length; ++i) {
            template.addTextSegment(" ");
            ConstantNode expression = new ConstantNode(this.myParameterNames[i]);
            template.addVariable("PARAM" + i, (Expression)expression, (Expression)expression, !this.mySkipParameterNames);
        }
        template.addTextSegment(String.valueOf(style.getDirectiveEndChar()));
        template.addEndVariable();
        template.addTextSegment(style.getDirectiveStartChar() + "/" + directiveName + style.getDirectiveEndChar());
        manager.startTemplate(editor, template);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/inspections/CreateSignatureDirectiveFromUsage";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/inspections/CreateSignatureDirectiveFromUsage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Implicit
    extends CreateSignatureDirectiveFromUsage {
        @NotNull
        public String getText() {
            String string = this.myMacro ? FreeMarkerBundle.message("define.implicit.macro.from.usage", this.myName) : FreeMarkerBundle.message("define.implicit.function.from.usage", this.myName);
            if (string == null) {
                Implicit.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                Implicit.$$$reportNull$$$0(1);
            }
            if (!(file instanceof FtlFile)) {
                return false;
            }
            FtlQualifiedReference reference = Implicit.findQualifiedReference(editor, file);
            if (reference == null) {
                return false;
            }
            FtlReferenceQualifier qualifier = reference.getReferenceQualifier();
            return qualifier == null && super.isAvailable(project, editor, file);
        }

        @Override
        public void doCreateSignatureDirective(@NotNull Project project, Editor editor, PsiFile file, FtlFile myNamespaceFile) throws IncorrectOperationException {
            if (project == null) {
                Implicit.$$$reportNull$$$0(2);
            }
            this.chooseTargetFile(file, editor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/freemarker/inspections/CreateSignatureDirectiveFromUsage$Implicit";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/freemarker/inspections/CreateSignatureDirectiveFromUsage$Implicit";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doCreateSignatureDirective";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Explicit
    extends CreateSignatureDirectiveFromUsage {
        @NotNull
        public String getText() {
            String string = this.myMacro ? FreeMarkerBundle.message("create.macro.from.usage", this.myName) : FreeMarkerBundle.message("create.function.from.usage", this.myName);
            if (string == null) {
                Explicit.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doCreateSignatureDirective(@NotNull Project project, Editor editor, PsiFile file, FtlFile myNamespaceFile) throws IncorrectOperationException {
            if (project == null) {
                Explicit.$$$reportNull$$$0(1);
            }
            this.addDeclaration(file, editor, (PsiFile)myNamespaceFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/freemarker/inspections/CreateSignatureDirectiveFromUsage$Explicit";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/freemarker/inspections/CreateSignatureDirectiveFromUsage$Explicit";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "doCreateSignatureDirective";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

