/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.editorActions;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.i18n.I18nQuickFixHandler;
import com.intellij.codeInspection.i18n.I18nizeAction;
import com.intellij.codeInspection.i18n.I18nizeHandlerProvider;
import com.intellij.codeInspection.i18n.JavaI18nizeQuickFixDialog;
import com.intellij.freemarker.psi.FtlStringLiteral;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertyCreationHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UExpression;

public class FtlI18nProvider
extends I18nizeHandlerProvider {
    @Nullable
    public I18nQuickFixHandler<?> getHandler(@NotNull PsiFile psiFile, @NotNull Editor editor, @NotNull TextRange range) {
        if (psiFile == null) {
            FtlI18nProvider.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            FtlI18nProvider.$$$reportNull$$$0(1);
        }
        if (range == null) {
            FtlI18nProvider.$$$reportNull$$$0(2);
        }
        if (FtlI18nProvider.findLiteral(psiFile, editor) != null) {
            return new FtlLiteralI18nizer();
        }
        return null;
    }

    private static FtlStringLiteral findLiteral(@NotNull PsiFile psiFile, @NotNull Editor editor) {
        if (psiFile == null) {
            FtlI18nProvider.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            FtlI18nProvider.$$$reportNull$$$0(4);
        }
        return (FtlStringLiteral)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)editor.getCaretModel().getOffset(), FtlStringLiteral.class, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/freemarker/editorActions/FtlI18nProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getHandler";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findLiteral";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FtlLiteralI18nizer
    implements I18nQuickFixHandler<UExpression> {
        private static final String FREEMARKER_I18N_EXPRESSION = "freemarker.i18n.expression";
        private static final String DEFAULT_VALUE = "enterExpression";

        public void checkApplicability(PsiFile psiFile, Editor editor) throws IncorrectOperationException {
            FtlLiteralI18nizer.getLiteralText(psiFile, editor);
        }

        @NotNull
        private static String getLiteralText(PsiFile psiFile, Editor editor) {
            FtlStringLiteral literal = FtlI18nProvider.findLiteral(psiFile, editor);
            if (literal == null) {
                throw new IncorrectOperationException("Please place caret on a string literal");
            }
            String string = literal.getValueText();
            if (string == null) {
                FtlLiteralI18nizer.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void performI18nization(PsiFile psiFile, Editor editor, UExpression literalExpression, Collection<PropertiesFile> propertiesFiles, String key, String value, String i18nizedText, UExpression[] parameters, PropertyCreationHandler propertyCreationHandler) throws IncorrectOperationException {
            propertyCreationHandler.createProperty(psiFile.getProject(), propertiesFiles, key, value, parameters);
            this.replaceWithPropertyAccess(psiFile, editor, key);
        }

        public UExpression getEnclosingLiteral(PsiFile file, Editor editor) {
            return I18nizeAction.getEnclosingStringLiteral((PsiFile)file, (Editor)editor);
        }

        @VisibleForTesting
        public void replaceWithPropertyAccess(PsiFile psiFile, Editor editor, String key) {
            FtlStringLiteral literal = FtlI18nProvider.findLiteral(psiFile, editor);
            assert (literal != null);
            TextRange range = literal.getTextRange();
            editor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)("(\"" + key + "\")"));
            FtlLiteralI18nizer.editI18nExpression(editor, psiFile.getProject(), range.getStartOffset());
        }

        public JavaI18nizeQuickFixDialog<UExpression> createDialog(Project project, Editor editor, PsiFile psiFile) {
            return new JavaI18nizeQuickFixDialog(project, psiFile, null, FtlLiteralI18nizer.getLiteralText(psiFile, editor), null, false, false);
        }

        private static void editI18nExpression(final Editor editor, Project project, int offset) {
            editor.getSelectionModel().removeSelection();
            editor.getCaretModel().moveToOffset(offset);
            final RangeMarker marker = editor.getDocument().createRangeMarker(offset, offset);
            marker.setGreedyToLeft(true);
            marker.setGreedyToRight(true);
            final PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
            Template template = TemplateManager.getInstance((Project)project).createTemplate("", "");
            template.addVariable((Expression)new ConstantNode(propertiesComponent.getValue(FREEMARKER_I18N_EXPRESSION, DEFAULT_VALUE)), true);
            TemplateManager.getInstance((Project)project).startTemplate(editor, template, (TemplateEditingListener)new TemplateEditingAdapter(){

                public void templateFinished(@NotNull Template template, boolean brokenOff) {
                    if (template == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!brokenOff && marker.isValid()) {
                        String newExpr = editor.getDocument().getText().substring(marker.getStartOffset(), marker.getEndOffset());
                        propertiesComponent.setValue(FtlLiteralI18nizer.FREEMARKER_I18N_EXPRESSION, newExpr, FtlLiteralI18nizer.DEFAULT_VALUE);
                    }
                    marker.dispose();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/freemarker/editorActions/FtlI18nProvider$FtlLiteralI18nizer$1", "templateFinished"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/editorActions/FtlI18nProvider$FtlLiteralI18nizer", "getLiteralText"));
        }
    }
}

