/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker;

import com.intellij.freemarker.psi.files.FtlSyntaxHighlighter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import icons.FreemarkerIcons;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FtlColorSettingsPage
implements ColorSettingsPage {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.freemarker.FtlColorSettingsPage");

    @Nullable
    public Icon getIcon() {
        return FreemarkerIcons.FreemarkerIcon;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        return new FtlSyntaxHighlighter();
    }

    @NotNull
    public String getDemoText() {
        return "[#if group.userCount()>settings.minUserCount]\n[/#if]\n[#foreach v in [1,'2']]\n  ${v}[/#foreach]\n[#-- comment --]";
    }

    @Nullable
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return null;
    }

    public AttributesDescriptor @NotNull [] getAttributeDescriptors() {
        ArrayList<AttributesDescriptor> descriptors = new ArrayList<AttributesDescriptor>();
        for (Field field : FtlSyntaxHighlighter.class.getFields()) {
            if (!field.getName().startsWith("FTL_")) continue;
            try {
                @NlsSafe String name = StringUtil.capitalize((String)StringUtil.toLowerCase((String)field.getName().substring("FTL_".length()).replace('_', ' ')));
                descriptors.add(new AttributesDescriptor(name, (TextAttributesKey)field.get(null)));
            }
            catch (IllegalAccessException e) {
                LOG.error((Throwable)e);
            }
        }
        AttributesDescriptor[] attributesDescriptorArray = descriptors.toArray(new AttributesDescriptor[0]);
        if (attributesDescriptorArray == null) {
            FtlColorSettingsPage.$$$reportNull$$$0(0);
        }
        return attributesDescriptorArray;
    }

    public ColorDescriptor @NotNull [] getColorDescriptors() {
        if (ColorDescriptor.EMPTY_ARRAY == null) {
            FtlColorSettingsPage.$$$reportNull$$$0(1);
        }
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    @NonNls
    public String getDisplayName() {
        return "FreeMarker";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/freemarker/FtlColorSettingsPage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDescriptors";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorDescriptors";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

