/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.frameworks.data.util.parser;

import com.intellij.jpa.frameworks.data.util.parser.Part;
import com.intellij.jpa.frameworks.data.util.parser.PartTree;
import com.intellij.jpa.frameworks.data.util.parser.domain.OrderBySource;
import com.intellij.jpa.frameworks.data.util.parser.domain.Sort;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PartTreeParserUtil {
    @NotNull
    public static Map<Part, TextRange> getPartTextRanges(@NotNull PartTree partTree) {
        if (partTree == null) {
            PartTreeParserUtil.$$$reportNull$$$0(0);
        }
        HashMap<Part, TextRange> textRanges = new HashMap<Part, TextRange>();
        String methodName = partTree.getSource();
        PartTree.Subject subject = partTree.getSubject();
        int previousPartEndOffset = subject != null && subject.getExpression() != null ? subject.getExpression().length() : 0;
        for (PartTree.OrPart orPart : partTree) {
            Iterator<Part> iterator = orPart.iterator();
            while (iterator.hasNext()) {
                Part part = iterator.next();
                int startOffset = methodName.indexOf(part.getSource(), previousPartEndOffset);
                TextRange range = TextRange.create((int)startOffset, (int)(startOffset + part.getSource().length()));
                textRanges.put(part, range);
                previousPartEndOffset = range.getEndOffset() + (iterator.hasNext() ? "And".length() : "Or".length());
            }
        }
        HashMap<Part, TextRange> hashMap = textRanges;
        if (hashMap == null) {
            PartTreeParserUtil.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    @NotNull
    public static Map<Sort.Order, TextRange> getSortTextRanges(@NotNull PartTree partTree) {
        if (partTree == null) {
            PartTreeParserUtil.$$$reportNull$$$0(2);
        }
        HashMap<Sort.Order, TextRange> textRanges = new HashMap<Sort.Order, TextRange>();
        String methodName = partTree.getSource();
        OrderBySource orderBy = partTree.getOrderBySource();
        if (orderBy != null) {
            TextRange lastTextRange = TextRange.create((int)0, (int)partTree.getSource().indexOf("OrderBy" + orderBy.getSource()));
            for (TextRange range : PartTreeParserUtil.getPartTextRanges(partTree).values()) {
                if (lastTextRange.getEndOffset() >= range.getEndOffset()) continue;
                lastTextRange = range;
            }
            for (Sort.Order order : orderBy.getOrders()) {
                int startOffset = methodName.indexOf(StringUtil.capitalize((String)order.getPropertySourceExpression()), lastTextRange.getEndOffset());
                TextRange range = TextRange.create((int)startOffset, (int)(startOffset + order.getSortExpression().length()));
                textRanges.put(order, range);
                lastTextRange = range;
            }
        }
        HashMap<Sort.Order, TextRange> hashMap = textRanges;
        if (hashMap == null) {
            PartTreeParserUtil.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partTree";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/frameworks/data/util/parser/PartTreeParserUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/frameworks/data/util/parser/PartTreeParserUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPartTextRanges";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortTextRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPartTextRanges";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSortTextRanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

