/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.frameworks.data.util.parser;

import com.intellij.jpa.frameworks.data.util.parser.Part;
import com.intellij.jpa.frameworks.data.util.parser.PartTreeParserContext;
import com.intellij.jpa.frameworks.data.util.parser.PartType;
import com.intellij.jpa.frameworks.data.util.parser.domain.OrderBySource;
import com.intellij.jpa.frameworks.data.util.parser.domain.Sort;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PartTree
implements Iterable<OrPart> {
    private final Subject subject;
    private final Predicate predicate;
    private final String mySource;
    private final PartTreeParserContext myParserContext;

    public PartTree(@NotNull String source, @NotNull PsiClass domainClass, @NotNull PartTreeParserContext parserContext) {
        if (source == null) {
            PartTree.$$$reportNull$$$0(0);
        }
        if (domainClass == null) {
            PartTree.$$$reportNull$$$0(1);
        }
        if (parserContext == null) {
            PartTree.$$$reportNull$$$0(2);
        }
        this.mySource = source;
        this.myParserContext = parserContext;
        Matcher matcher = parserContext.prefixTemplate().matcher(source);
        if (!matcher.find()) {
            this.subject = new Subject(null);
            this.predicate = new Predicate(source, domainClass);
        } else {
            this.subject = new Subject(matcher.group(0));
            this.predicate = new Predicate(source.substring(matcher.group().length()), domainClass);
        }
    }

    public String getSource() {
        return this.mySource;
    }

    @Override
    public Iterator<OrPart> iterator() {
        return this.predicate.iterator();
    }

    public Sort getSort() {
        OrderBySource orderBySource = this.getOrderBySource();
        return orderBySource == null ? null : orderBySource.toSort();
    }

    @Nullable
    public OrderBySource getOrderBySource() {
        return this.predicate.getOrderBySource();
    }

    public boolean isDistinct() {
        return this.subject.isDistinct();
    }

    public Boolean isCountProjection() {
        return this.subject.isCountProjection();
    }

    public Boolean isExistsProjection() {
        return this.subject.isExistsProjection();
    }

    public Boolean isDelete() {
        return this.subject.isDelete();
    }

    public boolean isLimiting() {
        return this.getMaxResults() != null;
    }

    public Integer getMaxResults() {
        return this.subject.getMaxResults();
    }

    public List<Part> getParts() {
        ArrayList<Part> result = new ArrayList<Part>();
        for (OrPart orPart : this) {
            for (Part part : orPart) {
                result.add(part);
            }
        }
        return result;
    }

    public Iterable<Part> getParts(PartType type) {
        ArrayList<Part> result = new ArrayList<Part>();
        for (Part part : this.getParts()) {
            if (!part.getType().equals(type)) continue;
            result.add(part);
        }
        return result;
    }

    public String toString() {
        OrderBySource orderBySource = this.getOrderBySource();
        return String.format("%s%s", StringUtil.join(this.predicate.nodes, (String)" or "), orderBySource == null ? "" : " " + orderBySource);
    }

    private String[] split(String text, String keyword) {
        if (text.equals(keyword)) {
            return new String[]{"", ""};
        }
        String format = String.format(this.myParserContext.keywordTemplate(), keyword);
        if (text.endsWith(keyword)) {
            List splitted = StringUtil.split((String)text, (String)keyword);
            splitted.add("");
            return ArrayUtilRt.toStringArray((Collection)splitted);
        }
        Pattern pattern = Pattern.compile(format);
        return pattern.split(text);
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "source";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "domainClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "parserContext";
                break;
            }
        }
        objectArray[1] = "com/intellij/jpa/frameworks/data/util/parser/PartTree";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class Predicate {
        private final Pattern ALL_IGNORE_CASE;
        private static final String ORDER_BY = "OrderBy";
        private final List<OrPart> nodes;
        private final OrderBySource orderBySource;
        private boolean alwaysIgnoreCase;

        Predicate(@NotNull String predicate, PsiClass domainClass) {
            if (predicate == null) {
                Predicate.$$$reportNull$$$0(0);
            }
            if (domainClass == null) {
                Predicate.$$$reportNull$$$0(1);
            }
            this.ALL_IGNORE_CASE = Pattern.compile("AllIgnor(ing|e)Case");
            this.nodes = new ArrayList<OrPart>();
            String[] parts = PartTree.this.split(this.detectAndSetAllIgnoreCase(predicate), ORDER_BY);
            if (parts.length > 2) {
                // empty if block
            }
            this.buildTree(parts[0], domainClass);
            this.orderBySource = parts.length == 2 ? new OrderBySource(parts[1], domainClass) : null;
        }

        private String detectAndSetAllIgnoreCase(String predicate) {
            Matcher matcher = this.ALL_IGNORE_CASE.matcher((CharSequence)predicate);
            if (matcher.find()) {
                this.alwaysIgnoreCase = true;
                predicate = ((String)predicate).substring(0, matcher.start()) + ((String)predicate).substring(matcher.end());
            }
            return predicate;
        }

        private void buildTree(@NotNull String source, @NotNull PsiClass domainClass) {
            String[] split;
            if (source == null) {
                Predicate.$$$reportNull$$$0(2);
            }
            if (domainClass == null) {
                Predicate.$$$reportNull$$$0(3);
            }
            for (String part : split = PartTree.this.split(source, "Or")) {
                this.nodes.add(new OrPart(part, domainClass, this.alwaysIgnoreCase));
            }
        }

        public Iterator<OrPart> iterator() {
            return this.nodes.iterator();
        }

        public OrderBySource getOrderBySource() {
            return this.orderBySource;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "domainClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/jpa/frameworks/data/util/parser/PartTree$Predicate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buildTree";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class Subject {
        private static final String DISTINCT = "Distinct";
        private final Pattern COUNT_BY_TEMPLATE = Pattern.compile("^count(\\p{Lu}.*?)??By");
        private final Pattern EXISTS_BY_TEMPLATE;
        private final Pattern DELETE_BY_TEMPLATE;
        private static final String LIMITING_QUERY_PATTERN = "(First|Top)(\\d*)?";
        private final Pattern LIMITED_QUERY_TEMPLATE;
        private final String myExpression;
        private final boolean distinct;
        private final boolean exists;
        private final boolean count;
        private final boolean delete;
        private final Integer maxResults;

        public Subject(String subject) {
            this.EXISTS_BY_TEMPLATE = Pattern.compile("^(" + PartTree.this.myParserContext.existsPattern() + ")(\\p{Lu}.*?)??By");
            this.DELETE_BY_TEMPLATE = Pattern.compile("^(" + PartTree.this.myParserContext.deleteUpdatePattern() + ")(\\p{Lu}.*?)??By");
            this.LIMITED_QUERY_TEMPLATE = Pattern.compile("^(" + PartTree.this.myParserContext.queryPattern() + ")(Distinct)?(First|Top)(\\d*)?(\\p{Lu}.*?)??By");
            this.myExpression = subject;
            this.distinct = subject == null ? false : subject.contains(DISTINCT);
            this.count = this.matches(subject, this.COUNT_BY_TEMPLATE);
            this.delete = this.matches(subject, this.DELETE_BY_TEMPLATE);
            this.exists = this.matches(subject, this.EXISTS_BY_TEMPLATE);
            this.maxResults = this.returnMaxResultsIfFirstKSubjectOrNull(subject);
        }

        private Integer returnMaxResultsIfFirstKSubjectOrNull(String subject) {
            if (subject == null) {
                return null;
            }
            Matcher grp = this.LIMITED_QUERY_TEMPLATE.matcher(subject);
            if (!grp.find()) {
                return null;
            }
            return StringUtil.isNotEmpty((String)grp.group(4)) ? Integer.valueOf(grp.group(4)) : 1;
        }

        public Boolean isDelete() {
            return this.delete;
        }

        public boolean isCountProjection() {
            return this.count;
        }

        public boolean isExistsProjection() {
            return this.exists;
        }

        public boolean isDistinct() {
            return this.distinct;
        }

        public Integer getMaxResults() {
            return this.maxResults;
        }

        private boolean matches(String subject, Pattern pattern) {
            return subject != null && pattern.matcher(subject).find();
        }

        public String getExpression() {
            return this.myExpression;
        }

        public String toString() {
            return "SUBJECT ('" + this.myExpression + ")";
        }
    }

    public class OrPart
    implements Iterable<Part> {
        private final List<Part> children;
        private final String mySource;

        OrPart(String source, PsiClass domainClass, boolean alwaysIgnoreCase) {
            String[] split;
            if (source == null) {
                OrPart.$$$reportNull$$$0(0);
            }
            this.children = new ArrayList<Part>();
            this.mySource = source;
            for (String part : split = PartTree.this.split(source, "And")) {
                this.children.add(new Part(part, domainClass, alwaysIgnoreCase, PartTree.this.myParserContext));
            }
        }

        @Override
        public Iterator<Part> iterator() {
            return this.children.iterator();
        }

        public String toString() {
            return "OR ('" + this.mySource + "')";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/jpa/frameworks/data/util/parser/PartTree$OrPart", "<init>"));
        }
    }
}

