/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.frameworks.data.util.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jpa.frameworks.data.util.FrameworksDataBundle;
import com.intellij.jpa.frameworks.data.util.parser.Part;
import com.intellij.jpa.frameworks.data.util.parser.PartTree;
import com.intellij.jpa.frameworks.data.util.parser.PartTreeParserUtil;
import com.intellij.jpa.frameworks.data.util.parser.domain.OrderBySource;
import com.intellij.jpa.frameworks.data.util.parser.domain.PropertyPath;
import com.intellij.jpa.frameworks.data.util.parser.domain.Sort;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;

public class PartTreeInconsistencyUtils {
    public static void checkParts(@NotNull ProblemsHolder holder, @NotNull UMethod uMethod, @NotNull PartTree partTree) {
        List<Part> parts;
        if (holder == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(0);
        }
        if (uMethod == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(1);
        }
        if (partTree == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(2);
        }
        if ((parts = partTree.getParts()).size() == 1 && StringUtil.isEmptyOrSpaces((String)parts.get(0).getSource())) {
            return;
        }
        for (Part part : parts) {
            for (PropertyPath property : part.getProperty()) {
                PsiElement psiIdentifier;
                PsiType type = property.getType();
                if (type != null || (psiIdentifier = UElementKt.getSourcePsiElement((UElement)uMethod.getUastAnchor())) == null) continue;
                String propertyName = property.getSegment();
                if (StringUtil.isEmptyOrSpaces((String)propertyName)) {
                    PartTreeInconsistencyUtils.addEmptyPropertyProblem(holder, uMethod.getName(), partTree, part, psiIdentifier);
                    continue;
                }
                TextRange range = PartTreeInconsistencyUtils.getTextRange(partTree, property);
                if (range == null) continue;
                holder.registerProblem(psiIdentifier, range, FrameworksDataBundle.message("cannot.resolve.property", propertyName), new LocalQuickFix[0]);
            }
        }
    }

    public static void checkOrderBy(@NotNull ProblemsHolder holder, @NotNull UMethod uMethod, PartTree partTree) {
        PsiElement identifier;
        OrderBySource source;
        if (holder == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(3);
        }
        if (uMethod == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(4);
        }
        if ((source = partTree.getOrderBySource()) != null && (identifier = UElementKt.getSourcePsiElement((UElement)uMethod.getUastAnchor())) != null) {
            for (Map.Entry<Sort.Order, TextRange> entry : PartTreeParserUtil.getSortTextRanges(partTree).entrySet()) {
                Sort.Order order = entry.getKey();
                for (PropertyPath property : order.getPropertyPath()) {
                    PsiType type = property.getType();
                    if (type != null) continue;
                    String propertyName = property.getSegment();
                    if (StringUtil.isEmptyOrSpaces((String)propertyName)) {
                        String msg = PartTreeInconsistencyUtils.getEmptyPropertyMessage(uMethod.getName(), entry.getValue());
                        holder.registerProblem(identifier, FrameworksDataBundle.message("empty.property.with.empty.text.range", msg), new LocalQuickFix[0]);
                        continue;
                    }
                    TextRange range = PartTreeInconsistencyUtils.getOrderByRange(partTree, property);
                    if (range == null) continue;
                    holder.registerProblem(identifier, range, FrameworksDataBundle.message("cannot.resolve.property", propertyName), new LocalQuickFix[0]);
                }
            }
        }
    }

    private static void addEmptyPropertyProblem(@NotNull ProblemsHolder holder, String methodName, PartTree partTree, Part part, PsiElement psiIdentifier) {
        if (holder == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(5);
        }
        if (methodName.equals(partTree.getSubject().getExpression())) {
            return;
        }
        Map<Part, TextRange> textRanges = PartTreeParserUtil.getPartTextRanges(partTree);
        TextRange range = textRanges.get(part);
        if (range != null) {
            if (range.getStartOffset() == range.getEndOffset()) {
                String msg = PartTreeInconsistencyUtils.getEmptyPropertyMessage(methodName, range);
                holder.registerProblem(psiIdentifier, FrameworksDataBundle.message("empty.property.with.empty.text.range", msg), new LocalQuickFix[0]);
            } else {
                holder.registerProblem(psiIdentifier, range, FrameworksDataBundle.message("empty.property", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    @NotNull
    private static String getEmptyPropertyMessage(String methodName, TextRange range) {
        String string = methodName.substring(0, range.getStartOffset()) + "<EMPTY_PROPERTY>" + methodName.substring(range.getEndOffset());
        if (string == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    private static TextRange getTextRange(@NotNull PartTree partTree, @NotNull PropertyPath property) {
        if (partTree == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(7);
        }
        if (property == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(8);
        }
        String methodName = partTree.getSource();
        String propertyName = property.getSegment();
        Map<Part, TextRange> textRanges = PartTreeParserUtil.getPartTextRanges(partTree);
        for (Map.Entry<Part, TextRange> entry : textRanges.entrySet()) {
            for (PropertyPath path : entry.getKey().getProperty()) {
                int startOffset;
                if (!path.equals(property) || (startOffset = methodName.indexOf(StringUtil.capitalize((String)propertyName), entry.getValue().getStartOffset())) < 0) continue;
                return TextRange.create((int)startOffset, (int)(startOffset + propertyName.length()));
            }
        }
        return null;
    }

    @Nullable
    private static TextRange getOrderByRange(@NotNull PartTree partTree, @NotNull PropertyPath property) {
        if (partTree == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(9);
        }
        if (property == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(10);
        }
        String methodName = partTree.getSource();
        String propertyName = property.getSegment();
        Map<Sort.Order, TextRange> textRanges = PartTreeParserUtil.getSortTextRanges(partTree);
        for (Map.Entry<Sort.Order, TextRange> entry : textRanges.entrySet()) {
            for (PropertyPath path : entry.getKey().getPropertyPath()) {
                if (!path.equals(property)) continue;
                int startOffset = methodName.indexOf(StringUtil.capitalize((String)propertyName), entry.getValue().getStartOffset());
                return TextRange.create((int)startOffset, (int)(startOffset + propertyName.length()));
            }
        }
        return null;
    }

    public static boolean hasUnresolvedPropertyPaths(@NotNull PartTree partTree) {
        if (partTree == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(11);
        }
        for (Part part : partTree.getParts()) {
            for (PropertyPath property : part.getProperty()) {
                PsiType type = property.getType();
                if (type != null) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static List<PsiType> getRequiredParameterTypes(@NotNull Iterable<Part> parts, @NotNull Project project, @NotNull Condition<Part> isCollectionTypeRequired, @NotNull Condition<Part> isCollectionElementTypeRequired) {
        if (parts == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(12);
        }
        if (project == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(13);
        }
        if (isCollectionTypeRequired == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(14);
        }
        if (isCollectionElementTypeRequired == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(15);
        }
        LinkedList<PsiType> psiTypes = new LinkedList<PsiType>();
        for (Part part : parts) {
            PsiType psiType = part.getProperty().getLeafProperty().getType();
            if (psiType == null) continue;
            if (isCollectionTypeRequired.value((Object)part)) {
                psiType = PartTreeInconsistencyUtils.createTypedCollection(project, psiType);
            } else if (isCollectionElementTypeRequired.value((Object)part)) {
                psiType = PartTreeInconsistencyUtils.getCollectionOrStringElementType(project, psiType);
            }
            int argumentsNumber = part.getType().getNumberOfArguments();
            for (int i = 0; i < argumentsNumber; ++i) {
                ContainerUtil.addAllNotNull(psiTypes, (Object[])new PsiType[]{psiType});
            }
        }
        LinkedList<PsiType> linkedList = psiTypes;
        if (linkedList == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(16);
        }
        return linkedList;
    }

    @Nullable
    public static PsiType createTypedCollection(@NotNull Project project, @NotNull PsiType psiType) {
        PsiClass aClass;
        if (project == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(17);
        }
        if (psiType == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(18);
        }
        if ((aClass = PartTreeInconsistencyUtils.getCollectionClass(project)) == null || aClass.getTypeParameters().length != 1) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)project).getElementFactory().createType(aClass, psiType);
    }

    @Nullable
    public static PsiType getCollectionOrStringElementType(@NotNull Project project, @NotNull PsiType psiType) {
        GlobalSearchScope resolveScope;
        if (project == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(19);
        }
        if (psiType == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(20);
        }
        if ((resolveScope = psiType.getResolveScope()) != null && PsiType.getJavaLangString((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)resolveScope).equals((Object)psiType)) {
            return psiType;
        }
        return PartTreeInconsistencyUtils.getSubstitutedTypeParameters(psiType, "java.util.Collection");
    }

    @Nullable
    public static PsiClass getCollectionClass(Project project) {
        return JavaPsiFacade.getInstance((Project)project).findClass("java.util.Collection", GlobalSearchScope.allScope((Project)project));
    }

    @Nullable
    public static PsiType getSubstitutedTypeParameters(@Nullable PsiType returnType, String ... classes) {
        for (String aClass : classes) {
            PsiType psiType = PsiUtil.substituteTypeParameter((PsiType)returnType, (String)aClass, (int)0, (boolean)false);
            if (psiType == null) continue;
            return psiType;
        }
        return null;
    }

    public static String getRequiredParametersTypesToString(List<PsiType> requiredParameterTypes, PsiParameterList parameterList) {
        String[] types = new String[requiredParameterTypes.size()];
        PsiParameter[] parameters = parameterList.getParameters();
        for (int i = 0; i < requiredParameterTypes.size(); ++i) {
            boolean boldType = true;
            PsiType requiredType = requiredParameterTypes.get(i);
            if (i < parameters.length) {
                PsiType parameterType = parameters[i].getType();
                if (requiredType != null && parameterType.isAssignableFrom(requiredType)) {
                    boldType = false;
                }
            }
            String text = requiredType == null ? PartTreeInconsistencyUtils.getUnresolvedTypeText() : XmlStringUtil.escapeString((String)requiredType.getPresentableText());
            types[i] = boldType ? "<b>" + text + "</b>" : text;
        }
        return StringUtil.join((String[])types, (String)", ");
    }

    @Nullable
    public static PsiType getPsiType(Project project, String fqn) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass pageableClass = psiFacade.findClass(fqn, GlobalSearchScope.allScope((Project)project));
        return pageableClass == null ? null : PsiTypesUtil.getClassType((PsiClass)pageableClass);
    }

    @NotNull
    public static String getUnusedName(@NotNull Map<String, PsiType> paramMap, @NotNull String name) {
        if (paramMap == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(21);
        }
        if (name == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(22);
        }
        Object paramName = name;
        int i = 0;
        while (paramMap.containsKey(paramName)) {
            paramName = name + (++i + 1);
        }
        String string = paramName;
        if (string == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(23);
        }
        return string;
    }

    private static PsiClassType getObjectClassType(Project project) {
        return PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
    }

    @NotNull
    public static Map<String, PsiType> getPropertyPathParamsMap(@NotNull Iterable<Part> nodes, @NotNull PsiMethod psiMethod, @NotNull Condition<Part> isCollectionTypeRequired) {
        if (nodes == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(24);
        }
        if (psiMethod == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(25);
        }
        if (isCollectionTypeRequired == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(26);
        }
        LinkedHashMap<String, PsiType> paramMap = new LinkedHashMap<String, PsiType>();
        PsiClassType objectClassType = PartTreeInconsistencyUtils.getObjectClassType(psiMethod.getProject());
        for (Part node : nodes) {
            PropertyPath nodeProperty = node.getProperty();
            PropertyPath property = nodeProperty.getLeafProperty();
            String propertyName = StringUtil.replace((String)nodeProperty.toDotPath(), (String)".", (String)"_");
            PsiType psiType = property.getType();
            if (psiType == null) continue;
            if (isCollectionTypeRequired.value((Object)node)) {
                psiType = PartTreeInconsistencyUtils.createTypedCollection(psiMethod.getProject(), psiType);
            }
            int argumentsNumber = node.getType().getNumberOfArguments();
            for (int arg = 0; arg < argumentsNumber; ++arg) {
                String paramName = PartTreeInconsistencyUtils.getUnusedName(paramMap, propertyName);
                paramMap.put(paramName, (PsiType)(psiType == null ? objectClassType : psiType));
            }
        }
        LinkedHashMap<String, PsiType> linkedHashMap = paramMap;
        if (linkedHashMap == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(27);
        }
        return linkedHashMap;
    }

    public static boolean areAssignableTypes(@NotNull PsiMethod psiMethod, @NotNull List<PsiType> requiredParameterTypes, @NotNull PsiClass domainClass, UClass repositoryClass, @NotNull PartTreeParametersCheckHelper helper) {
        PsiParameter[] parameters;
        if (psiMethod == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(28);
        }
        if (requiredParameterTypes == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(29);
        }
        if (domainClass == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(30);
        }
        if (helper == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(31);
        }
        if ((parameters = psiMethod.getParameterList().getParameters()).length == 0 && requiredParameterTypes.size() == 0) {
            return true;
        }
        boolean shouldCheckReactiveTypes = helper.isReactiveRepository(repositoryClass);
        boolean shouldCheckCoroutinesTypes = helper.isCoroutineRepository(repositoryClass);
        int requiredParameterIndex = 0;
        for (PsiParameter parameter : parameters) {
            PsiType substitutedFromWrapper;
            PsiType parameterType = parameter.getType();
            if (helper.isNotQueryParameter(psiMethod, parameterType)) continue;
            if (requiredParameterIndex >= requiredParameterTypes.size()) {
                return false;
            }
            PsiType requiredType = requiredParameterTypes.get(requiredParameterIndex);
            if (requiredType == null) {
                ++requiredParameterIndex;
                continue;
            }
            boolean requiredTypeIsCollection = InheritanceUtil.isInheritor((PsiType)requiredType, (String)"java.util.Collection");
            PsiType psiType = substitutedFromWrapper = !requiredTypeIsCollection ? PartTreeInconsistencyUtils.getSubstitutedTypeParameters(parameterType, helper.getPossibleWrappers(shouldCheckReactiveTypes)) : PartTreeInconsistencyUtils.getSubstitutedTypeParameters(parameterType, helper.getPossibleCollections(shouldCheckReactiveTypes, shouldCheckCoroutinesTypes));
            if (substitutedFromWrapper != null) {
                parameterType = substitutedFromWrapper;
            }
            if (requiredTypeIsCollection) {
                requiredType = PartTreeInconsistencyUtils.getSubstitutedTypeParameters(requiredType, "java.util.Collection");
            }
            if (requiredType == null) {
                ++requiredParameterIndex;
                continue;
            }
            if (!PartTreeInconsistencyUtils.isAssignableOrDomainClassFrom(parameterType, requiredType, domainClass)) {
                return false;
            }
            ++requiredParameterIndex;
        }
        return requiredParameterIndex == requiredParameterTypes.size();
    }

    private static boolean isAssignableOrDomainClassFrom(@NotNull PsiType parameterType, @NotNull PsiType requiredType, @NotNull PsiClass domainClass) {
        if (parameterType == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(32);
        }
        if (requiredType == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(33);
        }
        if (domainClass == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(34);
        }
        if (parameterType.isAssignableFrom(requiredType)) {
            return true;
        }
        PsiType iterableTypeParameter = PsiUtil.extractIterableTypeParameter((PsiType)parameterType, (boolean)false);
        if (iterableTypeParameter != null && iterableTypeParameter.isAssignableFrom(requiredType)) {
            return true;
        }
        return parameterType instanceof PsiClassType && domainClass.equals(((PsiClassType)parameterType).resolve());
    }

    public static String getUnresolvedTypeText() {
        return "? extends Object";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 16: 
            case 23: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 16: 
            case 23: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partTree";
                break;
            }
            case 6: 
            case 16: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/frameworks/data/util/inspections/PartTreeInconsistencyUtils";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 13: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isCollectionTypeRequired";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isCollectionElementTypeRequired";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramMap";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredParameterTypes";
                break;
            }
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClass";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/frameworks/data/util/inspections/PartTreeInconsistencyUtils";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyPropertyMessage";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredParameterTypes";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnusedName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyPathParamsMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkParts";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkOrderBy";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addEmptyPropertyProblem";
                break;
            }
            case 6: 
            case 16: 
            case 23: 
            case 27: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTextRange";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOrderByRange";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasUnresolvedPropertyPaths";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredParameterTypes";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createTypedCollection";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionOrStringElementType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getUnusedName";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyPathParamsMap";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "areAssignableTypes";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableOrDomainClassFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 16: 
            case 23: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface PartTreeParametersCheckHelper {
        public String[] getPossibleWrappers(boolean var1);

        public String[] getPossibleCollections(boolean var1, boolean var2);

        public boolean isReactiveRepository(UClass var1);

        public boolean isCoroutineRepository(UClass var1);

        public boolean isNotQueryParameter(@NotNull PsiMethod var1, PsiType var2);
    }
}

