/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.aop.psi.AopBinaryExpression;
import com.intellij.aop.psi.AopNotExpression;
import com.intellij.aop.psi.AopParenthesizedExpression;
import com.intellij.aop.psi.AopPointcutExpressionFile;
import com.intellij.aop.psi.PsiPointcutExpression;
import com.intellij.aop.psi.PsiPointcutReferenceExpression;
import com.intellij.aop.psi.SpringAopCompletionContributor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.spring.aop.SpringAopBundle;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.xml.aop.Advisor;
import com.intellij.spring.model.xml.aop.BasicAdvice;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DefineAttributeQuickFix;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringAopErrorsInspection
extends BasicDomElementsInspection<Beans> {
    public SpringAopErrorsInspection() {
        super(Beans.class, new Class[0]);
    }

    public void checkFileElement(DomFileElement<Beans> domFileElement, DomElementAnnotationHolder holder) {
        if (!SpringDomUtils.hasNamespace(domFileElement, (String)"Spring AOP namespace key")) {
            return;
        }
        super.checkFileElement(domFileElement, holder);
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        Advisor advisor;
        if (element instanceof BasicAdvice) {
            BasicAdvice advice = (BasicAdvice)element;
            if (!DomUtil.hasXml(advice.getPointcut()) && !DomUtil.hasXml(advice.getPointcutRef())) {
                SpringAopErrorsInspection.createPointcutProblem(element, holder);
            }
        } else if (element instanceof Advisor && !DomUtil.hasXml((advisor = (Advisor)element).getPointcut()) && !DomUtil.hasXml(advisor.getPointcutRef())) {
            SpringAopErrorsInspection.createPointcutProblem(element, holder);
        }
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            SpringAopErrorsInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringAopErrorsInspection.$$$reportNull$$$0(1);
        }
        if (file instanceof AopPointcutExpressionFile) {
            SmartList result = new SmartList();
            PsiPointcutExpression expression = ((AopPointcutExpressionFile)file).getPointcutExpression();
            if (expression != null) {
                expression.accept((PsiElementVisitor)new PsiRecursiveElementVisitor((List)result, manager, isOnTheFly){
                    final /* synthetic */ List val$result;
                    final /* synthetic */ InspectionManager val$manager;
                    final /* synthetic */ boolean val$isOnTheFly;
                    {
                        this.val$result = list;
                        this.val$manager = inspectionManager;
                        this.val$isOnTheFly = bl;
                    }

                    public void visitElement(@NotNull PsiElement element) {
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (!(element instanceof PsiPointcutExpression)) {
                            return;
                        }
                        super.visitElement(element);
                        PsiElement firstChild = element.getFirstChild();
                        if (element instanceof PsiPointcutReferenceExpression || element instanceof AopNotExpression || element instanceof AopBinaryExpression || element instanceof AopParenthesizedExpression) {
                            return;
                        }
                        if (firstChild == null || firstChild.getFirstChild() != null) {
                            return;
                        }
                        @NonNls String text = firstChild.getText();
                        if (StringUtil.isEmptyOrSpaces((String)text)) {
                            return;
                        }
                        if (!Arrays.asList(SpringAopCompletionContributor.SPRING20_AOP_POINTCUTS).contains(text) && !"bean".equals(text)) {
                            this.val$result.add(this.val$manager.createProblemDescriptor(firstChild, SpringAopBundle.message("this.pointcut.designator.isn.t.supported.by.spring", text), this.val$isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/highlighting/SpringAopErrorsInspection$1", "visitElement"));
                    }
                });
            }
            return result.toArray(ProblemDescriptor.EMPTY_ARRAY);
        }
        return super.checkFile(file, manager, isOnTheFly);
    }

    private static void createPointcutProblem(DomElement element, DomElementAnnotationHolder holder) {
        holder.createProblem(element, HighlightSeverity.ERROR, SpringAopBundle.message("error.pointcut.or.pointcut.ref.should.be.defined", new Object[0]), new LocalQuickFix[]{new DefineAttributeQuickFix("pointcut"), new DefineAttributeQuickFix("pointcut-ref")});
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "SpringAopErrorsInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/model/highlighting/SpringAopErrorsInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

