/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.gradle.ext.uml;

import com.intellij.diagram.AbstractUmlVisibilityManager;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.uml.utils.DiagramBundle;
import java.util.Comparator;
import org.jetbrains.annotations.Nullable;

public class GradleUmlVisibilityManager
extends AbstractUmlVisibilityManager {
    public static final VisibilityLevel COMPILE_ONLY = new VisibilityLevel("compileOnly", "Compile Only");
    public static final VisibilityLevel COMPILE_CLASSPATH = new VisibilityLevel("compileClasspath", "Compile Classpath");
    public static final VisibilityLevel RUNTIME_CLASSPATH = new VisibilityLevel("runtimeClasspath", "Runtime Classpath");
    public static final VisibilityLevel TEST_COMPILE_ONLY = new VisibilityLevel("testCompileOnly", "Test Compile Only");
    public static final VisibilityLevel TEST_COMPILE_CLASSPATH = new VisibilityLevel("testCompileClasspath", "Test Compile Classpath");
    public static final VisibilityLevel TEST_RUNTIME_CLASSPATH = new VisibilityLevel("testRuntimeClasspath", "Test Runtime Classpath");
    public static final VisibilityLevel ALL = new VisibilityLevel("all", DiagramBundle.message((String)"visibility.level.all", (Object[])new Object[0]));
    public static final VisibilityLevel STANDARD = new VisibilityLevel("standard", "Standard");
    public static final VisibilityLevel[] LEVELS = new VisibilityLevel[]{COMPILE_ONLY, COMPILE_CLASSPATH, RUNTIME_CLASSPATH, TEST_COMPILE_ONLY, TEST_COMPILE_CLASSPATH, TEST_RUNTIME_CLASSPATH, STANDARD, ALL};

    public VisibilityLevel[] getVisibilityLevels() {
        return LEVELS;
    }

    @Nullable
    public VisibilityLevel getVisibilityLevel(Object element) {
        return ALL;
    }

    public Comparator<VisibilityLevel> getComparator() {
        return VisibilityLevel.DUMMY_COMPARATOR;
    }

    public boolean isRelayoutNeeded() {
        return true;
    }

    public static boolean isStandardConfiguration(String configurationName) {
        switch (configurationName) {
            case "compileOnly": 
            case "compileClasspath": 
            case "runtimeClasspath": 
            case "testCompileOnly": 
            case "testCompileClasspath": 
            case "testRuntimeClasspath": {
                return true;
            }
        }
        return false;
    }
}

