/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.gradle.ext.uml;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.externalSystem.action.ExternalSystemActionUtil;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.gradle.ext.uml.GradleElement;
import org.jetbrains.idea.gradle.ext.uml.GradleRootElement;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleUmlElementManager
extends AbstractDiagramElementManager<GradleElement> {
    @Nullable
    public GradleElement findInDataContext(DataContext context) {
        Object data;
        ExternalSystemNode node;
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null) {
            return null;
        }
        Module module = ExternalSystemActionUtil.getModule((DataContext)context);
        if (!(module != null && ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module) || (node = (ExternalSystemNode)ContainerUtil.getFirstItem((List)((List)ExternalSystemDataKeys.SELECTED_NODES.getData(context)))) == null || !((data = node.getData()) instanceof ModuleData) && !(data instanceof ProjectData))) {
            module = ModuleManager.getInstance((Project)project).findModuleByName(((Named)data).getInternalName());
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return null;
        }
        return new GradleRootElement(project, module);
    }

    public boolean isAcceptableAsNode(Object element) {
        return element instanceof GradleRootElement;
    }

    @Nullable
    public String getElementTitle(GradleElement element) {
        return element.getName();
    }

    @Nullable
    public SimpleColoredText getItemName(Object element, DiagramState presentation) {
        if (element instanceof GradleElement) {
            GradleElement gradleElement = (GradleElement)element;
            int style = 1;
            SimpleTextAttributes attr = new SimpleTextAttributes(style, (Color)JBColor.BLACK);
            return new SimpleColoredText(gradleElement.getName(), attr);
        }
        return null;
    }

    public String getNodeTooltip(GradleElement element) {
        return element.getHtmlDescription();
    }
}

