/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.gradle.ext.uml;

import com.google.gson.GsonBuilder;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramDataView;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.diagram.extras.custom.CommonDiagramExtras;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.project.dependencies.ArtifactDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyScopeNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.FileCollectionDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ReferenceNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.UnknownDependencyNode;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataImportListener;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.idea.gradle.ext.GradleExtBundle;
import org.jetbrains.idea.gradle.ext.uml.GradleArtifact;
import org.jetbrains.idea.gradle.ext.uml.GradleElement;
import org.jetbrains.idea.gradle.ext.uml.GradleFileDependencyElement;
import org.jetbrains.idea.gradle.ext.uml.GradleJavaConfigurations;
import org.jetbrains.idea.gradle.ext.uml.GradleLibraryDependencyElement;
import org.jetbrains.idea.gradle.ext.uml.GradleProjectDependencyElement;
import org.jetbrains.idea.gradle.ext.uml.GradleRootElement;
import org.jetbrains.idea.gradle.ext.uml.GradleUmlEdge;
import org.jetbrains.idea.gradle.ext.uml.GradleUmlNode;
import org.jetbrains.idea.gradle.ext.uml.GradleUmlVisibilityManager;
import org.jetbrains.idea.gradle.ext.uml.GradleUnresolvedElement;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.tooling.tasks.DependenciesReport;
import org.jetbrains.plugins.gradle.tooling.tasks.DependencyNodeDeserializer;

public class GradleUmlDataModel
extends DiagramDataModel<GradleElement>
implements DiagramDataModel.AsyncDataLoader {
    private static final Logger LOG = Logger.getInstance(GradleUmlDataModel.class);
    @Nullable
    private final GradleRootElement myElement;
    private final List<DiagramNode<GradleElement>> myNodes;
    private final List<DiagramEdge<GradleElement>> myEdges;
    private DependencyScopeNode[] myConfigurations;
    private final ModificationTracker myModificationTracker;
    private final MessageBusConnection myConnection;
    private long myModificationCount;
    private boolean myDisposed;
    private ProgressIndicator myLastStartedProgress;
    private final Object myProgressGuard;
    private volatile boolean myDelayedRefreshScheduled;

    public GradleUmlDataModel(@NotNull Project project, @Nullable GradleRootElement element, @NotNull DiagramProvider<GradleElement> provider) {
        if (project == null) {
            GradleUmlDataModel.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            GradleUmlDataModel.$$$reportNull$$$0(1);
        }
        super(project, provider);
        this.myNodes = new ArrayList<DiagramNode<GradleElement>>();
        this.myEdges = new ArrayList<DiagramEdge<GradleElement>>();
        this.myDisposed = false;
        this.myProgressGuard = new Object();
        this.myDelayedRefreshScheduled = false;
        this.myElement = element;
        this.myConnection = this.getProject().getMessageBus().connect();
        this.myConnection.setDefaultHandler(this::handleGradleModelImport);
        this.myConnection.subscribe(ProjectDataImportListener.TOPIC);
        this.myModificationTracker = () -> this.myModificationCount;
    }

    @NotNull
    public Collection<? extends DiagramNode<GradleElement>> getNodes() {
        List<DiagramNode<GradleElement>> list = this.myNodes;
        if (list == null) {
            GradleUmlDataModel.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public Collection<? extends DiagramEdge<GradleElement>> getEdges() {
        List<DiagramEdge<GradleElement>> list = this.myEdges;
        if (list == null) {
            GradleUmlDataModel.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public String getNodeName(DiagramNode<GradleElement> n) {
        String string = ((GradleElement)n.getIdentifyingElement()).getName();
        if (string == null) {
            GradleUmlDataModel.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public DiagramNode<GradleElement> addElement(GradleElement element) {
        GradleUmlNode node;
        if (element != null && !this.myNodes.contains((Object)(node = new GradleUmlNode(element, (DiagramProvider<GradleElement>)this.getProvider())))) {
            this.myNodes.add((DiagramNode<GradleElement>)node);
            return node;
        }
        return null;
    }

    public void refreshDataModel() {
        if (this.myElement == null) {
            return;
        }
        if (this.myConfigurations != null) {
            ModelData modelData = this.buildModel(this.myElement, this.myConfigurations, this.getViewOptions());
            this.updateModel(modelData);
        } else {
            this.scheduleDelayedRefresh();
        }
    }

    private void scheduleDelayedRefresh() {
        if (this.myDelayedRefreshScheduled) {
            return;
        }
        this.myDelayedRefreshScheduled = true;
        ApplicationManager.getApplication().invokeLater(() -> {
            this.refreshDataModelAsync(BackgroundExecutionMode.IN_BACKGROUND_ASYNC).onSuccess(result -> DumbService.getInstance((Project)this.getProject()).smartInvokeLater(this::updatePresentation)).onError(GradleUmlDataModel::logPromiseErrors);
            this.myDelayedRefreshScheduled = false;
        });
    }

    private void handleGradleModelImport(Method event, Object ... params) {
        this.scheduleDelayedRefresh();
    }

    private void updateModel(ModelData modelData) {
        this.myConfigurations = modelData.getConfigurations();
        this.myNodes.clear();
        this.myEdges.clear();
        this.myNodes.addAll(modelData.getNodes());
        this.myEdges.addAll(modelData.getEdges());
    }

    public Promise<?> refreshDataModelAsync() {
        return this.refreshDataModelAsync(BackgroundExecutionMode.START_IN_FOREGROUND_ASYNC);
    }

    private Promise<?> refreshDataModelAsync(BackgroundExecutionMode mode) {
        GradleRootElement rootElement = this.myElement;
        if (rootElement == null) {
            return Promises.resolvedPromise(null);
        }
        Module module = rootElement.getModule();
        String projectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
        if (projectPath == null) {
            return Promises.resolvedPromise(null);
        }
        ViewOptions viewOptions = this.getViewOptions();
        return this.collectGradleDependencies(rootElement, viewOptions.getVisibility(), projectPath, mode).then(nodes -> {
            ModelData modelData = this.buildModel(rootElement, (DependencyScopeNode[])nodes, viewOptions);
            ApplicationManager.getApplication().invokeAndWait(() -> this.updateModel(modelData));
            return null;
        });
    }

    @NotNull
    private ViewOptions getViewOptions() {
        return new ViewOptions(this.getVisibilityManager().getCurrentVisibilityLevel(), this.getBuilder().getPresentation().isCategoryEnabled(CommonDiagramExtras.PATH_TO_ROOT), DiagramUtils.isSelectionMode((DiagramBuilder)this.getBuilder()), DiagramUtils.getSelectedNodes((DiagramBuilder)this.getBuilder()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncPromise<DependencyScopeNode[]> collectGradleDependencies(final @NotNull GradleRootElement rootElement, @NotNull VisibilityLevel visibilityLevel, final @NotNull String projectPath, BackgroundExecutionMode mode) {
        AsyncPromise result;
        block10: {
            if (rootElement == null) {
                GradleUmlDataModel.$$$reportNull$$$0(5);
            }
            if (visibilityLevel == null) {
                GradleUmlDataModel.$$$reportNull$$$0(6);
            }
            if (projectPath == null) {
                GradleUmlDataModel.$$$reportNull$$$0(7);
            }
            result = new AsyncPromise();
            File outputFile = null;
            try {
                Object object = this.myProgressGuard;
                synchronized (object) {
                    outputFile = FileUtil.createTempFile((String)"dependencies", (String)".json", (boolean)true);
                    String configurationFilter = GradleUmlDataModel.toConfigurationFilter(visibilityLevel);
                    final String taskConfiguration = "outputFile = project.file(\"" + FileUtil.toCanonicalPath((String)outputFile.getAbsolutePath()) + "\")\nconfigurations = " + configurationFilter + "\n";
                    final File finalOutputFile = outputFile;
                    final String executionName = GradleExtBundle.message("gradle.uml.building.progress", this.getProvider().getPresentableName());
                    if (this.myLastStartedProgress != null) {
                        this.myLastStartedProgress.cancel();
                        this.myLastStartedProgress = null;
                    }
                    PerformInBackgroundOption processMode = mode == BackgroundExecutionMode.IN_BACKGROUND_ASYNC ? null : PerformInBackgroundOption.DEAF;
                    new Task.Backgroundable(this.getProject(), executionName, true, processMode){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run(final @NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            Object object = GradleUmlDataModel.this.myProgressGuard;
                            synchronized (object) {
                                if (GradleUmlDataModel.this.myLastStartedProgress != null) {
                                    return;
                                }
                                GradleUmlDataModel.this.myLastStartedProgress = indicator;
                            }
                            try {
                                GradleTaskManager.runCustomTask((Project)rootElement.getProject(), (String)executionName, DependenciesReport.class, (String)projectPath, (String)rootElement.getGradlePath(), (String)taskConfiguration, (ProgressExecutionMode)ProgressExecutionMode.NO_PROGRESS_SYNC, (TaskCallback)new TaskCallback(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void onSuccess() {
                                        try {
                                            indicator.checkCanceled();
                                            String json = FileUtil.loadFile((File)finalOutputFile);
                                            GsonBuilder gsonBuilder = new GsonBuilder();
                                            gsonBuilder.registerTypeAdapter(DependencyNode.class, (Object)new DependencyNodeDeserializer());
                                            DependencyScopeNode[] configurationNodes = (DependencyScopeNode[])gsonBuilder.create().fromJson(json, DependencyScopeNode[].class);
                                            indicator.checkCanceled();
                                            result.setResult((Object)(configurationNodes != null ? configurationNodes : new DependencyScopeNode[]{}));
                                        }
                                        catch (Exception e) {
                                            result.setError((Throwable)e);
                                        }
                                        finally {
                                            FileUtil.delete((File)finalOutputFile);
                                        }
                                    }

                                    public void onFailure() {
                                        LOG.debug("Gradle task execution failed, diagram will not be opened");
                                        FileUtil.delete((File)finalOutputFile);
                                    }
                                });
                            }
                            finally {
                                object = GradleUmlDataModel.this.myProgressGuard;
                                synchronized (object) {
                                    if (GradleUmlDataModel.this.myLastStartedProgress == indicator) {
                                        GradleUmlDataModel.this.myLastStartedProgress = null;
                                    }
                                }
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/gradle/ext/uml/GradleUmlDataModel$1", "run"));
                        }
                    }.queue();
                }
            }
            catch (ProcessCanceledException | CancellationException ce) {
                result.setError(ce);
            }
            catch (Exception e) {
                result.setError((Throwable)e);
                LOG.error((Throwable)e);
                if (outputFile == null) break block10;
                FileUtil.delete((File)outputFile);
            }
        }
        return result;
    }

    private ModelData buildModel(@NotNull GradleRootElement element, DependencyScopeNode @NotNull [] configurations, @NotNull ViewOptions viewOptions) {
        if (element == null) {
            GradleUmlDataModel.$$$reportNull$$$0(8);
        }
        if (viewOptions == null) {
            GradleUmlDataModel.$$$reportNull$$$0(9);
        }
        if (configurations == null) {
            GradleUmlDataModel.$$$reportNull$$$0(10);
        }
        ModelData modelData = new ModelData(this.getProject(), new GradleUmlNode(element, (DiagramProvider<GradleElement>)this.getProvider()), configurations);
        modelData.addNode(modelData.getRoot());
        modelData.getModuleNodes().put(element.getGradlePath(), modelData.getRoot());
        for (DependencyScopeNode configuration : configurations) {
            if (!GradleUmlDataModel.suite(configuration.getScope(), viewOptions.getVisibility())) continue;
            this.addNodesRecursively(modelData, modelData.getRoot(), configuration.getDependencies());
        }
        if (viewOptions.isPathToRoot()) {
            if (!viewOptions.getSelectedNodes().isEmpty()) {
                GradleUmlDataModel.removeAllExceptPathsFromRootToNodes(modelData, viewOptions.getSelectedNodes());
            }
        } else if (viewOptions.isSelectionMode()) {
            DiagramUtils.removeNonSelectedDependencies((DiagramDataView)modelData, viewOptions.getSelectedNodes());
        }
        return modelData;
    }

    private void updatePresentation() {
        if (!this.getProject().isDisposed() && !this.myDisposed) {
            ++this.myModificationCount;
            DiagramBuilder builder = this.getBuilder();
            builder.update(true, true);
            builder.getGraphBuilder().updateView();
            if (this.getVisibilityManager().isRelayoutNeeded()) {
                builder.relayout();
            }
        }
    }

    private static void removeAllExceptPathsFromRootToNodes(@NotNull ModelData modelData, @NotNull Collection<DiagramNode> nodes) {
        if (modelData == null) {
            GradleUmlDataModel.$$$reportNull$$$0(11);
        }
        if (nodes == null) {
            GradleUmlDataModel.$$$reportNull$$$0(12);
        }
        Set pathEdges = DiagramUtils.getPathsFromRoot((DiagramNode)modelData.getRoot(), nodes, (DiagramDataView)modelData);
        Set pathNodes = DiagramUtils.collectNodes((Set)pathEdges);
        for (DiagramNode diagramNode : modelData.getNodes().toArray(new DiagramNode[0])) {
            if (pathNodes.contains(diagramNode) || diagramNode == modelData.getRoot()) continue;
            modelData.getNodes().remove(diagramNode);
        }
        for (DiagramNode diagramNode : modelData.getEdges().toArray(new DiagramEdge[0])) {
            if (pathEdges.contains(diagramNode)) continue;
            modelData.getEdges().remove(diagramNode);
        }
    }

    private void addNodesRecursively(@NotNull ModelData modelData, @NotNull GradleUmlNode node, @NotNull Collection<DependencyNode> dependencies) {
        if (modelData == null) {
            GradleUmlDataModel.$$$reportNull$$$0(13);
        }
        if (node == null) {
            GradleUmlDataModel.$$$reportNull$$$0(14);
        }
        if (dependencies == null) {
            GradleUmlDataModel.$$$reportNull$$$0(15);
        }
        for (DependencyNode child : dependencies) {
            GradleElement childElement;
            GradleUmlNode childNode;
            if (child instanceof ProjectDependencyNode) {
                ProjectDependencyNode projectComponentNode = (ProjectDependencyNode)child;
                String localModuleName = projectComponentNode.getProjectName();
                if (localModuleName == null) continue;
                childNode = modelData.getModuleNodes().get(localModuleName);
                if (childNode == null) {
                    childElement = new GradleProjectDependencyElement(this.getProject(), localModuleName);
                    childNode = new GradleUmlNode(childElement, (DiagramProvider<GradleElement>)this.getProvider());
                    modelData.addNode(childNode);
                    modelData.getModuleNodes().put(localModuleName, childNode);
                    modelData.getReferenceNodes().put(projectComponentNode.getId(), childNode);
                    this.addNodesRecursively(modelData, childNode, projectComponentNode.getDependencies());
                }
                modelData.addEdge(node, childNode);
                continue;
            }
            if (child instanceof ArtifactDependencyNode) {
                ArtifactDependencyNode artifactComponentNode = (ArtifactDependencyNode)child;
                GradleArtifact artifact = new GradleArtifact(artifactComponentNode.getGroup(), artifactComponentNode.getModule(), artifactComponentNode.getVersion());
                childNode = modelData.getArtifactNodes().get(artifact);
                if (childNode == null) {
                    childElement = new GradleLibraryDependencyElement(this.getProject(), artifact);
                    childNode = new GradleUmlNode(childElement, (DiagramProvider<GradleElement>)this.getProvider());
                    modelData.getArtifactNodes().put(artifact, childNode);
                    modelData.getReferenceNodes().put(artifactComponentNode.getId(), childNode);
                    modelData.addNode(childNode);
                    this.addNodesRecursively(modelData, childNode, artifactComponentNode.getDependencies());
                }
                modelData.addEdge(node, childNode);
                continue;
            }
            if (child instanceof FileCollectionDependencyNode) {
                FileCollectionDependencyNode fileCollectionDependencyNode = (FileCollectionDependencyNode)child;
                GradleFileDependencyElement childElement2 = new GradleFileDependencyElement(this.getProject(), String.valueOf(fileCollectionDependencyNode.getId()), fileCollectionDependencyNode.getDisplayName(), fileCollectionDependencyNode.getPath());
                childNode = new GradleUmlNode(childElement2, (DiagramProvider<GradleElement>)this.getProvider());
                modelData.getReferenceNodes().put(fileCollectionDependencyNode.getId(), childNode);
                modelData.addNode(childNode);
                modelData.addEdge(node, childNode);
                continue;
            }
            if (child instanceof ReferenceNode) {
                ReferenceNode referenceNode = (ReferenceNode)child;
                GradleUmlNode childNode2 = modelData.getReferenceNodes().get(referenceNode.getId());
                if (childNode2 != null) {
                    modelData.addEdge(node, childNode2);
                    continue;
                }
                LOG.debug("Unable to find reference from Gradle dependency report", new Object[]{referenceNode.getId()});
                continue;
            }
            if (!(child instanceof UnknownDependencyNode)) continue;
            UnknownDependencyNode unknownDependencyNode = (UnknownDependencyNode)child;
            String coordinates = unknownDependencyNode.getDisplayName();
            childNode = modelData.getUnresolvedNodes().get(coordinates);
            if (childNode == null) {
                childElement = new GradleUnresolvedElement(this.getProject(), coordinates);
                childNode = new GradleUmlNode(childElement, (DiagramProvider<GradleElement>)this.getProvider());
                modelData.getUnresolvedNodes().put(coordinates, childNode);
                modelData.getReferenceNodes().put(unknownDependencyNode.getId(), childNode);
                modelData.addNode(childNode);
            }
            modelData.addEdge(node, childNode);
        }
    }

    private static boolean suite(@Nullable String configurationName, VisibilityLevel visibility) {
        if (visibility == GradleUmlVisibilityManager.ALL || configurationName == null) {
            return true;
        }
        if (visibility == GradleUmlVisibilityManager.STANDARD) {
            return GradleUmlVisibilityManager.isStandardConfiguration(configurationName);
        }
        switch (configurationName) {
            case "compileOnly": {
                return visibility == GradleUmlVisibilityManager.COMPILE_ONLY;
            }
            case "compileClasspath": {
                return visibility == GradleUmlVisibilityManager.COMPILE_CLASSPATH;
            }
            case "runtimeClasspath": {
                return visibility == GradleUmlVisibilityManager.RUNTIME_CLASSPATH;
            }
            case "testCompileOnly": {
                return visibility == GradleUmlVisibilityManager.TEST_COMPILE_ONLY;
            }
            case "testCompileClasspath": {
                return visibility == GradleUmlVisibilityManager.TEST_COMPILE_CLASSPATH;
            }
            case "testRuntimeClasspath": {
                return visibility == GradleUmlVisibilityManager.TEST_RUNTIME_CLASSPATH;
            }
        }
        return false;
    }

    private static String toConfigurationFilter(VisibilityLevel visibility) {
        if (visibility == GradleUmlVisibilityManager.ALL) {
            return "[]";
        }
        if (visibility == GradleUmlVisibilityManager.STANDARD) {
            return GradleJavaConfigurations.asList().stream().map(s -> "'" + s + "'").collect(Collectors.joining(",", "[", "]"));
        }
        switch (visibility.getName()) {
            case "compileOnly": 
            case "compileClasspath": 
            case "runtimeClasspath": 
            case "testCompileOnly": 
            case "testCompileClasspath": 
            case "testRuntimeClasspath": {
                return "['" + visibility.getName() + "']";
            }
        }
        return "[]";
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        ModificationTracker modificationTracker = this.myModificationTracker;
        if (modificationTracker == null) {
            GradleUmlDataModel.$$$reportNull$$$0(16);
        }
        return modificationTracker;
    }

    public void dispose() {
        this.myConnection.disconnect();
        this.myDisposed = true;
    }

    private static void logPromiseErrors(Throwable t) {
        if (!(t instanceof ProcessCanceledException) && !(t instanceof CancellationException)) {
            LOG.error("Unable to refresh Gradle diagram model async", t);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/gradle/ext/uml/GradleUmlDataModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibilityLevel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewOptions";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelData";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/gradle/ext/uml/GradleUmlDataModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 16: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectGradleDependencies";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildModel";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeAllExceptPathsFromRootToNodes";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addNodesRecursively";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum BackgroundExecutionMode {
        IN_BACKGROUND_ASYNC,
        START_IN_FOREGROUND_ASYNC;

    }

    private static final class ViewOptions {
        public final VisibilityLevel myVisibility;
        public final boolean myPathToRoot;
        public final boolean mySelectionMode;
        public final List<DiagramNode> mySelectedNodes;

        private ViewOptions(VisibilityLevel visibility, boolean pathToRoot, boolean selectionMode, List<DiagramNode> selectedNodes) {
            this.myVisibility = visibility;
            this.myPathToRoot = pathToRoot;
            this.mySelectionMode = selectionMode;
            this.mySelectedNodes = selectedNodes;
        }

        private VisibilityLevel getVisibility() {
            return this.myVisibility;
        }

        private boolean isPathToRoot() {
            return this.myPathToRoot;
        }

        private boolean isSelectionMode() {
            return this.mySelectionMode;
        }

        private List<DiagramNode> getSelectedNodes() {
            return this.mySelectedNodes;
        }
    }

    private static final class ModelData
    implements DiagramDataView<GradleElement> {
        private final List<DiagramNode<GradleElement>> myNodes = new ArrayList<DiagramNode<GradleElement>>();
        private final List<DiagramEdge<GradleElement>> myEdges = new ArrayList<DiagramEdge<GradleElement>>();
        private final Project myProject;
        private final GradleUmlNode myRoot;
        private final DependencyScopeNode[] myConfigurations;
        private final Map<GradleArtifact, GradleUmlNode> myArtifactNodes = new HashMap<GradleArtifact, GradleUmlNode>();
        private final Map<String, GradleUmlNode> myModuleNodes = new HashMap<String, GradleUmlNode>();
        private final Map<Long, GradleUmlNode> myReferenceNodes = new HashMap<Long, GradleUmlNode>();
        private final Map<String, GradleUmlNode> myUnresolvedNodes = new HashMap<String, GradleUmlNode>();

        private ModelData(Project project, GradleUmlNode root, DependencyScopeNode[] configurations) {
            this.myProject = project;
            this.myRoot = root;
            this.myConfigurations = configurations;
        }

        public GradleUmlNode getRoot() {
            return this.myRoot;
        }

        public DependencyScopeNode[] getConfigurations() {
            return this.myConfigurations;
        }

        @NotNull
        public Map<GradleArtifact, GradleUmlNode> getArtifactNodes() {
            Map<GradleArtifact, GradleUmlNode> map = this.myArtifactNodes;
            if (map == null) {
                ModelData.$$$reportNull$$$0(0);
            }
            return map;
        }

        @NotNull
        public Map<String, GradleUmlNode> getModuleNodes() {
            Map<String, GradleUmlNode> map = this.myModuleNodes;
            if (map == null) {
                ModelData.$$$reportNull$$$0(1);
            }
            return map;
        }

        @NotNull
        public Map<Long, GradleUmlNode> getReferenceNodes() {
            Map<Long, GradleUmlNode> map = this.myReferenceNodes;
            if (map == null) {
                ModelData.$$$reportNull$$$0(2);
            }
            return map;
        }

        @NotNull
        public Map<String, GradleUmlNode> getUnresolvedNodes() {
            Map<String, GradleUmlNode> map = this.myUnresolvedNodes;
            if (map == null) {
                ModelData.$$$reportNull$$$0(3);
            }
            return map;
        }

        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                ModelData.$$$reportNull$$$0(4);
            }
            return project;
        }

        @NotNull
        public Collection<DiagramNode<GradleElement>> getNodes() {
            List<DiagramNode<GradleElement>> list = this.myNodes;
            if (list == null) {
                ModelData.$$$reportNull$$$0(5);
            }
            return list;
        }

        @NotNull
        public Collection<DiagramEdge<GradleElement>> getEdges() {
            List<DiagramEdge<GradleElement>> list = this.myEdges;
            if (list == null) {
                ModelData.$$$reportNull$$$0(6);
            }
            return list;
        }

        public void addNode(@NotNull GradleUmlNode node) {
            if (node == null) {
                ModelData.$$$reportNull$$$0(7);
            }
            this.myNodes.add((DiagramNode<GradleElement>)node);
        }

        public void addEdge(@NotNull GradleUmlNode node, @NotNull GradleUmlNode childNode) {
            if (node == null) {
                ModelData.$$$reportNull$$$0(8);
            }
            if (childNode == null) {
                ModelData.$$$reportNull$$$0(9);
            }
            this.myEdges.add((DiagramEdge<GradleElement>)new GradleUmlEdge(node, childNode));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/gradle/ext/uml/GradleUmlDataModel$ModelData";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArtifactNodes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleNodes";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferenceNodes";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedNodes";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodes";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEdges";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/gradle/ext/uml/GradleUmlDataModel$ModelData";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addNode";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addEdge";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

