/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.gradle.ext.uml;

import com.intellij.openapi.project.Project;
import com.intellij.util.PlatformIcons;
import java.util.Objects;
import javax.swing.Icon;
import org.apache.commons.lang.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.gradle.ext.uml.GradleArtifact;
import org.jetbrains.idea.gradle.ext.uml.GradleElement;

public class GradleLibraryDependencyElement
implements GradleElement {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleArtifact myArtifact;

    public GradleLibraryDependencyElement(@NotNull Project project, @NotNull GradleArtifact artifact) {
        if (project == null) {
            GradleLibraryDependencyElement.$$$reportNull$$$0(0);
        }
        if (artifact == null) {
            GradleLibraryDependencyElement.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myArtifact = artifact;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            GradleLibraryDependencyElement.$$$reportNull$$$0(2);
        }
        return project;
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.myArtifact.getIdentifier();
        if (string == null) {
            GradleLibraryDependencyElement.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getHtmlDescription() {
        String string = "<html>Group ID: <b>" + StringEscapeUtils.escapeHtml((String)this.myArtifact.getGroupId()) + "</b><br/>Artifact ID: <b>" + StringEscapeUtils.escapeHtml((String)this.myArtifact.getArtifactId()) + "</b><br/>Version: <b>" + StringEscapeUtils.escapeHtml((String)this.myArtifact.getVersion()) + "</b></html>";
        if (string == null) {
            GradleLibraryDependencyElement.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return PlatformIcons.LIBRARY_ICON;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myArtifact.getArtifactId() != null ? this.myArtifact.getArtifactId() : "<unknown>";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GradleLibraryDependencyElement element = (GradleLibraryDependencyElement)o;
        return this.myProject.equals(element.myProject) && this.myArtifact.equals(element.myArtifact);
    }

    public int hashCode() {
        return Objects.hash(this.myProject, this.myArtifact);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/gradle/ext/uml/GradleLibraryDependencyElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/gradle/ext/uml/GradleLibraryDependencyElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

