/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.gradle.ext.profiler;

import com.intellij.build.events.StartEvent;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemProcessHandler;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.ultimate.JavaProfilerConfigurationExtension;
import com.intellij.profiler.ultimate.NewProcessStartedFromExternalSystemCommunicator;
import com.intellij.profiler.ultimate.async.StartedFromExternalSystemProcess;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.gradle.ext.profiler.GradleRunConfigurationExtensionKt;
import org.jetbrains.idea.gradle.ext.profiler.OnTaskStartedListener;
import org.jetbrains.idea.gradle.ext.profiler.model.JavaTaskData;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.util.GradleTasksUtilKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000|\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a.\u0010\r\u001a \u0012\u0004\u0012\u00020\b\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f0\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a,\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0002\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a,\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00180\u001dH\u0002\u001aL\u0010\u001f\u001a\u00020\u0018\"\u0004\b\u0000\u0010 *\b\u0012\u0004\u0012\u0002H 0!2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u0010\u0019\u001a\u00020#2\u001e\u0010$\u001a\u001a\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(0%H\u0000\u001a\u0012\u0010*\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\"'\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"'\u0010\u0007\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\b0\b0\u0001\u00a2\u0006\u0002\b\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0006\u00a8\u0006+"}, d2={"noJavaTaskDataInfo", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getNoJavaTaskDataInfo", "()Lcom/intellij/openapi/util/Key;", "targetTaskFqnKey", "", "getTargetTaskFqnKey", "doProcessGradleTasks", "runConfiguration", "Lorg/jetbrains/plugins/gradle/service/execution/GradleRunConfiguration;", "fetchAllKnownTasks", "", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/task/TaskData;", "project", "Lcom/intellij/openapi/project/Project;", "gradleProjectPath", "findTargetTask", "javaTaskDataAvailable", "onTaskStarted", "", "handler", "Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemProcessHandler;", "targetTask", "onTaskStartedCallback", "Lkotlin/Function1;", "Lcom/intellij/build/events/StartEvent;", "doAttachToGradleProcess", "T", "Lcom/intellij/profiler/ultimate/JavaProfilerConfigurationExtension;", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "Lcom/intellij/execution/process/ProcessHandler;", "profilerProcessFactory", "Lkotlin/Function2;", "Lcom/intellij/profiler/ultimate/NewProcessStartedFromExternalSystemCommunicator;", "", "Lcom/intellij/profiler/api/ProfilerProcess;", "Lcom/intellij/profiler/ultimate/async/StartedFromExternalSystemProcess;", "isJavaExec", "intellij.gradle.ext"})
public final class GradleRunConfigurationExtensionKt {
    @NotNull
    private static final Key<String> targetTaskFqnKey;
    @NotNull
    private static final Key<Boolean> noJavaTaskDataInfo;

    @NotNull
    public static final Key<String> getTargetTaskFqnKey() {
        return targetTaskFqnKey;
    }

    @NotNull
    public static final Key<Boolean> getNoJavaTaskDataInfo() {
        return noJavaTaskDataInfo;
    }

    public static final boolean doProcessGradleTasks(@NotNull GradleRunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        if (GradleRunConfigurationExtensionKt.javaTaskDataAvailable(runConfiguration)) {
            String string = GradleRunConfigurationExtensionKt.findTargetTask(runConfiguration);
            if (string == null) {
                return false;
            }
            String targetTask = string;
            runConfiguration.putUserData(targetTaskFqnKey, (Object)targetTask);
        } else {
            runConfiguration.putUserData(noJavaTaskDataInfo, (Object)true);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean javaTaskDataAvailable(GradleRunConfiguration runConfiguration) {
        boolean bl;
        block6: {
            Collection destination$iv$iv;
            ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = runConfiguration.getSettings();
            Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskExecutionSettings, (String)"runConfiguration.settings");
            String gradleProjectPath = externalSystemTaskExecutionSettings.getExternalProjectPath();
            Project project = runConfiguration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"runConfiguration.project");
            String string = gradleProjectPath;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gradleProjectPath");
            Object object = GradleRunConfigurationExtensionKt.fetchAllKnownTasks(project, string);
            if (object != null && (object = object.entrySet()) != null) {
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = (Iterable)object;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    Map.Entry it = (Map.Entry)element$iv$iv;
                    boolean bl2 = false;
                    Iterable list$iv$iv = (Collection)it.getValue();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
            } else {
                return false;
            }
            List taskNodes = (List)destination$iv$iv;
            Iterable $this$any$iv = taskNodes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DataNode it = (DataNode)element$iv;
                    boolean bl3 = false;
                    if (!(ExternalSystemApiUtil.find((DataNode)it, JavaTaskData.KEY) != null)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final String findTargetTask(GradleRunConfiguration runConfiguration) {
        void $this$mapNotNullTo$iv$iv;
        void $this$filterTo$iv$iv;
        Object object;
        Object object2;
        void $this$flatMapTo$iv$iv;
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = runConfiguration.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskExecutionSettings, (String)"runConfiguration.settings");
        String gradleProjectPath = externalSystemTaskExecutionSettings.getExternalProjectPath();
        Project project = runConfiguration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"runConfiguration.project");
        String string = gradleProjectPath;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gradleProjectPath");
        MultiMap<String, DataNode<TaskData>> multiMap = GradleRunConfigurationExtensionKt.fetchAllKnownTasks(project, string);
        if (multiMap == null) {
            return null;
        }
        MultiMap<String, DataNode<TaskData>> allKnownTasks = multiMap;
        Set set = allKnownTasks.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"allKnownTasks.entrySet()");
        Iterable $this$flatMap$iv = set;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            Collection tasks;
            Map.Entry $dstr$path$tasks = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Map.Entry entry = $dstr$path$tasks;
            boolean bl2 = false;
            String string2 = (String)entry.getKey();
            entry = $dstr$path$tasks;
            bl2 = false;
            Collection collection = tasks = (Collection)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"tasks");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                void path;
                object2 = (DataNode)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl3 = false;
                void v6 = path;
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"path");
                void v7 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"it");
                Object object3 = v7.getData();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"it.data");
                object = TuplesKt.to((Object)GradleTasksUtilKt.getGradleFqnTaskName((String)v6, (TaskData)((TaskData)object3)), (Object)it);
                collection2.add(object);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List fqnTasks = (List)destination$iv$iv;
        Iterable $this$filter$iv = fqnTasks;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DataNode task;
            Pair $dstr$_u24__u24$task = (Pair)element$iv$iv;
            boolean bl = false;
            DataNode dataNode = task = (DataNode)$dstr$_u24__u24$task.component2();
            Intrinsics.checkNotNullExpressionValue((Object)dataNode, (String)"task");
            Object object4 = dataNode.getData();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"task.data");
            if (!(((TaskData)object4).isTest() || GradleRunConfigurationExtensionKt.isJavaExec((DataNode<TaskData>)task))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List suitableTasks = (List)destination$iv$iv3;
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings2 = runConfiguration.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskExecutionSettings2, (String)"runConfiguration.settings");
        List list = externalSystemTaskExecutionSettings2.getTaskNames();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"runConfiguration.settings.taskNames");
        List candidates = list;
        Iterable $this$mapNotNull$iv = candidates;
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$filterTo22 = $this$mapNotNull$iv;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string3;
            Object object5;
            block6: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String name = (String)element$iv$iv;
                boolean bl4 = false;
                Iterable iterable3 = suitableTasks;
                boolean bl5 = false;
                object2 = iterable3;
                boolean bl6 = false;
                Iterator iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    Object $dstr$fqnTaskName$_u24__u24 = object = iterator2.next();
                    boolean bl7 = false;
                    String fqnTaskName = (String)$dstr$fqnTaskName$_u24__u24.component1();
                    String string4 = name;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"name");
                    if (!StringsKt.endsWith$default((String)fqnTaskName, (String)string4, (boolean)false, (int)2, null)) continue;
                    object5 = object;
                    break block6;
                }
                object5 = null;
            }
            Pair pair = object5;
            if ((pair != null ? (String)pair.getFirst() : null) == null) continue;
            string3 = string3;
            boolean bl = false;
            boolean bl8 = false;
            String it$iv$iv = string3;
            boolean bl9 = false;
            destination$iv$iv4.add(it$iv$iv);
        }
        List suitableCandidates = (List)destination$iv$iv4;
        return (String)CollectionsKt.firstOrNull((List)suitableCandidates);
    }

    public static final <T> void doAttachToGradleProcess(@NotNull JavaProfilerConfigurationExtension<T> $this$doAttachToGradleProcess, @NotNull RunConfigurationBase<?> runConfiguration, @NotNull ProcessHandler handler, @NotNull Function2<? super NewProcessStartedFromExternalSystemCommunicator, ? super Long, ? extends ProfilerProcess<StartedFromExternalSystemProcess>> profilerProcessFactory) {
        Intrinsics.checkNotNullParameter($this$doAttachToGradleProcess, (String)"$this$doAttachToGradleProcess");
        Intrinsics.checkNotNullParameter(runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter(profilerProcessFactory, (String)"profilerProcessFactory");
        if (!(handler instanceof ExternalSystemProcessHandler) || !(runConfiguration instanceof GradleRunConfiguration)) {
            return;
        }
        if (Intrinsics.areEqual((Object)((GradleRunConfiguration)runConfiguration).getUserData(noJavaTaskDataInfo), (Object)true)) {
            ((GradleRunConfiguration)runConfiguration).putUserData(noJavaTaskDataInfo, null);
            $this$doAttachToGradleProcess.openToolWindowAndReportStart((ProfilerProcess)profilerProcessFactory.invoke((Object)new NewProcessStartedFromExternalSystemCommunicator((ExternalSystemProcessHandler)handler), (Object)System.currentTimeMillis()), runConfiguration);
            return;
        }
        String string = (String)((GradleRunConfiguration)runConfiguration).getUserData(targetTaskFqnKey);
        if (string == null) {
            return;
        }
        String targetTask = string;
        ((GradleRunConfiguration)runConfiguration).putUserData(targetTaskFqnKey, null);
        boolean $i$f$service = false;
        Intrinsics.checkNotNullExpressionValue((Object)ApplicationManager.getApplication().getService(ExternalSystemProgressNotificationManager.class), (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
        GradleRunConfigurationExtensionKt.onTaskStarted((ExternalSystemProcessHandler)handler, targetTask, (Function1<? super StartEvent, Unit>)((Function1)new Function1<StartEvent, Unit>($this$doAttachToGradleProcess, profilerProcessFactory, handler, runConfiguration){
            final /* synthetic */ JavaProfilerConfigurationExtension $this_doAttachToGradleProcess;
            final /* synthetic */ Function2 $profilerProcessFactory;
            final /* synthetic */ ProcessHandler $handler;
            final /* synthetic */ RunConfigurationBase $runConfiguration;

            public final void invoke(@NotNull StartEvent startEvent) {
                Intrinsics.checkNotNullParameter((Object)startEvent, (String)"startEvent");
                this.$this_doAttachToGradleProcess.openToolWindowAndReportStart((ProfilerProcess)this.$profilerProcessFactory.invoke((Object)new NewProcessStartedFromExternalSystemCommunicator((ExternalSystemProcessHandler)this.$handler), (Object)startEvent.getEventTime()), this.$runConfiguration);
            }
            {
                this.$this_doAttachToGradleProcess = javaProfilerConfigurationExtension;
                this.$profilerProcessFactory = function2;
                this.$handler = processHandler;
                this.$runConfiguration = runConfigurationBase;
                super(1);
            }
        }));
    }

    private static final void onTaskStarted(ExternalSystemProcessHandler handler, String targetTask, Function1<? super StartEvent, Unit> onTaskStartedCallback) {
        ExternalSystemTask externalSystemTask = handler.getTask();
        if (externalSystemTask == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTask, (String)"handler.task ?: return");
        ExternalSystemTask buildTask = externalSystemTask;
        ExternalSystemProgressNotificationManager notificationManager = (ExternalSystemProgressNotificationManager)ApplicationManager.getApplication().getService(ExternalSystemProgressNotificationManager.class);
        OnTaskStartedListener taskListener2 = new OnTaskStartedListener(onTaskStartedCallback, notificationManager, targetTask, targetTask){
            final /* synthetic */ Function1 $onTaskStartedCallback;
            final /* synthetic */ ExternalSystemProgressNotificationManager $notificationManager;
            final /* synthetic */ String $targetTask;

            public void onTaskStarted(@NotNull StartEvent startEvent) {
                Intrinsics.checkNotNullParameter((Object)startEvent, (String)"startEvent");
                this.$onTaskStartedCallback.invoke((Object)startEvent);
                this.$notificationManager.removeNotificationListener((ExternalSystemTaskNotificationListener)this);
            }
            {
                this.$onTaskStartedCallback = $captured_local_variable$0;
                this.$notificationManager = $captured_local_variable$1;
                this.$targetTask = $captured_local_variable$2;
                super($super_call_param$3);
            }
        };
        notificationManager.addNotificationListener(buildTask.getId(), (ExternalSystemTaskNotificationListener)taskListener2);
        handler.addProcessListener((ProcessListener)new ProcessAdapter(notificationManager, taskListener2){
            final /* synthetic */ ExternalSystemProgressNotificationManager $notificationManager;
            final /* synthetic */ onTaskStarted.taskListener.1 $taskListener;

            public void processTerminated(@NotNull ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$notificationManager.removeNotificationListener((ExternalSystemTaskNotificationListener)this.$taskListener);
            }
            {
                this.$notificationManager = $captured_local_variable$0;
                this.$taskListener = $captured_local_variable$1;
            }
        });
    }

    private static final boolean isJavaExec(DataNode<TaskData> $this$isJavaExec) {
        DataNode dataNode = ExternalSystemApiUtil.find($this$isJavaExec, JavaTaskData.KEY);
        if (dataNode == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)dataNode, (String)"ExternalSystemApiUtil.fi\u2026Data.KEY) ?: return false");
        DataNode javaTaskNode = dataNode;
        return ((JavaTaskData)javaTaskNode.getData()).isJavaExec();
    }

    private static final MultiMap<String, DataNode<TaskData>> fetchAllKnownTasks(Project project, String gradleProjectPath) {
        return GradleRunConfigurationExtensionKt.fetchAllKnownTasks(project).get(gradleProjectPath);
    }

    private static final Map<String, MultiMap<String, DataNode<TaskData>>> fetchAllKnownTasks(Project project) {
        Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, (CachedValueProvider)new CachedValueProvider<Map<String, ? extends MultiMap<String, DataNode<TaskData>>>>(project){
            final /* synthetic */ Project $project;

            @Nullable
            public final CachedValueProvider.Result<Map<String, MultiMap<String, DataNode<TaskData>>>> compute() {
                return CachedValueProvider.Result.create((Object)GradleTasksUtilKt.getGradleTaskNodesMap((Project)this.$project), (Object[])new Object[]{ProjectRootManager.getInstance((Project)this.$project)});
            }
            {
                this.$project = project;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"CachedValuesManager.getM\u2026getInstance(project))\n  }");
        return (Map)object;
    }

    static {
        Key key = Key.create((String)"profiler.gradle.configuration.target.task.name");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<String>(\"prof\u2026ration.target.task.name\")");
        targetTaskFqnKey = key;
        Key key2 = Key.create((String)"profiler.gradle.configuration.no.java.task.data.info");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"Key.create<Boolean>(\"pro\u2026.no.java.task.data.info\")");
        noJavaTaskDataInfo = key2;
    }
}

