/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.config;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.linter.JSNpmLinterState;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TsLintState
implements JSNpmLinterState<TsLintState> {
    public static final TsLintState DEFAULT = new Builder().build();
    @NotNull
    private final NodeJsInterpreterRef myInterpreterRef;
    @NotNull
    private final NodePackageRef myNodePackageRef;
    @Nullable
    private final String myCustomConfigFilePath;
    private final boolean myCustomConfigFileUsed;
    @Nullable
    private final String myRulesDirectory;
    private final boolean myAllowJs;

    private TsLintState(@NotNull NodeJsInterpreterRef nodePath, @NotNull NodePackageRef nodePackageRef, boolean customConfigFileUsed, @Nullable String customConfigFilePath, @Nullable String rulesDirectory, boolean allowJs) {
        if (nodePath == null) {
            TsLintState.$$$reportNull$$$0(0);
        }
        if (nodePackageRef == null) {
            TsLintState.$$$reportNull$$$0(1);
        }
        this.myCustomConfigFileUsed = customConfigFileUsed;
        this.myCustomConfigFilePath = customConfigFilePath;
        this.myInterpreterRef = nodePath;
        this.myRulesDirectory = rulesDirectory;
        this.myAllowJs = allowJs;
        this.myNodePackageRef = nodePackageRef;
    }

    public boolean isCustomConfigFileUsed() {
        return this.myCustomConfigFileUsed;
    }

    @Nullable
    public String getCustomConfigFilePath() {
        return this.myCustomConfigFilePath;
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreterRef;
        if (nodeJsInterpreterRef == null) {
            TsLintState.$$$reportNull$$$0(2);
        }
        return nodeJsInterpreterRef;
    }

    @Nullable
    public String getRulesDirectory() {
        return this.myRulesDirectory;
    }

    public boolean isAllowJs() {
        return this.myAllowJs;
    }

    @NotNull
    public NodePackageRef getNodePackageRef() {
        NodePackageRef nodePackageRef = this.myNodePackageRef;
        if (nodePackageRef == null) {
            TsLintState.$$$reportNull$$$0(3);
        }
        return nodePackageRef;
    }

    public TsLintState withLinterPackage(@NotNull NodePackageRef nodePackageRef) {
        if (nodePackageRef == null) {
            TsLintState.$$$reportNull$$$0(4);
        }
        return new Builder(this).setNodePackageRef(nodePackageRef).build();
    }

    public TsLintState withInterpreterRef(@NotNull NodeJsInterpreterRef ref) {
        if (ref == null) {
            TsLintState.$$$reportNull$$$0(5);
        }
        return new TsLintState(ref, this.myNodePackageRef, this.myCustomConfigFileUsed, this.myCustomConfigFilePath, this.myRulesDirectory, this.myAllowJs);
    }

    public Builder builder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TsLintState state = (TsLintState)o;
        if (this.myCustomConfigFileUsed != state.myCustomConfigFileUsed) {
            return false;
        }
        if (this.myAllowJs != state.myAllowJs) {
            return false;
        }
        if (!this.myInterpreterRef.equals((Object)state.myInterpreterRef)) {
            return false;
        }
        if (!Objects.equals(this.myNodePackageRef, state.myNodePackageRef)) {
            return false;
        }
        if (!Objects.equals(this.myCustomConfigFilePath, state.myCustomConfigFilePath)) {
            return false;
        }
        return Objects.equals(this.myRulesDirectory, state.myRulesDirectory);
    }

    public int hashCode() {
        int result = this.myInterpreterRef.hashCode();
        result = 31 * result + this.myNodePackageRef.hashCode();
        result = 31 * result + (this.myCustomConfigFilePath != null ? this.myCustomConfigFilePath.hashCode() : 0);
        result = 31 * result + (this.myCustomConfigFileUsed ? 1 : 0);
        result = 31 * result + (this.myRulesDirectory != null ? this.myRulesDirectory.hashCode() : 0);
        result = 31 * result + (this.myAllowJs ? 1 : 0);
        return result;
    }

    public String toString() {
        return "TsLintState{myInterpreterRef=" + this.myInterpreterRef + ", myNodePackageRef='" + this.myNodePackageRef + "', myCustomConfigFilePath='" + this.myCustomConfigFilePath + "', myCustomConfigFileUsed=" + this.myCustomConfigFileUsed + ", myRulesDirectory='" + this.myRulesDirectory + "', myAllowJs=" + this.myAllowJs + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePath";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePackageRef";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/tslint/config/TsLintState";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/tslint/config/TsLintState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterRef";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodePackageRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withLinterPackage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withInterpreterRef";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        private boolean myCustomConfigFileUsed;
        private String myCustomConfigFilePath;
        private NodeJsInterpreterRef myInterpreterRef;
        private NodePackageRef myNodePackageRef;
        private boolean myAllowJs;
        @Nullable
        private String myRulesDirectory;

        public Builder() {
            this.myCustomConfigFileUsed = false;
            this.myCustomConfigFilePath = "";
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myNodePackageRef = NodePackageRef.create((NodePackage)new NodePackage(""));
        }

        public Builder(@NotNull TsLintState state) {
            if (state == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myCustomConfigFileUsed = false;
            this.myCustomConfigFilePath = "";
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myNodePackageRef = NodePackageRef.create((NodePackage)new NodePackage(""));
            this.myCustomConfigFileUsed = state.isCustomConfigFileUsed();
            this.myCustomConfigFilePath = state.getCustomConfigFilePath();
            this.myInterpreterRef = state.getInterpreterRef();
            this.myNodePackageRef = state.getNodePackageRef();
            this.myRulesDirectory = state.getRulesDirectory();
            this.myAllowJs = state.isAllowJs();
        }

        public Builder setCustomConfigFileUsed(boolean customConfigFileUsed) {
            this.myCustomConfigFileUsed = customConfigFileUsed;
            return this;
        }

        public Builder setCustomConfigFilePath(String customConfigFilePath) {
            this.myCustomConfigFilePath = customConfigFilePath;
            return this;
        }

        public Builder setNodePath(NodeJsInterpreterRef nodePath) {
            this.myInterpreterRef = nodePath;
            return this;
        }

        public Builder setNodePackageRef(NodePackageRef nodePackageRef) {
            this.myNodePackageRef = nodePackageRef;
            return this;
        }

        public Builder setRulesDirectory(@Nullable String rulesDirectory) {
            this.myRulesDirectory = rulesDirectory;
            return this;
        }

        public Builder setAllowJs(boolean allowJs) {
            this.myAllowJs = allowJs;
            return this;
        }

        public TsLintState build() {
            return new TsLintState(this.myInterpreterRef, this.myNodePackageRef, this.myCustomConfigFileUsed, this.myCustomConfigFilePath, this.myRulesDirectory, this.myAllowJs);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/tslint/config/TsLintState$Builder", "<init>"));
        }
    }
}

