/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.codestyle.rules;

import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.linter.tslint.codestyle.rules.TsLintSimpleRule;
import com.intellij.lang.javascript.linter.tslint.codestyle.rules.TslintJsonOption;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0018\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/lang/javascript/linter/tslint/codestyle/rules/QuotemarkRule;", "Lcom/intellij/lang/javascript/linter/tslint/codestyle/rules/TsLintSimpleRule;", "", "()V", "getConfigValue", "option", "Lcom/intellij/lang/javascript/linter/tslint/codestyle/rules/TslintJsonOption;", "getSettingsValue", "languageSettings", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "codeStyleSettings", "Lcom/intellij/lang/javascript/formatter/JSCodeStyleSettings;", "setValue", "", "value", "intellij.tslint"})
public final class QuotemarkRule
extends TsLintSimpleRule<String> {
    @Override
    @Nullable
    protected String getConfigValue(@NotNull TslintJsonOption option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        List<String> stringValues = option.getStringValues();
        if (stringValues.contains("single")) {
            return "'";
        }
        if (stringValues.contains("double")) {
            return "\"";
        }
        return null;
    }

    @Override
    @NotNull
    protected String getSettingsValue(@NotNull CommonCodeStyleSettings languageSettings, @NotNull JSCodeStyleSettings codeStyleSettings) {
        Intrinsics.checkNotNullParameter((Object)languageSettings, (String)"languageSettings");
        Intrinsics.checkNotNullParameter((Object)codeStyleSettings, (String)"codeStyleSettings");
        return codeStyleSettings.USE_DOUBLE_QUOTES ? "\"" : "'";
    }

    @Override
    protected void setValue(@NotNull CommonCodeStyleSettings languageSettings, @NotNull JSCodeStyleSettings codeStyleSettings, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)languageSettings, (String)"languageSettings");
        Intrinsics.checkNotNullParameter((Object)codeStyleSettings, (String)"codeStyleSettings");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        codeStyleSettings.USE_DOUBLE_QUOTES = Intrinsics.areEqual((Object)value, (Object)"\"");
    }

    public QuotemarkRule() {
        super("quotemark");
    }
}

