/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.codestyle.rules;

import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.linter.tslint.codestyle.rules.TsLintSimpleRule;
import com.intellij.lang.javascript.linter.tslint.codestyle.rules.TslintJsonOption;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/javascript/linter/tslint/codestyle/rules/ImportBlacklistRule;", "Lcom/intellij/lang/javascript/linter/tslint/codestyle/rules/TsLintSimpleRule;", "", "", "()V", "getConfigValue", "option", "Lcom/intellij/lang/javascript/linter/tslint/codestyle/rules/TslintJsonOption;", "getSettingsValue", "languageSettings", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "codeStyleSettings", "Lcom/intellij/lang/javascript/formatter/JSCodeStyleSettings;", "setValue", "", "value", "intellij.tslint"})
public final class ImportBlacklistRule
extends TsLintSimpleRule<Collection<? extends String>> {
    @Override
    @Nullable
    protected Collection<String> getConfigValue(@NotNull TslintJsonOption option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        if (!option.isEnabled()) {
            return null;
        }
        List<String> stringValues = option.getStringValues();
        Collection collection = stringValues;
        boolean bl = false;
        if (!collection.isEmpty()) {
            return CollectionsKt.toHashSet((Iterable)stringValues);
        }
        return null;
    }

    @Override
    @NotNull
    protected Collection<String> getSettingsValue(@NotNull CommonCodeStyleSettings languageSettings, @NotNull JSCodeStyleSettings codeStyleSettings) {
        Intrinsics.checkNotNullParameter((Object)languageSettings, (String)"languageSettings");
        Intrinsics.checkNotNullParameter((Object)codeStyleSettings, (String)"codeStyleSettings");
        Object[] objectArray = codeStyleSettings.getBlacklistImports();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"codeStyleSettings.blacklistImports");
        return ArraysKt.toHashSet((Object[])objectArray);
    }

    @Override
    protected void setValue(@NotNull CommonCodeStyleSettings languageSettings, @NotNull JSCodeStyleSettings codeStyleSettings, @NotNull Collection<String> value) {
        Intrinsics.checkNotNullParameter((Object)languageSettings, (String)"languageSettings");
        Intrinsics.checkNotNullParameter((Object)codeStyleSettings, (String)"codeStyleSettings");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        codeStyleSettings.BLACKLIST_IMPORTS = StringUtil.join(value, (String)",");
    }

    public ImportBlacklistRule() {
        super("import-blacklist");
    }
}

