/*
 * Decompiled with CFR 0.152.
 */
package training.ui;

import com.intellij.execution.target.TargetEnvironmentWizardStepKt;
import com.intellij.ide.plugins.newui.VerticalLayout;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.ShortcutRestrictions;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import training.keymap.KeymapUtil;
import training.learn.LearnBundle;
import training.statistic.StatisticBase;
import training.util.UtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0003\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"BORDER_COLOR", "Lcom/intellij/ui/JBColor;", "Lorg/jetbrains/annotations/NotNull;", "SHORTCUT_COLOR", "showActionKeyPopup", "", "parent", "Ljava/awt/Component;", "point", "Ljava/awt/Point;", "height", "", "actionId", "", "intellij.featuresTrainer"})
public final class ActionKeyPopupKt {
    private static final JBColor SHORTCUT_COLOR;
    private static final JBColor BORDER_COLOR;

    /*
     * WARNING - void declaration
     */
    public static final void showActionKeyPopup(@NotNull Component parent, @NotNull Point point, int height, @NotNull String actionId) {
        void balloon;
        Shortcut[] shortcuts;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        AnAction action2 = ActionManager.getInstance().getAction(actionId);
        if (action2 == null) {
            return;
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new VerticalLayout(TargetEnvironmentWizardStepKt.Companion.getVGAP(), 250));
        jPanel.setOpaque(false);
        Presentation presentation = action2.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"action.templatePresentation");
        jPanel.add(new JLabel(presentation.getText()));
        KeymapManager keymapManager = KeymapManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)keymapManager, (String)"KeymapManager.getInstance()");
        for (Shortcut shortcut : shortcuts = keymapManager.getActiveKeymap().getShortcuts(actionId)) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            String keyStrokeText = KeymapUtil.INSTANCE.getKeyStrokeText(((KeyboardShortcut)shortcut).getFirstKeyStroke());
            JLabel jLabel = new JLabel(SystemInfo.isMac ? KeymapUtil.INSTANCE.decryptMacShortcut(keyStrokeText) : keyStrokeText);
            boolean bl = false;
            boolean bl2 = false;
            JLabel it = jLabel;
            boolean bl3 = false;
            Font font = it.getFont();
            Font font2 = it.getFont();
            Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"it.font");
            it.setFont(font.deriveFont((float)(font2.getSize() - 1)));
            it.setForeground((Color)SHORTCUT_COLOR);
            JLabel shortcutLabel = jLabel;
            jPanel.add(shortcutLabel);
        }
        jPanel.add((Component)new LinkLabel(LearnBundle.INSTANCE.message("shortcut.balloon.apply.this.action", new Object[0]), null, (LinkListener)new LinkListener<Object>(action2, (Ref.ObjectRef)balloon){
            final /* synthetic */ AnAction $action;
            final /* synthetic */ Ref.ObjectRef $balloon;

            public final void linkSelected(LinkLabel<Object> $noName_0, Object $noName_1) {
                UtilsKt.invokeActionForFocusContext(this.$action);
                Object object = this.$balloon.element;
                if (object == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"balloon");
                }
                ((Balloon)object).hide();
            }
            {
                this.$action = anAction;
                this.$balloon = objectRef;
            }
        }));
        jPanel.add((Component)new LinkLabel(LearnBundle.INSTANCE.message("shortcut.balloon.add.shortcut", new Object[0]), null, (LinkListener)new LinkListener<Object>(actionId, parent, (Ref.ObjectRef)balloon){
            final /* synthetic */ String $actionId;
            final /* synthetic */ Component $parent;
            final /* synthetic */ Ref.ObjectRef $balloon;

            public final void linkSelected(LinkLabel<Object> $noName_0, Object $noName_1) {
                ShortcutRestrictions shortcutRestrictions = ActionShortcutRestrictions.getInstance().getForActionId(this.$actionId);
                KeymapManager keymapManager = KeymapManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)keymapManager, (String)"KeymapManager.getInstance()");
                KeymapPanel.addKeyboardShortcut((String)this.$actionId, (ShortcutRestrictions)shortcutRestrictions, (Keymap)keymapManager.getActiveKeymap(), (Component)this.$parent, (QuickList[])new QuickList[0]);
                Object object = this.$balloon.element;
                if (object == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"balloon");
                }
                ((Balloon)object).hide();
                this.$parent.repaint();
            }
            {
                this.$actionId = string;
                this.$parent = component2;
                this.$balloon = objectRef;
            }
        }));
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)jPanel).setShowCallout(true).setHideOnKeyOutside(true).setHideOnClickOutside(true).setAnimationCycle(0).setCalloutShift(height / 2 + 1).setCornerToPointerDistance(80).setBlockClicksThroughBalloon(true).setBorderColor((Color)BORDER_COLOR).setFillColor(UIUtil.getToolTipBackground()).setBorderInsets(new Insets(8, 10, 8, 10)).setShadow(true);
        Intrinsics.checkNotNullExpressionValue((Object)balloonBuilder, (String)"JBPopupFactory.getInstan\u202610))\n    .setShadow(true)");
        BalloonBuilder builder = balloonBuilder;
        Balloon balloon2 = builder.createBalloon();
        Intrinsics.checkNotNullExpressionValue((Object)balloon2, (String)"builder.createBalloon()");
        Object object = balloon.element = balloon2;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"balloon");
        }
        ((Balloon)object).show(new RelativePoint(parent, point), Balloon.Position.below);
        StatisticBase.Companion.logShortcutClicked(actionId);
    }

    static {
        JBColor jBColor = JBColor.namedColor((String)"ToolTip.shortcutForeground", (Color)((Color)new JBColor(0x787878, 0x999999)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"JBColor.namedColor(\"Tool\u2026olor(0x787878, 0x999999))");
        SHORTCUT_COLOR = jBColor;
        JBColor jBColor2 = JBColor.namedColor((String)"ToolTip.borderColor", (Color)((Color)new JBColor(0xADADAD, 6514025)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"JBColor.namedColor(\"Tool\u2026olor(0xadadad, 0x636569))");
        BORDER_COLOR = jBColor2;
    }
}

