/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.model.beans;

import com.intellij.guice.utils.GuiceUtils;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BindDescriptor {
    private final PsiMethodCallExpression myCallExpression;
    private final NullableLazyValue<PsiClass> myBoundClass;
    private final NullableLazyValue<PsiClass> myBindingClass;

    public BindDescriptor(@NotNull PsiMethodCallExpression callExpression) {
        if (callExpression == null) {
            BindDescriptor.$$$reportNull$$$0(0);
        }
        this.myBoundClass = new NullableLazyValue<PsiClass>(){

            @Nullable
            protected PsiClass compute() {
                return GuiceUtils.findImplementedClassForBinding(BindDescriptor.this.getBindExpression());
            }
        };
        this.myBindingClass = new NullableLazyValue<PsiClass>(){

            @Nullable
            protected PsiClass compute() {
                return BindDescriptor.this.calculateBindingClass();
            }
        };
        this.myCallExpression = callExpression;
    }

    @Nullable
    public PsiClass getBoundClass() {
        return (PsiClass)this.myBoundClass.getValue();
    }

    @Nullable
    public PsiClass getBindingClass() {
        return (PsiClass)this.myBindingClass.getValue();
    }

    @Nullable
    public abstract PsiClass calculateBindingClass();

    @NotNull
    public PsiMethodCallExpression getBindExpression() {
        PsiMethodCallExpression psiMethodCallExpression = this.myCallExpression;
        if (psiMethodCallExpression == null) {
            BindDescriptor.$$$reportNull$$$0(1);
        }
        return psiMethodCallExpression;
    }

    public boolean isValid() {
        return this.myCallExpression.isValid();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BindDescriptor)) {
            return false;
        }
        BindDescriptor that = (BindDescriptor)o;
        return !(this.myCallExpression != null ? !this.myCallExpression.equals(that.myCallExpression) : that.myCallExpression != null);
    }

    public int hashCode() {
        return this.myCallExpression != null ? this.myCallExpression.hashCode() : 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/guice/model/beans/BindDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/guice/model/beans/BindDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBindExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

