/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.model;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.guice.model.GuiceInjectionUtil;
import com.intellij.guice.model.InjectionPointDescriptor;
import com.intellij.guice.model.beans.BindDescriptor;
import com.intellij.guice.model.beans.BindToDescriptor;
import com.intellij.guice.model.jam.GuiceProvides;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiceInjectorManager {
    @NotNull
    public static Set<BindDescriptor> getInjectBindingDescriptors(@NotNull InjectionPointDescriptor ip, @NotNull Set<? extends BindDescriptor> allDescriptors) {
        PsiClass psiClass;
        if (ip == null) {
            GuiceInjectorManager.$$$reportNull$$$0(0);
        }
        if (allDescriptors == null) {
            GuiceInjectorManager.$$$reportNull$$$0(1);
        }
        HashSet<BindDescriptor> descriptors = new HashSet<BindDescriptor>();
        PsiType type = ip.getType();
        if (type instanceof PsiClassType && (psiClass = ((PsiClassType)type).resolve()) != null) {
            for (BindDescriptor bindDescriptor : allDescriptors) {
                if (!psiClass.equals(bindDescriptor.getBoundClass()) || !GuiceInjectionUtil.checkBindingAnnotations(ip, bindDescriptor)) continue;
                descriptors.add(bindDescriptor);
            }
        }
        HashSet<BindDescriptor> hashSet = descriptors;
        if (hashSet == null) {
            GuiceInjectorManager.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    @NotNull
    public static Set<GuiceProvides> getInjectProvidesDescriptors(@NotNull InjectionPointDescriptor ip, @NotNull List<? extends GuiceProvides> allDescriptors) {
        if (ip == null) {
            GuiceInjectorManager.$$$reportNull$$$0(3);
        }
        if (allDescriptors == null) {
            GuiceInjectorManager.$$$reportNull$$$0(4);
        }
        HashSet<GuiceProvides> set = new HashSet<GuiceProvides>();
        PsiType type = ip.getType();
        if (type != null) {
            for (GuiceProvides guiceProvides : allDescriptors) {
                PsiType productType = guiceProvides.getProductType();
                if (productType == null) continue;
                Set<PsiAnnotation> bindingAnnotations = guiceProvides.getBindingAnnotations();
                if (!type.isAssignableFrom(productType) || !GuiceInjectionUtil.checkBindingAnnotations(ip.getBindingAnnotations(), bindingAnnotations)) continue;
                set.add(guiceProvides);
            }
        }
        HashSet<GuiceProvides> hashSet = set;
        if (hashSet == null) {
            GuiceInjectorManager.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @NotNull
    public static Set<BindDescriptor> getBindingDescriptors(@Nullable Module module) {
        if (module == null) {
            Set<BindDescriptor> set = Collections.emptySet();
            if (set == null) {
                GuiceInjectorManager.$$$reportNull$$$0(6);
            }
            return set;
        }
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        for (PsiClass aClass : GuiceInjectorManager.getGuiceModuleClasses(module)) {
            VirtualFile virtualFile;
            PsiFile file = aClass.getContainingFile();
            if (file == null || (virtualFile = file.getVirtualFile()) == null) continue;
            files.add(virtualFile);
        }
        if (files.size() == 0) {
            Set<BindDescriptor> set = Collections.emptySet();
            if (set == null) {
                GuiceInjectorManager.$$$reportNull$$$0(7);
            }
            return set;
        }
        GlobalSearchScope fileScope = GlobalSearchScope.filesScope((Project)module.getProject(), files);
        Set set = (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create(GuiceInjectorManager.getBindingDescriptors(module.getProject(), (SearchScope)fileScope), GuiceInjectorManager.getModificationsTrackers(module)));
        if (set == null) {
            GuiceInjectorManager.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    public static Set<BindDescriptor> getBindingDescriptors(@NotNull PsiElement scope) {
        if (scope == null) {
            GuiceInjectorManager.$$$reportNull$$$0(9);
        }
        Set set = (Set)CachedValuesManager.getCachedValue((PsiElement)scope, () -> CachedValueProvider.Result.create(GuiceInjectorManager.getBindingDescriptors(scope.getProject(), (SearchScope)new LocalSearchScope(scope)), (Object[])new Object[]{scope}));
        if (set == null) {
            GuiceInjectorManager.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    public static Set<BindDescriptor> getBindingDescriptors(@NotNull Project project, @NotNull SearchScope scope) {
        if (project == null) {
            GuiceInjectorManager.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            GuiceInjectorManager.$$$reportNull$$$0(12);
        }
        Set<BindDescriptor> descriptors = Collections.newSetFromMap(new ConcurrentHashMap());
        descriptors.addAll(GuiceInjectorManager.getToBindingDescriptors(project, scope));
        descriptors.addAll(GuiceInjectorManager.getToInstanceBindingDescriptors(project, scope));
        descriptors.addAll(GuiceInjectorManager.getToProviderBindingDescriptors(project, scope));
        descriptors.addAll(GuiceInjectorManager.getToConstructorBindingDescriptors(project, scope));
        Set<BindDescriptor> set = descriptors;
        if (set == null) {
            GuiceInjectorManager.$$$reportNull$$$0(13);
        }
        return set;
    }

    @NotNull
    public static Set<BindDescriptor> getToBindingDescriptors(@NotNull Project project, @NotNull SearchScope scope) {
        if (project == null) {
            GuiceInjectorManager.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            GuiceInjectorManager.$$$reportNull$$$0(15);
        }
        Set<BindDescriptor> set = GuiceInjectorManager.getDescriptors(project, scope, "to");
        if (set == null) {
            GuiceInjectorManager.$$$reportNull$$$0(16);
        }
        return set;
    }

    private static Set<BindDescriptor> getDescriptors(@NotNull Project project, @NotNull SearchScope scope, @NotNull String name) {
        if (project == null) {
            GuiceInjectorManager.$$$reportNull$$$0(17);
        }
        if (scope == null) {
            GuiceInjectorManager.$$$reportNull$$$0(18);
        }
        if (name == null) {
            GuiceInjectorManager.$$$reportNull$$$0(19);
        }
        Set<PsiMethodCallExpression> expressions = GuiceInjectorManager.getLinkedBindingBuilderExpressions(project, scope, name);
        return ContainerUtil.map2Set(expressions, expression -> new BindToDescriptor((PsiMethodCallExpression)expression));
    }

    @NotNull
    public static Set<BindDescriptor> getToInstanceBindingDescriptors(@NotNull Project project, @NotNull SearchScope scope) {
        if (project == null) {
            GuiceInjectorManager.$$$reportNull$$$0(20);
        }
        if (scope == null) {
            GuiceInjectorManager.$$$reportNull$$$0(21);
        }
        Set<BindDescriptor> set = GuiceInjectorManager.getDescriptors(project, scope, "toInstance");
        if (set == null) {
            GuiceInjectorManager.$$$reportNull$$$0(22);
        }
        return set;
    }

    @NotNull
    public static Set<BindDescriptor> getToProviderBindingDescriptors(@NotNull Project project, @NotNull SearchScope scope) {
        if (project == null) {
            GuiceInjectorManager.$$$reportNull$$$0(23);
        }
        if (scope == null) {
            GuiceInjectorManager.$$$reportNull$$$0(24);
        }
        Set<BindDescriptor> set = GuiceInjectorManager.getDescriptors(project, scope, "toProvider");
        if (set == null) {
            GuiceInjectorManager.$$$reportNull$$$0(25);
        }
        return set;
    }

    @NotNull
    public static Set<BindDescriptor> getToConstructorBindingDescriptors(@NotNull Project project, @NotNull SearchScope scope) {
        if (project == null) {
            GuiceInjectorManager.$$$reportNull$$$0(26);
        }
        if (scope == null) {
            GuiceInjectorManager.$$$reportNull$$$0(27);
        }
        Set<BindDescriptor> set = GuiceInjectorManager.getDescriptors(project, scope, "toConstructor");
        if (set == null) {
            GuiceInjectorManager.$$$reportNull$$$0(28);
        }
        return set;
    }

    public static PsiClass @NotNull [] getGuiceModuleClasses(@NotNull Module module) {
        if (module == null) {
            GuiceInjectorManager.$$$reportNull$$$0(29);
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesScope((Module)module);
        PsiClass[] psiClassArray = (PsiClass[])CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            HashSet<PsiClass> psiClasses = new HashSet<PsiClass>(){};
            PsiClass abstractModuleClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("com.google.inject.AbstractModule", scope);
            if (abstractModuleClass != null) {
                psiClasses.addAll(ClassInheritorsSearch.search((PsiClass)abstractModuleClass, (SearchScope)scope, (boolean)true).findAll());
            }
            PsiClass[] classes = psiClasses.toArray(PsiClass.EMPTY_ARRAY);
            return CachedValueProvider.Result.createSingleDependency((Object)classes, (Object)PsiModificationTracker.MODIFICATION_COUNT);
        });
        if (psiClassArray == null) {
            GuiceInjectorManager.$$$reportNull$$$0(30);
        }
        return psiClassArray;
    }

    private static Collection<?> getModificationsTrackers(@NotNull Module module) {
        if (module == null) {
            GuiceInjectorManager.$$$reportNull$$$0(31);
        }
        HashSet<Object> deps = new HashSet<Object>();
        deps.addAll(Arrays.asList(GuiceInjectorManager.getGuiceModuleClasses(module)));
        deps.add(PsiModificationTracker.MODIFICATION_COUNT);
        return deps;
    }

    @NotNull
    private static Set<PsiMethodCallExpression> getLinkedBindingBuilderExpressions(@NotNull Project project, @NotNull SearchScope scope, @NotNull String methodName) {
        if (project == null) {
            GuiceInjectorManager.$$$reportNull$$$0(32);
        }
        if (scope == null) {
            GuiceInjectorManager.$$$reportNull$$$0(33);
        }
        if (methodName == null) {
            GuiceInjectorManager.$$$reportNull$$$0(34);
        }
        Set<PsiMethodCallExpression> expressions = Collections.newSetFromMap(new ConcurrentHashMap());
        PsiClass moduleClass = JavaPsiFacade.getInstance((Project)project).findClass("com.google.inject.binder.LinkedBindingBuilder", GlobalSearchScope.allScope((Project)project));
        if (moduleClass != null) {
            PsiMethod[] binds;
            for (PsiMethod bind : binds = moduleClass.findMethodsByName(methodName, false)) {
                Set calls = StringExpressionHelper.searchMethodCalls((PsiMethod)bind, (SearchScope)scope);
                for (PsiCall call : calls) {
                    if (!(call instanceof PsiMethodCallExpression)) continue;
                    expressions.add((PsiMethodCallExpression)call);
                }
            }
        }
        Set<PsiMethodCallExpression> set = expressions;
        if (set == null) {
            GuiceInjectorManager.$$$reportNull$$$0(35);
        }
        return set;
    }

    @NotNull
    public static Collection<PsiClass> getBindingAnnotations(@Nullable Module module) {
        Collection<Object> collection = module == null ? Collections.emptySet() : MetaAnnotationUtil.getAnnotationTypesWithChildren((Module)module, (String)"com.google.inject.BindingAnnotation", (boolean)false);
        if (collection == null) {
            GuiceInjectorManager.$$$reportNull$$$0(36);
        }
        return collection;
    }

    @NotNull
    public static Set<PsiAnnotation> getBindingAnnotations(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            GuiceInjectorManager.$$$reportNull$$$0(37);
        }
        Set<PsiAnnotation> annotations = Collections.newSetFromMap(new ConcurrentHashMap());
        for (PsiClass psiClass : GuiceInjectorManager.getBindingAnnotations(ModuleUtilCore.findModuleForPsiElement((PsiElement)owner))) {
            PsiAnnotation annotation;
            String fqn = psiClass.getQualifiedName();
            if (fqn == null || (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{fqn})) == null) continue;
            annotations.add(annotation);
        }
        Set<PsiAnnotation> set = annotations;
        if (set == null) {
            GuiceInjectorManager.$$$reportNull$$$0(38);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 16: 
            case 22: 
            case 25: 
            case 28: 
            case 30: 
            case 35: 
            case 36: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 16: 
            case 22: 
            case 25: 
            case 28: 
            case 30: 
            case 35: 
            case 36: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ip";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allDescriptors";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 16: 
            case 22: 
            case 25: 
            case 28: 
            case 30: 
            case 35: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/guice/model/GuiceInjectorManager";
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/guice/model/GuiceInjectorManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectBindingDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectProvidesDescriptors";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBindingDescriptors";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getToBindingDescriptors";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getToInstanceBindingDescriptors";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getToProviderBindingDescriptors";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getToConstructorBindingDescriptors";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getGuiceModuleClasses";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkedBindingBuilderExpressions";
                break;
            }
            case 36: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getBindingAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInjectBindingDescriptors";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 16: 
            case 22: 
            case 25: 
            case 28: 
            case 30: 
            case 35: 
            case 36: 
            case 38: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInjectProvidesDescriptors";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getBindingDescriptors";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getToBindingDescriptors";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptors";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getToInstanceBindingDescriptors";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getToProviderBindingDescriptors";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getToConstructorBindingDescriptors";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getGuiceModuleClasses";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getModificationsTrackers";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getLinkedBindingBuilderExpressions";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getBindingAnnotations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 16: 
            case 22: 
            case 25: 
            case 28: 
            case 30: 
            case 35: 
            case 36: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

