/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.model;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.guice.constants.GuiceAnnotations;
import com.intellij.guice.model.InjectionPointDescriptor;
import com.intellij.guice.model.beans.BindDescriptor;
import com.intellij.guice.model.jam.GuiceInject;
import com.intellij.guice.model.jam.GuiceProvides;
import com.intellij.guice.utils.GuiceUtils;
import com.intellij.jam.JamService;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiceInjectionUtil {
    public static Set<InjectionPointDescriptor> getInjectionPoints(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            GuiceInjectionUtil.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            GuiceInjectionUtil.$$$reportNull$$$0(1);
        }
        HashSet<InjectionPointDescriptor> ips = new HashSet<InjectionPointDescriptor>();
        JamService service = JamService.getJamService((Project)project);
        for (String injectAnno : GuiceAnnotations.INJECTS) {
            for (GuiceInject inject : service.getJamFieldElements(GuiceInject.FIELD_META, injectAnno, scope)) {
                ips.addAll(inject.getInjectionPoints());
            }
            for (GuiceInject inject : service.getJamMethodElements(GuiceInject.METHOD_META, injectAnno, scope)) {
                ips.addAll(inject.getInjectionPoints());
            }
        }
        return ips;
    }

    @NotNull
    public static Set<InjectionPointDescriptor> getInjectionPoints(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            GuiceInjectionUtil.$$$reportNull$$$0(2);
        }
        return GuiceInjectionUtil.getInjectionPoints(psiClass, true);
    }

    @NotNull
    public static Set<InjectionPointDescriptor> getInjectionPoints(@NotNull PsiClass psiClass, boolean checkDeep) {
        if (psiClass == null) {
            GuiceInjectionUtil.$$$reportNull$$$0(3);
        }
        HashSet<InjectionPointDescriptor> ips = new HashSet<InjectionPointDescriptor>();
        JamService service = JamService.getJamService((Project)psiClass.getProject());
        if (psiClass.isValid()) {
            int checkFlags = 7;
            if (checkDeep) {
                checkFlags |= 8;
            }
            for (GuiceInject inject : service.getAnnotatedMembersList(psiClass, GuiceInject.SEM_KEY, checkFlags)) {
                ips.addAll(inject.getInjectionPoints());
            }
        }
        HashSet<InjectionPointDescriptor> hashSet = ips;
        if (hashSet == null) {
            GuiceInjectionUtil.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    @NotNull
    public static List<GuiceProvides> getProvides(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            GuiceInjectionUtil.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            GuiceInjectionUtil.$$$reportNull$$$0(6);
        }
        JamService service = JamService.getJamService((Project)project);
        List list = service.getJamMethodElements(GuiceProvides.METHOD_META, "com.google.inject.Provides", scope);
        if (list == null) {
            GuiceInjectionUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public static Set<InjectionPointDescriptor> getInjectionPoints(@NotNull BindDescriptor descriptor, @NotNull Set<? extends InjectionPointDescriptor> allInjectionPointDescriptors) {
        if (descriptor == null) {
            GuiceInjectionUtil.$$$reportNull$$$0(8);
        }
        if (allInjectionPointDescriptors == null) {
            GuiceInjectionUtil.$$$reportNull$$$0(9);
        }
        HashSet<InjectionPointDescriptor> ips = new HashSet<InjectionPointDescriptor>();
        for (InjectionPointDescriptor injectionPointDescriptor : allInjectionPointDescriptors) {
            PsiClass psiClass;
            PsiType type = injectionPointDescriptor.getType();
            if (!(type instanceof PsiClassType) || (psiClass = ((PsiClassType)type).resolve()) == null || !psiClass.equals(descriptor.getBoundClass()) || !GuiceInjectionUtil.checkBindingAnnotations(injectionPointDescriptor, descriptor)) continue;
            ips.add(injectionPointDescriptor);
        }
        HashSet<InjectionPointDescriptor> hashSet = ips;
        if (hashSet == null) {
            GuiceInjectionUtil.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    @NotNull
    public static Set<InjectionPointDescriptor> getInjectionPoints(@NotNull GuiceProvides provides, @NotNull Set<? extends InjectionPointDescriptor> allInjectionPointDescriptors) {
        if (provides == null) {
            GuiceInjectionUtil.$$$reportNull$$$0(11);
        }
        if (allInjectionPointDescriptors == null) {
            GuiceInjectionUtil.$$$reportNull$$$0(12);
        }
        HashSet<InjectionPointDescriptor> ips = new HashSet<InjectionPointDescriptor>();
        PsiType productType = provides.getProductType();
        if (productType != null) {
            for (InjectionPointDescriptor injectionPointDescriptor : allInjectionPointDescriptors) {
                PsiType type = injectionPointDescriptor.getType();
                if (type == null || !productType.isAssignableFrom(type) || !GuiceInjectionUtil.checkBindingAnnotations(injectionPointDescriptor.getBindingAnnotations(), provides.getBindingAnnotations())) continue;
                ips.add(injectionPointDescriptor);
            }
        }
        HashSet<InjectionPointDescriptor> hashSet = ips;
        if (hashSet == null) {
            GuiceInjectionUtil.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    public static boolean checkBindingAnnotations(@NotNull Set<? extends PsiAnnotation> annotations, @NotNull Set<? extends PsiAnnotation> candidateAnnotations) {
        if (annotations == null) {
            GuiceInjectionUtil.$$$reportNull$$$0(14);
        }
        if (candidateAnnotations == null) {
            GuiceInjectionUtil.$$$reportNull$$$0(15);
        }
        if (annotations.size() != candidateAnnotations.size()) {
            return false;
        }
        for (PsiAnnotation psiAnnotation : annotations) {
            boolean hasAnno = false;
            for (PsiAnnotation psiAnnotation2 : candidateAnnotations) {
                if (!GuiceInjectionUtil.compareAnnotations(psiAnnotation, psiAnnotation2)) continue;
                hasAnno = true;
                break;
            }
            if (hasAnno) continue;
            return false;
        }
        return true;
    }

    private static boolean compareAnnotations(@NotNull PsiAnnotation anno, @NotNull PsiAnnotation candidateAnno) {
        String fqn1;
        if (anno == null) {
            GuiceInjectionUtil.$$$reportNull$$$0(16);
        }
        if (candidateAnno == null) {
            GuiceInjectionUtil.$$$reportNull$$$0(17);
        }
        if ((fqn1 = anno.getQualifiedName()) != null && fqn1.equals(candidateAnno.getQualifiedName())) {
            return GuiceInjectionUtil.compareAnnotationAttributes(GuiceInjectionUtil.getAnnotationAttributeValues(anno), GuiceInjectionUtil.getAnnotationAttributeValues(candidateAnno));
        }
        return false;
    }

    private static boolean compareAnnotationAttributes(@NotNull Set<Pair<String, PsiAnnotationMemberValue>> attrs, @NotNull Set<Pair<String, PsiAnnotationMemberValue>> candidateAttrs) {
        if (attrs == null) {
            GuiceInjectionUtil.$$$reportNull$$$0(18);
        }
        if (candidateAttrs == null) {
            GuiceInjectionUtil.$$$reportNull$$$0(19);
        }
        if (attrs.size() == 0 && candidateAttrs.size() == 0) {
            return true;
        }
        for (Pair<String, PsiAnnotationMemberValue> valuePair_1 : attrs) {
            for (Pair<String, PsiAnnotationMemberValue> valuePair_2 : candidateAttrs) {
                if (!((String)valuePair_1.first).equals(valuePair_2.first)) continue;
                PsiAnnotationMemberValue value_1 = (PsiAnnotationMemberValue)valuePair_1.getSecond();
                PsiAnnotationMemberValue value_2 = (PsiAnnotationMemberValue)valuePair_2.getSecond();
                if (value_1 instanceof PsiReference) {
                    if (value_2 instanceof PsiReference) {
                        PsiElement element1 = ((PsiReference)value_1).resolve();
                        PsiElement element2 = ((PsiReference)value_2).resolve();
                        return element1 != null && element2 != null && element1.equals(element2);
                    }
                } else {
                    Object attrValue = JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)value_1, Object.class);
                    Object candidateAttrValue = JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)value_2, Object.class);
                    return attrValue != null && candidateAttrValue != null && attrValue.equals(candidateAttrValue);
                }
                return false;
            }
        }
        return false;
    }

    @NotNull
    private static Set<Pair<String, PsiAnnotationMemberValue>> getAnnotationAttributeValues(@NotNull PsiAnnotation annotation) {
        PsiElement resolved;
        if (annotation == null) {
            GuiceInjectionUtil.$$$reportNull$$$0(20);
        }
        HashSet<Pair<String, PsiAnnotationMemberValue>> pairs = new HashSet<Pair<String, PsiAnnotationMemberValue>>();
        PsiJavaCodeReferenceElement referenceElement = annotation.getNameReferenceElement();
        if (referenceElement != null && (resolved = referenceElement.resolve()) != null) {
            PsiMethod[] methods;
            for (PsiMethod psiMethod : methods = ((PsiClass)resolved).getMethods()) {
                if (!PsiUtil.isAnnotationMethod((PsiElement)psiMethod)) continue;
                String attributeName = psiMethod.getName();
                pairs.add((Pair<String, PsiAnnotationMemberValue>)Pair.create((Object)attributeName, (Object)annotation.findAttributeValue(attributeName)));
            }
        }
        HashSet<Pair<String, PsiAnnotationMemberValue>> hashSet = pairs;
        if (hashSet == null) {
            GuiceInjectionUtil.$$$reportNull$$$0(21);
        }
        return hashSet;
    }

    public static boolean checkBindingAnnotations(InjectionPointDescriptor ip, @NotNull BindDescriptor descriptor) {
        Set<PsiAnnotation> bindingAnnotations;
        if (descriptor == null) {
            GuiceInjectionUtil.$$$reportNull$$$0(22);
        }
        if ((bindingAnnotations = ip.getBindingAnnotations()).size() > 1) {
            return false;
        }
        PsiMethodCallExpression expression = descriptor.getBindExpression();
        PsiClass annotatedWith = GuiceInjectionUtil.getCallExpressionType(expression, "annotatedWith");
        if (annotatedWith == null && bindingAnnotations.size() == 0) {
            return true;
        }
        if (annotatedWith != null && bindingAnnotations.size() == 1) {
            PsiAnnotation bindingAnno = bindingAnnotations.iterator().next();
            if ("com.google.inject.name.Named".equals(annotatedWith.getQualifiedName())) {
                PsiExpression annotatedWithExpression;
                if ("com.google.inject.name.Named".equals(bindingAnno.getQualifiedName()) && (annotatedWithExpression = GuiceUtils.getArgumentOfCallInChain(expression, "annotatedWith")) != null) {
                    String nameValue = GuiceInjectionUtil.getNameValue(annotatedWithExpression);
                    if (nameValue == null) {
                        return true;
                    }
                    return nameValue.equals(AnnotationUtil.getStringAttributeValue((PsiAnnotation)bindingAnno, (String)"value"));
                }
                return false;
            }
            String bindingAnnoQualifiedName = bindingAnno.getQualifiedName();
            if (bindingAnnoQualifiedName != null) {
                return bindingAnnoQualifiedName.equals(annotatedWith.getQualifiedName());
            }
        }
        return false;
    }

    @Nullable
    private static String getNameValue(@NotNull PsiExpression annotatedWithExpression) {
        Pair pair;
        PsiExpression namedExpression;
        if (annotatedWithExpression == null) {
            GuiceInjectionUtil.$$$reportNull$$$0(23);
        }
        if ((namedExpression = GuiceInjectionUtil.findNamedExpression(annotatedWithExpression)) != null && (pair = StringExpressionHelper.evaluateExpression((PsiElement)namedExpression)) != null) {
            return (String)pair.getSecond();
        }
        return null;
    }

    @Nullable
    public static PsiExpression findNamedExpression(PsiExpression annotatedWithExpression) {
        PsiExpression initializer;
        PsiElement resolve;
        if (annotatedWithExpression instanceof PsiMethodCallExpression) {
            PsiExpression named;
            PsiMethodCallExpression expression = (PsiMethodCallExpression)annotatedWithExpression;
            PsiMethod method = expression.resolveMethod();
            if (method != null) {
                if ("named".equals(method.getName())) {
                    PsiExpression[] expressions = expression.getArgumentList().getExpressions();
                    return expressions.length > 0 ? expressions[0] : null;
                }
                PsiCodeBlock body = method.getBody();
                if (body != null) {
                    final HashSet returns = new HashSet();
                    body.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                        public void visitClass(PsiClass aClass) {
                        }

                        public void visitLambdaExpression(PsiLambdaExpression expression) {
                        }

                        public void visitReturnStatement(PsiReturnStatement statement) {
                            PsiExpression returnValue = statement.getReturnValue();
                            if (returnValue != null) {
                                returns.add(returnValue);
                            }
                        }
                    });
                    for (PsiExpression psiExpression : returns) {
                        PsiExpression namedExpression = GuiceInjectionUtil.findNamedExpression(psiExpression);
                        if (namedExpression == null) continue;
                        return namedExpression;
                    }
                }
            }
            if ((named = GuiceUtils.getArgumentOfCallInChain(expression, "named")) != null) {
                return named;
            }
        }
        if (annotatedWithExpression instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)annotatedWithExpression).resolve()) instanceof PsiVariable && (initializer = ((PsiVariable)resolve).getInitializer()) != null) {
            return GuiceInjectionUtil.findNamedExpression(initializer);
        }
        return null;
    }

    @Nullable
    public static PsiClass getCallExpressionType(@NotNull PsiMethodCallExpression expression, String name) {
        if (expression == null) {
            GuiceInjectionUtil.$$$reportNull$$$0(24);
        }
        PsiClass aClass = null;
        PsiExpression psiExpression = GuiceUtils.getArgumentOfCallInChain(expression, name);
        if (psiExpression != null) {
            if (psiExpression instanceof PsiClassObjectAccessExpression) {
                PsiType classType = ((PsiClassObjectAccessExpression)psiExpression).getOperand().getType();
                if (classType instanceof PsiClassType) {
                    aClass = ((PsiClassType)classType).resolve();
                }
            } else {
                PsiType psiType = psiExpression.getType();
                if (psiType instanceof PsiClassType) {
                    aClass = ((PsiClassType)psiType).resolve();
                }
            }
        }
        return aClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/guice/model/GuiceInjectionUtil";
                break;
            }
            case 8: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allInjectionPointDescriptors";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provides";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateAnnotations";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateAnno";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateAttrs";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotatedWithExpression";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/guice/model/GuiceInjectionUtil";
                break;
            }
            case 4: 
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectionPoints";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvides";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationAttributeValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInjectionPoints";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 21: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getProvides";
                break;
            }
            case 14: 
            case 15: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkBindingAnnotations";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "compareAnnotations";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "compareAnnotationAttributes";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationAttributeValues";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getNameValue";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getCallExpressionType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

