/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.intentions;

import com.intellij.guice.GuiceBundle;
import com.intellij.guice.intentions.Intention;
import com.intellij.guice.intentions.MoveProviderBindingToClassPredicate;
import com.intellij.guice.intentions.PsiElementPredicate;
import com.intellij.guice.utils.GuiceUtils;
import com.intellij.guice.utils.MutationUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MoveProviderBindingToClassIntention
extends Intention {
    @NotNull
    public String getText() {
        String string = GuiceBundle.message("move.provider.binding.to.class.text", new Object[0]);
        if (string == null) {
            MoveProviderBindingToClassIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GuiceBundle.message("move.provider.binding.to.class.family.name", new Object[0]);
        if (string == null) {
            MoveProviderBindingToClassIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new MoveProviderBindingToClassPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            MoveProviderBindingToClassIntention.$$$reportNull$$$0(2);
        }
        PsiMethodCallExpression originalCall = (PsiMethodCallExpression)element;
        PsiClass providerClass = GuiceUtils.findProvidingClassForBinding(originalCall);
        PsiClass implementedClass = GuiceUtils.findImplementedClassForBinding(originalCall);
        MutationUtils.addAnnotation((PsiModifierListOwner)implementedClass, "@com.google.inject.ProvidedBy(" + providerClass.getQualifiedName() + ".class)");
        PsiMethodCallExpression bindingCall = GuiceUtils.findProvidingCallForBinding(originalCall);
        PsiExpression qualifier = bindingCall.getMethodExpression().getQualifierExpression();
        assert (qualifier != null);
        MutationUtils.replaceExpression(qualifier.getText(), (PsiExpression)bindingCall);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/guice/intentions/MoveProviderBindingToClassIntention";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/guice/intentions/MoveProviderBindingToClassIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

