/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.guice.GuiceBundle;
import com.intellij.guice.utils.MutationUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

class DeleteBindingFix
implements LocalQuickFix {
    private static final Logger LOGGER = Logger.getInstance((String)"RedundantToProviderBindingInspection");

    DeleteBindingFix() {
    }

    @NotNull
    public String getName() {
        String string = GuiceBundle.message("delete.binding", new Object[0]);
        if (string == null) {
            DeleteBindingFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return "";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            DeleteBindingFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            DeleteBindingFix.$$$reportNull$$$0(2);
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethodCallExpression.class);
        assert (call != null);
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        try {
            assert (qualifier != null);
            MutationUtils.replaceExpression(qualifier.getText(), (PsiExpression)call);
        }
        catch (IncorrectOperationException e) {
            LOGGER.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/guice/inspections/DeleteBindingFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/guice/inspections/DeleteBindingFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

