/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.guice.inspections.BaseInspection;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseInspectionVisitor
extends JavaElementVisitor {
    private BaseInspection inspection = null;
    private boolean onTheFly = false;
    private final List<ProblemDescriptor> errors = null;
    private ProblemsHolder holder = null;
    private InspectionManager inspectionManager;

    public void setInspection(BaseInspection inspection) {
        this.inspection = inspection;
    }

    public void setOnTheFly(boolean onTheFly) {
        this.onTheFly = onTheFly;
    }

    protected void registerMethodCallError(PsiMethodCallExpression expression, Object ... infos) {
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiElement nameToken = methodExpression.getReferenceNameElement();
        this.registerError((PsiElement)(nameToken != null ? nameToken : expression), infos);
    }

    protected void registerStatementError(PsiStatement statement, Object ... infos) {
        PsiElement statementToken = statement.getFirstChild();
        this.registerError((PsiElement)(statementToken != null ? statementToken : statement), infos);
    }

    protected void registerClassError(PsiClass aClass, Object ... infos) {
        PsiIdentifier nameIdentifier;
        if (aClass instanceof PsiAnonymousClass) {
            PsiAnonymousClass anonymousClass = (PsiAnonymousClass)aClass;
            nameIdentifier = anonymousClass.getBaseClassReference();
        } else {
            nameIdentifier = aClass.getNameIdentifier();
        }
        this.registerError((PsiElement)(nameIdentifier != null ? nameIdentifier : aClass.getContainingFile()), infos);
    }

    protected void registerMethodError(PsiMethod method, Object ... infos) {
        PsiIdentifier nameIdentifier = method.getNameIdentifier();
        this.registerError((PsiElement)(nameIdentifier != null ? nameIdentifier : method.getContainingFile()), infos);
    }

    protected void registerVariableError(PsiVariable variable, Object ... infos) {
        PsiIdentifier nameIdentifier = variable.getNameIdentifier();
        this.registerError((PsiElement)(nameIdentifier != null ? nameIdentifier : variable.getContainingFile()), infos);
    }

    protected void registerTypeParameterError(PsiTypeParameter param, Object ... infos) {
        PsiIdentifier nameIdentifier = param.getNameIdentifier();
        this.registerError((PsiElement)nameIdentifier, infos);
    }

    protected void registerFieldError(PsiField field, Object ... infos) {
        PsiIdentifier nameIdentifier = field.getNameIdentifier();
        this.registerError((PsiElement)nameIdentifier, infos);
    }

    protected void registerModifierError(String modifier, PsiModifierListOwner parameter, Object ... infos) {
        PsiElement[] children;
        PsiModifierList modifiers = parameter.getModifierList();
        if (modifiers == null) {
            return;
        }
        for (PsiElement child : children = modifiers.getChildren()) {
            String text = child.getText();
            if (!modifier.equals(text)) continue;
            this.registerError(child, infos);
        }
    }

    protected void registerError(@NotNull PsiElement location, Object ... infos) {
        if (location == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(0);
        }
        LocalQuickFix[] fixes = this.createFixes(location, infos);
        String description = this.inspection.buildErrorString(infos);
        this.holder.registerProblem(location, description, fixes);
    }

    public ProblemDescriptor @Nullable [] getErrors() {
        if (this.errors == null) {
            return null;
        }
        int numErrors = this.errors.size();
        return this.errors.toArray(new ProblemDescriptor[numErrors]);
    }

    private LocalQuickFix @Nullable [] createFixes(PsiElement location, Object[] infos) {
        if (!this.onTheFly && this.inspection.buildQuickFixesOnlyForOnTheFlyErrors()) {
            return null;
        }
        LocalQuickFix fix = this.inspection.buildFix(location, infos);
        if (fix == null) {
            return null;
        }
        return new LocalQuickFix[]{fix};
    }

    public void visitReferenceExpression(PsiReferenceExpression expression) {
        this.visitExpression((PsiExpression)expression);
    }

    public void visitWhiteSpace(@NotNull PsiWhiteSpace space) {
        if (space == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(1);
        }
    }

    public void setProblemsHolder(ProblemsHolder holder) {
        this.holder = holder;
    }

    public void initialize() {
    }

    public void setInspectionManager(InspectionManager inspectionManager) {
        this.inspectionManager = inspectionManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "space";
                break;
            }
        }
        objectArray2[1] = "com/intellij/guice/inspections/BaseInspectionVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerError";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitWhiteSpace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

