/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.actions;

import com.intellij.guice.GuiceBundle;
import com.intellij.guice.actions.GeneratePluginClassAction;
import com.intellij.guice.actions.GuiceProviderBuilder;
import com.intellij.guice.actions.ProviderDialog;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class NewGuiceProviderAction
extends GeneratePluginClassAction {
    private static final Logger LOGGER = Logger.getInstance((String)"NewGuiceProviderAction");
    private String providedClassName = null;

    public NewGuiceProviderAction() {
        super(GuiceBundle.messagePointer("new.guice.provider.action.name", new Object[0]), GuiceBundle.messagePointer("new.guice.provider.action.name", new Object[0]), null);
    }

    @Override
    protected PsiElement[] invokeDialogImpl(Project project, PsiDirectory directory) {
        ProviderDialog dialog = new ProviderDialog(project);
        if (dialog.showAndGet()) {
            String providerName = dialog.getProviderName();
            this.providedClassName = dialog.getProvidedClass();
            CreateElementActionBase.MyInputValidator validator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, directory);
            validator.canClose(providerName);
            return validator.getCreatedElements();
        }
        return PsiElement.EMPTY_ARRAY;
    }

    protected PsiElement @NotNull [] create(@NotNull String newName, PsiDirectory directory) {
        PsiElement[] psiElementArray;
        block7: {
            String beanClassString;
            if (newName == null) {
                NewGuiceProviderAction.$$$reportNull$$$0(0);
            }
            Project project = directory.getProject();
            PsiFileFactory elementFactory = PsiFileFactory.getInstance((Project)project);
            GuiceProviderBuilder builder = new GuiceProviderBuilder();
            builder.setClassName(newName);
            builder.setProvidedClassName(this.providedClassName);
            try {
                beanClassString = builder.buildProviderClass(project);
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e);
                if (PsiElement.EMPTY_ARRAY == null) {
                    NewGuiceProviderAction.$$$reportNull$$$0(1);
                }
                return PsiElement.EMPTY_ARRAY;
            }
            try {
                PsiFile newFile = elementFactory.createFileFromText(newName + ".java", beanClassString);
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                PsiElement shortenedFile = codeStyleManager.shortenClassReferences((PsiElement)newFile);
                PsiElement reformattedFile = CodeStyleManager.getInstance((Project)project).reformat(shortenedFile);
                directory.add(reformattedFile);
                psiElementArray = new PsiElement[]{reformattedFile};
                if (psiElementArray != null) break block7;
            }
            catch (IncorrectOperationException e) {
                LOGGER.error((Throwable)e);
                if (PsiElement.EMPTY_ARRAY == null) {
                    NewGuiceProviderAction.$$$reportNull$$$0(3);
                }
                return PsiElement.EMPTY_ARRAY;
            }
            NewGuiceProviderAction.$$$reportNull$$$0(2);
        }
        return psiElementArray;
    }

    protected String getErrorTitle() {
        return GuiceBundle.message("new.guice.provider.error", new Object[0]);
    }

    protected String getActionName(PsiDirectory directory, String newName) {
        return GuiceBundle.message("new.guice.provider.name", directory, newName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/guice/actions/NewGuiceProviderAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/guice/actions/NewGuiceProviderAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

