/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.actions;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;

public class GuiceProviderBuilder {
    private String className = null;
    private String providedClassName = null;

    public void setClassName(String className) {
        this.className = className;
    }

    public void setProvidedClassName(String providedClassName) {
        this.providedClassName = providedClassName;
    }

    public String buildProviderClass(Project project) throws IOException {
        FileTemplate headerTemplate;
        @NonNls StringBuilder out = new StringBuilder(1024);
        FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)project);
        try {
            headerTemplate = templateManager.getDefaultTemplate("File Header");
        }
        catch (Exception e) {
            headerTemplate = null;
        }
        Properties defaultProperties = templateManager.getDefaultProperties();
        @NonNls Properties properties = new Properties(defaultProperties);
        properties.setProperty("PACKAGE_NAME", "");
        properties.setProperty("NAME", this.className);
        if (headerTemplate != null) {
            @NonNls String headerText = headerTemplate.getText(properties);
            String cleanedText = headerText.replace("public file header " + this.className + " { }", "");
            out.append(cleanedText);
        }
        out.append('\n');
        out.append("public class " + this.className);
        out.append(" implements ");
        out.append("com.google.inject.Provider");
        out.append("<" + this.providedClassName + ">");
        out.append('\n');
        out.append('{');
        out.append("public " + this.providedClassName + " get(){\n");
        out.append("//TODO: add provider logic here\n");
        out.append("return null;\n");
        out.append("}\n}\n");
        return out.toString();
    }
}

