/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.helidon.utils;

import com.intellij.helidon.providers.HelidonRequestMethods;
import com.intellij.helidon.providers.HelidonUrlPathSpecification;
import com.intellij.microservices.uast.url.UastUrlAttributeUtils;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.HttpUrlResolver;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.UrlPksParser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PartiallyKnownString;
import icons.HelidonIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.Icon;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HelidonUrlTargetInfo
implements UrlTargetInfo {
    private final String urlDefinition;
    private final SmartPsiElementPointer<PsiElement> myElementPointer;
    private HelidonRequestMethods myType;
    private String myParentUrl;
    private final NotNullLazyValue<UrlPath> myUrlPath;

    public static HelidonUrlTargetInfo create(@NotNull String url, @NotNull PsiElement resolveTo) {
        if (url == null) {
            HelidonUrlTargetInfo.$$$reportNull$$$0(0);
        }
        if (resolveTo == null) {
            HelidonUrlTargetInfo.$$$reportNull$$$0(1);
        }
        return new HelidonUrlTargetInfo(url, resolveTo);
    }

    public HelidonUrlTargetInfo ofType(HelidonRequestMethods type) {
        this.myType = type;
        return this;
    }

    @NotNull
    public Set<String> getMethods() {
        if (this.myType == HelidonRequestMethods.UNKNOWN || this.myType == HelidonRequestMethods.ANY_OF) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                HelidonUrlTargetInfo.$$$reportNull$$$0(2);
            }
            return set;
        }
        Set<String> set = Collections.singleton(this.myType.name().toUpperCase(Locale.ENGLISH));
        if (set == null) {
            HelidonUrlTargetInfo.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public String getSource() {
        String string = UastUrlAttributeUtils.getUastDeclaringLocation((PsiElement)this.resolveToPsiElement());
        if (string == null) {
            HelidonUrlTargetInfo.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public PsiElement getDocumentationPsiElement() {
        return UastUrlAttributeUtils.getUastDeclaringDocumentationElement((PsiElement)this.resolveToPsiElement());
    }

    public HelidonUrlTargetInfo withParentUrl(String parentUrl) {
        this.myParentUrl = parentUrl;
        return this;
    }

    private HelidonUrlTargetInfo(@NotNull String url, @NotNull PsiElement resolveTo) {
        if (url == null) {
            HelidonUrlTargetInfo.$$$reportNull$$$0(5);
        }
        if (resolveTo == null) {
            HelidonUrlTargetInfo.$$$reportNull$$$0(6);
        }
        this.myType = HelidonRequestMethods.UNKNOWN;
        this.myParentUrl = null;
        this.myUrlPath = new NotNullLazyValue<UrlPath>(){

            @NotNull
            protected UrlPath compute() {
                UrlPath urlPath = HelidonUrlTargetInfo.this.computeUrlPath();
                if (urlPath == null) {
                    1.$$$reportNull$$$0(0);
                }
                return urlPath;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/helidon/utils/HelidonUrlTargetInfo$1", "compute"));
            }
        };
        this.urlDefinition = url;
        this.myElementPointer = SmartPointerManager.getInstance((Project)resolveTo.getProject()).createSmartPsiElementPointer(resolveTo);
    }

    @NotNull
    private UrlPath computeUrlPath() {
        StringBuilder sb = new StringBuilder();
        if (this.myParentUrl != null) {
            sb.append(this.myParentUrl);
        }
        if (sb.toString().endsWith("/")) {
            sb.append(StringsKt.removePrefix((String)this.urlDefinition, (CharSequence)"/"));
        } else {
            if (!this.urlDefinition.startsWith("/")) {
                sb.append("/");
            }
            sb.append(this.urlDefinition);
        }
        String url = StringsKt.removePrefix((String)sb.toString(), (CharSequence)"/");
        UrlPksParser.ParsedPksUrlPath urlPath = HelidonUrlPathSpecification.INSTANCE.getParser().parseUrlPath(new PartiallyKnownString(url));
        if (urlPath == null) {
            UrlPath urlPath2 = UrlPath.Companion.fromExactString(url);
            if (urlPath2 == null) {
                HelidonUrlTargetInfo.$$$reportNull$$$0(7);
            }
            return urlPath2;
        }
        UrlPath urlPath3 = urlPath.getUrlPath();
        if (urlPath3 == null) {
            HelidonUrlTargetInfo.$$$reportNull$$$0(8);
        }
        return urlPath3;
    }

    @NotNull
    public List<String> getSchemes() {
        List list = UrlConstants.HTTP_SCHEMES;
        if (list == null) {
            HelidonUrlTargetInfo.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<Authority> getAuthorities() {
        return new ArrayList<Authority>(HttpUrlResolver.Companion.getHTTP_AUTHORITY());
    }

    @NotNull
    public UrlPath getPath() {
        UrlPath urlPath = (UrlPath)this.myUrlPath.getValue();
        if (urlPath == null) {
            HelidonUrlTargetInfo.$$$reportNull$$$0(10);
        }
        return urlPath;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = HelidonIcons.Helidon;
        if (icon == null) {
            HelidonUrlTargetInfo.$$$reportNull$$$0(11);
        }
        return icon;
    }

    public boolean isDeprecated() {
        return UastUrlAttributeUtils.isUastDeclarationDeprecated((PsiElement)this.resolveToPsiElement());
    }

    @Nullable
    public String getParentUrl() {
        return this.myParentUrl;
    }

    @NotNull
    public String getUrlDefinition() {
        String string = this.urlDefinition;
        if (string == null) {
            HelidonUrlTargetInfo.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    public PsiElement resolveToPsiElement() {
        return this.myElementPointer.getElement();
    }

    public HelidonRequestMethods getType() {
        return this.myType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveTo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/helidon/utils/HelidonUrlTargetInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/helidon/utils/HelidonUrlTargetInfo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSource";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "computeUrlPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

