/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.helidon.utils;

import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.helidon.providers.HelidonReferenceContributor;
import com.intellij.helidon.providers.HelidonRequestMethods;
import com.intellij.helidon.utils.HelidonUrlTargetInfo;
import com.intellij.jam.JavaLibraryUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.uast.UastSmartPointer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public final class HelidonCommonUtils {
    private static final Key<CachedValue<Map<SearchScope, Set<UCallExpression>>>> METHOD_INVOCATIONS_KEY = Key.create((String)"METHOD_INVOCATIONS_KEY");

    private HelidonCommonUtils() {
    }

    public static boolean hasHelidonLibrary(Project project) {
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)"io.helidon.webserver.Routing");
    }

    public static boolean hasHelidonLibrary(@Nullable Module module) {
        return JavaLibraryUtils.hasLibraryClass((Module)module, (String)"io.helidon.webserver.Routing");
    }

    @NotNull
    public static Set<String> getParentUrlPaths(@Nullable PsiElement host) {
        if (host == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                HelidonCommonUtils.$$$reportNull$$$0(0);
            }
            return set;
        }
        Set<String> paths = (Set<String>)RecursionManager.doPreventingRecursion((Object)host, (boolean)true, () -> HelidonCommonUtils.calculateParentUrls(host));
        Set<String> set = paths != null ? paths : Collections.emptySet();
        if (set == null) {
            HelidonCommonUtils.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    private static Set<String> calculateParentUrls(@NotNull PsiElement host) {
        if (host == null) {
            HelidonCommonUtils.$$$reportNull$$$0(2);
        }
        HashSet<String> allParentPaths = new HashSet<String>();
        UClass definedInUClass = (UClass)UastContextKt.getUastParentOfType((PsiElement)host, UClass.class);
        if (definedInUClass == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                HelidonCommonUtils.$$$reportNull$$$0(3);
            }
            return set;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)host);
        if (module == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                HelidonCommonUtils.$$$reportNull$$$0(4);
            }
            return set;
        }
        for (PsiMethod registerMethod : HelidonCommonUtils.getBuilderRegisterMethod(module)) {
            Map<String, UExpression> expressionMap = HelidonCommonUtils.mapUrlsToServiceInvocations(module, registerMethod);
            for (Map.Entry<String, UExpression> entry : expressionMap.entrySet()) {
                PsiClassType psiClassType;
                PsiType type;
                String urlDefinition = entry.getKey();
                if (!StringUtil.isNotEmpty((String)urlDefinition) || (type = entry.getValue().getExpressionType()) == null || !type.isAssignableFrom((PsiType)(psiClassType = JavaPsiFacade.getElementFactory((Project)host.getProject()).createType(definedInUClass.getJavaPsi())))) continue;
                Set<String> parentUrlPaths = HelidonCommonUtils.getParentUrlPaths(entry.getValue().getSourcePsi());
                if (parentUrlPaths.isEmpty()) {
                    allParentPaths.add(urlDefinition);
                    continue;
                }
                for (String path : parentUrlPaths) {
                    if (!StringUtil.isNotEmpty((String)path)) continue;
                    allParentPaths.add(path + urlDefinition);
                }
            }
        }
        HashSet<String> hashSet = allParentPaths;
        if (hashSet == null) {
            HelidonCommonUtils.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @NotNull
    private static Map<String, UExpression> mapUrlsToServiceInvocations(@NotNull Module module, @NotNull PsiMethod registerMethod) {
        if (module == null) {
            HelidonCommonUtils.$$$reportNull$$$0(6);
        }
        if (registerMethod == null) {
            HelidonCommonUtils.$$$reportNull$$$0(7);
        }
        HashMap<String, UExpression> resultMap = new HashMap<String, UExpression>();
        for (UCallExpression uCallExpression : HelidonCommonUtils.getUCallExpressions((SearchScope)HelidonCommonUtils.getRoutingClassReferencesScope(module), registerMethod)) {
            String expressionText;
            List valueArguments = uCallExpression.getValueArguments();
            if (valueArguments.size() != 2 || (expressionText = HelidonCommonUtils.getUExpressionText((UExpression)valueArguments.get(0))) == null) continue;
            resultMap.put(expressionText, (UExpression)valueArguments.get(1));
        }
        HashMap<String, UExpression> hashMap = resultMap;
        if (hashMap == null) {
            HelidonCommonUtils.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    @NotNull
    public static Map<UastSmartPointer<UCallExpression>, PsiType> getServiceRegisterInvocations(@NotNull Module module) {
        if (module == null) {
            HelidonCommonUtils.$$$reportNull$$$0(9);
        }
        HashMap<UastSmartPointer<UCallExpression>, PsiType> resultMap = new HashMap<UastSmartPointer<UCallExpression>, PsiType>();
        GlobalSearchScope scope = HelidonCommonUtils.getRoutingClassReferencesScope(module);
        for (PsiMethod registerMethod : HelidonCommonUtils.getBuilderRegisterMethod(module)) {
            for (UCallExpression uCallExpression : HelidonCommonUtils.getUCallExpressions((SearchScope)scope, registerMethod)) {
                PsiType serviceType = HelidonCommonUtils.getRegisteredServiceType(uCallExpression);
                if (serviceType == null) continue;
                resultMap.put((UastSmartPointer<UCallExpression>)new UastSmartPointer((UElement)uCallExpression, UCallExpression.class), serviceType);
            }
        }
        HashMap<UastSmartPointer<UCallExpression>, PsiType> hashMap = resultMap;
        if (hashMap == null) {
            HelidonCommonUtils.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    @NotNull
    private static Set<UCallExpression> getUCallExpressions(@NotNull SearchScope scope, @NotNull PsiMethod psiMethod) {
        if (scope == null) {
            HelidonCommonUtils.$$$reportNull$$$0(11);
        }
        if (psiMethod == null) {
            HelidonCommonUtils.$$$reportNull$$$0(12);
        }
        if (!psiMethod.isValid()) {
            Set<UCallExpression> set = Collections.emptySet();
            if (set == null) {
                HelidonCommonUtils.$$$reportNull$$$0(13);
            }
            return set;
        }
        Map value = (Map)CachedValuesManager.getManager((Project)psiMethod.getProject()).getCachedValue((UserDataHolder)psiMethod, METHOD_INVOCATIONS_KEY, () -> CachedValueProvider.Result.create(HelidonCommonUtils.createMethodsInScopeMap(psiMethod), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)psiMethod.getProject())}), false);
        Set set = (Set)value.get(scope);
        if (set == null) {
            HelidonCommonUtils.$$$reportNull$$$0(14);
        }
        return set;
    }

    @NotNull
    private static Map<SearchScope, Set<UCallExpression>> createMethodsInScopeMap(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            HelidonCommonUtils.$$$reportNull$$$0(15);
        }
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(forScope -> {
            Set expressions = MethodReferencesSearch.search((PsiMethod)psiMethod, (SearchScope)forScope, (boolean)true).findAll().stream().map(reference -> (UCallExpression)UastContextKt.getUastParentOfType((PsiElement)reference.getElement(), UCallExpression.class)).filter(Objects::nonNull).collect(Collectors.toSet());
            return expressions;
        });
        if (concurrentMap == null) {
            HelidonCommonUtils.$$$reportNull$$$0(16);
        }
        return concurrentMap;
    }

    @Nullable
    public static PsiType getRegisteredServiceType(@NotNull UCallExpression callExpression) {
        List arguments;
        if (callExpression == null) {
            HelidonCommonUtils.$$$reportNull$$$0(17);
        }
        return (arguments = callExpression.getValueArguments()).size() == 2 ? ((UExpression)arguments.get(1)).getExpressionType() : null;
    }

    public static boolean processBuilderRegisterMethodsWithProgress(@NotNull Processor<? super HelidonUrlTargetInfo> processor, @NotNull GlobalSearchScope scope, @NotNull Module module) {
        if (processor == null) {
            HelidonCommonUtils.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            HelidonCommonUtils.$$$reportNull$$$0(19);
        }
        if (module == null) {
            HelidonCommonUtils.$$$reportNull$$$0(20);
        }
        return (Boolean)HelidonCommonUtils.withProgressIndicator(() -> HelidonCommonUtils.processBuilderRegisterMethods(processor, scope, module));
    }

    public static boolean processBuilderRegisterMethods(@NotNull Processor<? super HelidonUrlTargetInfo> processor, @NotNull GlobalSearchScope scope, @NotNull Module module) {
        if (processor == null) {
            HelidonCommonUtils.$$$reportNull$$$0(21);
        }
        if (scope == null) {
            HelidonCommonUtils.$$$reportNull$$$0(22);
        }
        if (module == null) {
            HelidonCommonUtils.$$$reportNull$$$0(23);
        }
        for (PsiMethod registerMethod : HelidonCommonUtils.getBuilderRegisterMethod(module)) {
            if (HelidonCommonUtils.findAndProcessTargets(processor, (SearchScope)scope, registerMethod, HelidonRequestMethods.REGISTER, 0)) continue;
            return false;
        }
        return true;
    }

    public static boolean processRulesHttpMethods(@NotNull Processor<? super HelidonUrlTargetInfo> processor, @NotNull SearchScope scope, @Nullable Module module) {
        if (processor == null) {
            HelidonCommonUtils.$$$reportNull$$$0(24);
        }
        if (scope == null) {
            HelidonCommonUtils.$$$reportNull$$$0(25);
        }
        if (module == null) {
            return true;
        }
        for (Pair<PsiMethod, HelidonRequestMethods> rulesMethod : HelidonCommonUtils.getRulesHttpMethods(module)) {
            if (HelidonCommonUtils.findAndProcessTargets(processor, scope, (PsiMethod)rulesMethod.first, (HelidonRequestMethods)((Object)rulesMethod.second), 0)) continue;
            return false;
        }
        return true;
    }

    public static boolean processBuilderHttpMethods(@NotNull Processor<? super HelidonUrlTargetInfo> processor, @NotNull SearchScope scope, @Nullable Module module) {
        if (processor == null) {
            HelidonCommonUtils.$$$reportNull$$$0(26);
        }
        if (scope == null) {
            HelidonCommonUtils.$$$reportNull$$$0(27);
        }
        if (module == null) {
            return true;
        }
        for (Pair<PsiMethod, HelidonRequestMethods> rulesMethod : HelidonCommonUtils.getBuilderHttpMethods(module)) {
            if (HelidonCommonUtils.findAndProcessTargets(processor, scope, (PsiMethod)rulesMethod.first, (HelidonRequestMethods)((Object)rulesMethod.second), 0)) continue;
            return false;
        }
        return true;
    }

    private static boolean findAndProcessTargets(@NotNull Processor<? super HelidonUrlTargetInfo> processor, @NotNull SearchScope scope, @NotNull PsiMethod psiMethod, @NotNull HelidonRequestMethods requestMethods, int expressionNum) {
        if (processor == null) {
            HelidonCommonUtils.$$$reportNull$$$0(28);
        }
        if (scope == null) {
            HelidonCommonUtils.$$$reportNull$$$0(29);
        }
        if (psiMethod == null) {
            HelidonCommonUtils.$$$reportNull$$$0(30);
        }
        if (requestMethods == null) {
            HelidonCommonUtils.$$$reportNull$$$0(31);
        }
        for (UExpression expression : HelidonCommonUtils.findExpressions(psiMethod, scope, expressionNum)) {
            if (HelidonCommonUtils.processExpressions(processor, requestMethods, expression)) continue;
            return false;
        }
        return true;
    }

    private static boolean processExpressions(@NotNull Processor<? super HelidonUrlTargetInfo> processor, @NotNull HelidonRequestMethods requestMethods, @NotNull UExpression expression) {
        PsiElement javaPsi;
        String expressionText;
        if (processor == null) {
            HelidonCommonUtils.$$$reportNull$$$0(32);
        }
        if (requestMethods == null) {
            HelidonCommonUtils.$$$reportNull$$$0(33);
        }
        if (expression == null) {
            HelidonCommonUtils.$$$reportNull$$$0(34);
        }
        return !((expressionText = HelidonCommonUtils.getUExpressionText(expression)) != null ? !HelidonCommonUtils.processTargets(processor, expression, expressionText, requestMethods, HelidonCommonUtils.getParentUrlPaths(expression.getSourcePsi())) : (javaPsi = expression.getJavaPsi()) instanceof PsiExpression && !HelidonCommonUtils.processJavaStringExpressions(processor, requestMethods, (PsiExpression)javaPsi));
    }

    @Nullable
    private static String getUExpressionText(UExpression expression) {
        return UastUtils.evaluateString((UExpression)expression);
    }

    private static boolean processJavaStringExpressions(@NotNull Processor<? super HelidonUrlTargetInfo> processor, @NotNull HelidonRequestMethods requestMethods, @NotNull PsiExpression expression) {
        UElement uElement;
        Pair pair;
        if (processor == null) {
            HelidonCommonUtils.$$$reportNull$$$0(35);
        }
        if (requestMethods == null) {
            HelidonCommonUtils.$$$reportNull$$$0(36);
        }
        if (expression == null) {
            HelidonCommonUtils.$$$reportNull$$$0(37);
        }
        return (pair = StringExpressionHelper.evaluateExpression((PsiElement)expression)) == null || !((uElement = UastContextKt.toUElement((PsiElement)((PsiElement)pair.first))) instanceof UExpression) || HelidonCommonUtils.processTargets(processor, (UExpression)uElement, (String)pair.second, requestMethods, HelidonCommonUtils.getParentUrlPaths((PsiElement)pair.first));
    }

    @NotNull
    private static Set<UExpression> findExpressions(@NotNull PsiMethod psiMethod, @NotNull SearchScope scope, int expNum) {
        if (psiMethod == null) {
            HelidonCommonUtils.$$$reportNull$$$0(38);
        }
        if (scope == null) {
            HelidonCommonUtils.$$$reportNull$$$0(39);
        }
        Set<UExpression> set = HelidonCommonUtils.getUCallExpressions(scope, psiMethod).stream().map(uCallExpression -> uCallExpression.getArgumentForParameter(expNum)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set == null) {
            HelidonCommonUtils.$$$reportNull$$$0(40);
        }
        return set;
    }

    private static boolean processTargets(@NotNull Processor<? super HelidonUrlTargetInfo> processor, @NotNull UExpression resolveTo, @NotNull String url, HelidonRequestMethods requestMethods, @NotNull Set<String> parentUrlPaths) {
        PsiElement psiElement;
        if (processor == null) {
            HelidonCommonUtils.$$$reportNull$$$0(41);
        }
        if (resolveTo == null) {
            HelidonCommonUtils.$$$reportNull$$$0(42);
        }
        if (url == null) {
            HelidonCommonUtils.$$$reportNull$$$0(43);
        }
        if (parentUrlPaths == null) {
            HelidonCommonUtils.$$$reportNull$$$0(44);
        }
        if ((psiElement = resolveTo.getSourcePsi()) == null) {
            return true;
        }
        if (parentUrlPaths.isEmpty()) {
            return processor.process((Object)HelidonUrlTargetInfo.create(url, psiElement).ofType(requestMethods));
        }
        for (String parentUrl : parentUrlPaths) {
            if (processor.process((Object)HelidonUrlTargetInfo.create(url, psiElement).withParentUrl(parentUrl).ofType(requestMethods))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Collection<Pair<PsiMethod, HelidonRequestMethods>> getRulesHttpMethods(@NotNull Module module) {
        if (module == null) {
            HelidonCommonUtils.$$$reportNull$$$0(45);
        }
        Collection collection = (Collection)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency(HelidonCommonUtils.getHttpMethods(module, "io.helidon.webserver.Routing.Rules"), (Object)ProjectRootManager.getInstance((Project)module.getProject())));
        if (collection == null) {
            HelidonCommonUtils.$$$reportNull$$$0(46);
        }
        return collection;
    }

    @NotNull
    private static Collection<Pair<PsiMethod, HelidonRequestMethods>> getBuilderHttpMethods(@NotNull Module module) {
        if (module == null) {
            HelidonCommonUtils.$$$reportNull$$$0(47);
        }
        Collection collection = (Collection)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency(HelidonCommonUtils.getHttpMethods(module, "io.helidon.webserver.Routing.Builder"), (Object)ProjectRootManager.getInstance((Project)module.getProject())));
        if (collection == null) {
            HelidonCommonUtils.$$$reportNull$$$0(48);
        }
        return collection;
    }

    @NotNull
    private static Collection<Pair<PsiMethod, HelidonRequestMethods>> getHttpMethods(@NotNull Module module, @NotNull String containerClass) {
        PsiClass routingBuilderClass;
        if (module == null) {
            HelidonCommonUtils.$$$reportNull$$$0(49);
        }
        if (containerClass == null) {
            HelidonCommonUtils.$$$reportNull$$$0(50);
        }
        if ((routingBuilderClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(containerClass, module.getModuleRuntimeScope(true))) == null) {
            Set<Pair<PsiMethod, HelidonRequestMethods>> set = Collections.emptySet();
            if (set == null) {
                HelidonCommonUtils.$$$reportNull$$$0(51);
            }
            return set;
        }
        Collection collection = Arrays.stream(routingBuilderClass.getMethods()).filter(method -> HelidonReferenceContributor.Companion.getHttpMethodsPattern().accepts(method) || HelidonReferenceContributor.Companion.getAnyOfMethodPattern().accepts(method)).map(method -> Pair.create((Object)method, (Object)((Object)HelidonRequestMethods.getTypeByMethodName(method.getName())))).collect(Collectors.toSet());
        if (collection == null) {
            HelidonCommonUtils.$$$reportNull$$$0(52);
        }
        return collection;
    }

    @NotNull
    private static Set<PsiMethod> getBuilderRegisterMethod(@NotNull Module module) {
        if (module == null) {
            HelidonCommonUtils.$$$reportNull$$$0(53);
        }
        Set set = (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency(HelidonCommonUtils.getRegisterMethod(module), (Object)ProjectRootManager.getInstance((Project)module.getProject())));
        if (set == null) {
            HelidonCommonUtils.$$$reportNull$$$0(54);
        }
        return set;
    }

    @NotNull
    private static Set<PsiMethod> getRegisterMethod(@NotNull Module module) {
        String[] registerClasses;
        if (module == null) {
            HelidonCommonUtils.$$$reportNull$$$0(55);
        }
        HashSet<PsiMethod> methods = new HashSet<PsiMethod>();
        block0: for (String registerClass : registerClasses = new String[]{"io.helidon.webserver.Routing.Rules"}) {
            PsiClass routingBuilderClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(registerClass, module.getModuleRuntimeScope(true));
            if (routingBuilderClass == null) continue;
            for (PsiMethod psiMethod : routingBuilderClass.findMethodsByName("register", false)) {
                if (!HelidonReferenceContributor.Companion.getRegisterMethodPattern().accepts((Object)psiMethod)) continue;
                methods.add(psiMethod);
                continue block0;
            }
        }
        HashSet<PsiMethod> hashSet = methods;
        if (hashSet == null) {
            HelidonCommonUtils.$$$reportNull$$$0(56);
        }
        return hashSet;
    }

    public static <V> V withProgressIndicator(Computable<V> callable) {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null && progressIndicator.isRunning()) {
            return (V)callable.compute();
        }
        return (V)ProgressManager.getInstance().runProcess(callable, (ProgressIndicator)new EmptyProgressIndicator());
    }

    @NotNull
    private static GlobalSearchScope getHelidonServicesScope(@NotNull Module module) {
        PsiClass serviceClass;
        if (module == null) {
            HelidonCommonUtils.$$$reportNull$$$0(57);
        }
        if ((serviceClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("io.helidon.webserver.Service", module.getModuleRuntimeScope(true))) == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                HelidonCommonUtils.$$$reportNull$$$0(58);
            }
            return globalSearchScope;
        }
        Collection allServices = ClassInheritorsSearch.search((PsiClass)serviceClass, (SearchScope)module.getModuleWithDependenciesAndLibrariesScope(true), (boolean)true, (boolean)true, (boolean)true).findAll();
        Set files = allServices.stream().map(aClass -> aClass.getContainingFile().getVirtualFile()).filter(Objects::nonNull).collect(Collectors.toSet());
        GlobalSearchScope globalSearchScope = files.isEmpty() ? GlobalSearchScope.EMPTY_SCOPE : GlobalSearchScope.filesScope((Project)module.getProject(), files);
        if (globalSearchScope == null) {
            HelidonCommonUtils.$$$reportNull$$$0(59);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getRoutingClassReferencesScope(@NotNull Module module) {
        if (module == null) {
            HelidonCommonUtils.$$$reportNull$$$0(60);
        }
        GlobalSearchScope globalSearchScope = (GlobalSearchScope)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create((Object)HelidonCommonUtils.calculateRoutingClassReferencesScope(module), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())}));
        if (globalSearchScope == null) {
            HelidonCommonUtils.$$$reportNull$$$0(61);
        }
        return globalSearchScope;
    }

    private static GlobalSearchScope calculateRoutingClassReferencesScope(@NotNull Module module) {
        if (module == null) {
            HelidonCommonUtils.$$$reportNull$$$0(62);
        }
        long l = System.currentTimeMillis();
        PsiClass routingClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("io.helidon.webserver.Routing", module.getModuleRuntimeScope(true));
        if (routingClass == null) {
            return GlobalSearchScope.EMPTY_SCOPE;
        }
        Set virtualFiles = ReferencesSearch.search((PsiElement)routingClass, (SearchScope)module.getModuleWithDependenciesScope()).findAll().stream().map(reference -> reference.getElement().getContainingFile().getVirtualFile()).filter(Objects::nonNull).collect(Collectors.toSet());
        return virtualFiles.isEmpty() ? GlobalSearchScope.EMPTY_SCOPE : GlobalSearchScope.filesScope((Project)module.getProject(), virtualFiles);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 53: 
            case 55: 
            case 57: 
            case 60: 
            case 62: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 53: 
            case 55: 
            case 57: 
            case 60: 
            case 62: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/helidon/utils/HelidonCommonUtils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 6: 
            case 9: 
            case 20: 
            case 23: 
            case 45: 
            case 47: 
            case 49: 
            case 53: 
            case 55: 
            case 57: 
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registerMethod";
                break;
            }
            case 11: 
            case 19: 
            case 22: 
            case 25: 
            case 27: 
            case 29: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 12: 
            case 15: 
            case 30: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 18: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 32: 
            case 35: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 31: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestMethods";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveTo";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentUrlPaths";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentUrlPaths";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 53: 
            case 55: 
            case 57: 
            case 60: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/helidon/utils/HelidonCommonUtils";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateParentUrls";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "mapUrlsToServiceInvocations";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceRegisterInvocations";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getUCallExpressions";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodsInScopeMap";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "findExpressions";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getRulesHttpMethods";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilderHttpMethods";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getHttpMethods";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilderRegisterMethod";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisterMethod";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelidonServicesScope";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoutingClassReferencesScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calculateParentUrls";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mapUrlsToServiceInvocations";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getServiceRegisterInvocations";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getUCallExpressions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createMethodsInScopeMap";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRegisteredServiceType";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processBuilderRegisterMethodsWithProgress";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processBuilderRegisterMethods";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processRulesHttpMethods";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processBuilderHttpMethods";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findAndProcessTargets";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processExpressions";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "processJavaStringExpressions";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findExpressions";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "processTargets";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getRulesHttpMethods";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getBuilderHttpMethods";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getHttpMethods";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getBuilderRegisterMethod";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getRegisterMethod";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getHelidonServicesScope";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getRoutingClassReferencesScope";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "calculateRoutingClassReferencesScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 53: 
            case 55: 
            case 57: 
            case 60: 
            case 62: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

