/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.helidon.providers.view;

import com.intellij.helidon.providers.HelidonRequestMethods;
import com.intellij.helidon.utils.HelidonCommonUtils;
import com.intellij.helidon.utils.HelidonUrlTargetInfo;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.microservices.cache.SourceTestLibSearcher;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.uast.url.UastUrlAttributeUtils;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.utils.EndpointsViewUtils;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ValueKey;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uast.UastModificationTracker;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import icons.HelidonIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UastContextKt;

final class HelidonUrlFramework
implements EndpointsProvider<HelidonUrlTargetInfo, HelidonUrlTargetInfo> {
    private final FrameworkPresentation myPresentation = new FrameworkPresentation("Helidon", "Helidon", HelidonIcons.Helidon);
    private final SourceTestLibSearcher<HelidonUrlTargetInfo> groupsSearcher = new SourceTestLibSearcher("HELIDON_GROUPS", HelidonUrlFramework::findEndpointGroups);

    HelidonUrlFramework() {
    }

    @NotNull
    public EndpointType getEndpointType() {
        EndpointType endpointType = EndpointTypes.HTTP_SERVER_TYPE;
        if (endpointType == null) {
            HelidonUrlFramework.$$$reportNull$$$0(0);
        }
        return endpointType;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        FrameworkPresentation frameworkPresentation = this.myPresentation;
        if (frameworkPresentation == null) {
            HelidonUrlFramework.$$$reportNull$$$0(1);
        }
        return frameworkPresentation;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        if (project == null) {
            HelidonUrlFramework.$$$reportNull$$$0(2);
        }
        if (HelidonCommonUtils.hasHelidonLibrary(project)) {
            EndpointsProvider.Status status = EndpointsProvider.Status.HAS_ENDPOINTS;
            if (status == null) {
                HelidonUrlFramework.$$$reportNull$$$0(3);
            }
            return status;
        }
        EndpointsProvider.Status status = EndpointsProvider.Status.UNAVAILABLE;
        if (status == null) {
            HelidonUrlFramework.$$$reportNull$$$0(4);
        }
        return status;
    }

    @NotNull
    public Iterable<HelidonUrlTargetInfo> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        if (project == null) {
            HelidonUrlFramework.$$$reportNull$$$0(5);
        }
        if (filter == null) {
            HelidonUrlFramework.$$$reportNull$$$0(6);
        }
        if (!(filter instanceof ModuleEndpointsFilter)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                HelidonUrlFramework.$$$reportNull$$$0(7);
            }
            return list;
        }
        ModuleEndpointsFilter moduleFilter = (ModuleEndpointsFilter)filter;
        Module module = moduleFilter.getModule();
        if (!HelidonCommonUtils.hasHelidonLibrary(module)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                HelidonUrlFramework.$$$reportNull$$$0(8);
            }
            return list;
        }
        Iterable iterable = this.groupsSearcher.iterable(moduleFilter.getModule(), moduleFilter.getFromTests(), moduleFilter.getFromLibraries());
        if (iterable == null) {
            HelidonUrlFramework.$$$reportNull$$$0(9);
        }
        return iterable;
    }

    @NotNull
    private static Collection<HelidonUrlTargetInfo> findEndpointGroups(Module module, GlobalSearchScope filterScope) {
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
        GlobalSearchScope classReferencesScope = HelidonCommonUtils.getRoutingClassReferencesScope(module).intersectWith(filterScope);
        HelidonCommonUtils.processBuilderRegisterMethodsWithProgress((Processor<? super HelidonUrlTargetInfo>)collectProcessor, classReferencesScope, module);
        HelidonCommonUtils.processBuilderHttpMethods((Processor<? super HelidonUrlTargetInfo>)collectProcessor, (SearchScope)classReferencesScope, module);
        Collection collection = collectProcessor.getResults();
        if (collection == null) {
            HelidonUrlFramework.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    public Iterable<HelidonUrlTargetInfo> getEndpoints(@NotNull HelidonUrlTargetInfo registerEndpoint) {
        if (registerEndpoint == null) {
            HelidonUrlFramework.$$$reportNull$$$0(11);
        }
        Iterable iterable = (Iterable)HelidonCommonUtils.withProgressIndicator(() -> HelidonUrlFramework.getRegisteredEndpoints(registerEndpoint));
        if (iterable == null) {
            HelidonUrlFramework.$$$reportNull$$$0(12);
        }
        return iterable;
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        if (project == null) {
            HelidonUrlFramework.$$$reportNull$$$0(13);
        }
        UastModificationTracker uastModificationTracker = UastModificationTracker.getInstance((Project)project);
        if (uastModificationTracker == null) {
            HelidonUrlFramework.$$$reportNull$$$0(14);
        }
        return uastModificationTracker;
    }

    @NotNull
    private static Iterable<HelidonUrlTargetInfo> getRegisteredEndpoints(final @NotNull HelidonUrlTargetInfo groupEndpoint) {
        PsiType serviceType;
        PsiElement registerPoint;
        if (groupEndpoint == null) {
            HelidonUrlFramework.$$$reportNull$$$0(15);
        }
        if ((registerPoint = groupEndpoint.resolveToPsiElement()) == null) {
            List<HelidonUrlTargetInfo> list = Collections.emptyList();
            if (list == null) {
                HelidonUrlFramework.$$$reportNull$$$0(16);
            }
            return list;
        }
        if (groupEndpoint.getType() != HelidonRequestMethods.REGISTER) {
            List<HelidonUrlTargetInfo> list = Collections.singletonList(groupEndpoint);
            if (list == null) {
                HelidonUrlFramework.$$$reportNull$$$0(17);
            }
            return list;
        }
        UCallExpression invocationPoint = (UCallExpression)UastContextKt.getUastParentOfType((PsiElement)registerPoint, UCallExpression.class);
        if (invocationPoint != null && (serviceType = HelidonCommonUtils.getRegisteredServiceType(invocationPoint)) instanceof PsiClassType) {
            PsiClass resolve = ((PsiClassType)serviceType).resolve();
            if (resolve != null) {
                CommonProcessors.CollectProcessor<HelidonUrlTargetInfo> collectProcessor = new CommonProcessors.CollectProcessor<HelidonUrlTargetInfo>(){

                    protected boolean accept(HelidonUrlTargetInfo info) {
                        String parentUrl = info.getParentUrl();
                        return parentUrl != null && groupEndpoint.getPath().equals((Object)UrlPath.Companion.fromExactString(StringsKt.removePrefix((String)info.getParentUrl(), (CharSequence)"/")));
                    }
                };
                HelidonCommonUtils.processRulesHttpMethods((Processor<? super HelidonUrlTargetInfo>)collectProcessor, (SearchScope)new LocalSearchScope((PsiElement)resolve), ModuleUtilCore.findModuleForPsiElement((PsiElement)registerPoint));
                Collection collection = collectProcessor.getResults();
                if (collection == null) {
                    HelidonUrlFramework.$$$reportNull$$$0(18);
                }
                return collection;
            }
            List list = ContainerUtil.emptyList();
            if (list == null) {
                HelidonUrlFramework.$$$reportNull$$$0(19);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            HelidonUrlFramework.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    private static PresentationData getPresentation(HelidonUrlTargetInfo info, String url) {
        HelidonRequestMethods infoType = info.getType();
        String methodType = infoType == HelidonRequestMethods.REGISTER || infoType == HelidonRequestMethods.UNKNOWN ? "" : infoType.name();
        return new HttpMethodPresentation((String)(url.startsWith("/") ? url : "/" + url), methodType, HelidonUrlFramework.getEndpointContainerName(info), HelidonIcons.Helidon);
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull HelidonUrlTargetInfo group, @NotNull HelidonUrlTargetInfo endpoint) {
        if (group == null) {
            HelidonUrlFramework.$$$reportNull$$$0(21);
        }
        if (endpoint == null) {
            HelidonUrlFramework.$$$reportNull$$$0(22);
        }
        ItemPresentation itemPresentation = (ItemPresentation)HelidonCommonUtils.withProgressIndicator(() -> HelidonUrlFramework.getPresentation(endpoint, HelidonUrlFramework.joinSegments(endpoint.getPath())));
        if (itemPresentation == null) {
            HelidonUrlFramework.$$$reportNull$$$0(23);
        }
        return itemPresentation;
    }

    private static String joinSegments(@NotNull UrlPath path) {
        if (path == null) {
            HelidonUrlFramework.$$$reportNull$$$0(24);
        }
        return path.getPresentation(UrlPath.FULL_PATH_VARIABLE_PRESENTATION);
    }

    @NotNull
    private static String getEndpointContainerName(@NotNull HelidonUrlTargetInfo endpoint) {
        PsiMethod method;
        if (endpoint == null) {
            HelidonUrlFramework.$$$reportNull$$$0(25);
        }
        if ((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)endpoint.resolveToPsiElement(), PsiMethod.class)) == null) {
            return "";
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass != null && aClass.getName() != null) {
            String string = aClass.getName();
            if (string == null) {
                HelidonUrlFramework.$$$reportNull$$$0(26);
            }
            return string;
        }
        String string = method.getName();
        if (string == null) {
            HelidonUrlFramework.$$$reportNull$$$0(27);
        }
        return string;
    }

    @Nullable
    public Object getEndpointData(@NotNull HelidonUrlTargetInfo group, @NotNull HelidonUrlTargetInfo endpoint, @NotNull String dataId) {
        Object data;
        if (group == null) {
            HelidonUrlFramework.$$$reportNull$$$0(28);
        }
        if (endpoint == null) {
            HelidonUrlFramework.$$$reportNull$$$0(29);
        }
        if (dataId == null) {
            HelidonUrlFramework.$$$reportNull$$$0(30);
        }
        return (data = ValueKey.match((String)dataId).ifEq((ValueKey)EndpointsProvider.URL_TARGET_INFO).thenGet(() -> List.of(endpoint)).ifEq((ValueKey)EndpointsProvider.DOCUMENTATION_ELEMENT).thenGet(() -> UastUrlAttributeUtils.getUastDeclaringDocumentationElement((PsiElement)endpoint.resolveToPsiElement())).orNull()) != null ? data : EndpointsViewUtils.getCommonEndpointValue((PsiElement)endpoint.resolveToPsiElement(), (String)dataId);
    }

    public boolean isValidEndpoint(@NotNull HelidonUrlTargetInfo group, @NotNull HelidonUrlTargetInfo endpoint) {
        PsiElement psiElement;
        if (group == null) {
            HelidonUrlFramework.$$$reportNull$$$0(31);
        }
        if (endpoint == null) {
            HelidonUrlFramework.$$$reportNull$$$0(32);
        }
        return (psiElement = endpoint.resolveToPsiElement()) != null && psiElement.isValid();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 15: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 15: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/helidon/providers/view/HelidonUrlFramework";
                break;
            }
            case 2: 
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registerEndpoint";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupEndpoint";
                break;
            }
            case 21: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 22: 
            case 25: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endpoint";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpointType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 15: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/helidon/providers/view/HelidonUrlFramework";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpointGroups";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findEndpointGroups";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpoints";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredEndpoints";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpointPresentation";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpointContainerName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointGroups";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getEndpoints";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getModificationTracker";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRegisteredEndpoints";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointPresentation";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "joinSegments";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointContainerName";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointData";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isValidEndpoint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 15: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

