/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.helidon.providers;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;

public enum HelidonRequestMethods {
    REGISTER("register"),
    GET("get"),
    HEAD("head"),
    POST("post"),
    PUT("put"),
    PATCH("patch"),
    DELETE("delete"),
    OPTIONS("options"),
    TRACE("trace"),
    ANY_OF("anyOf"),
    UNKNOWN("???");

    private static final Function<HelidonRequestMethods, String> NAMING_FUNCTION;
    private final String myMethodName;

    private HelidonRequestMethods(String methodName) {
        this.myMethodName = methodName;
    }

    public static String getDisplay(HelidonRequestMethods ... methods) {
        return "[" + StringUtil.join((Object[])methods, NAMING_FUNCTION, (String)"|") + "]";
    }

    public static HelidonRequestMethods getTypeByMethodName(String method) {
        for (HelidonRequestMethods value : HelidonRequestMethods.values()) {
            if (!value.myMethodName.equals(method)) continue;
            return value;
        }
        return UNKNOWN;
    }

    static {
        NAMING_FUNCTION = Enum::name;
    }
}

