/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.helidon.providers;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.helidon.utils.HelidonBundle;
import com.intellij.helidon.utils.HelidonCommonUtils;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiType;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uast.UastSmartPointer;
import com.intellij.util.containers.ContainerUtil;
import icons.HelidonIcons;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;

public class HelidonClassAnnotator
extends RelatedItemLineMarkerProvider {
    private static final DefaultPsiElementCellRenderer methodCallRenderer = new DefaultPsiElementCellRenderer(){

        protected Icon getIcon(PsiElement element) {
            return HelidonIcons.HelidonGutter;
        }

        public String getContainerText(PsiElement element, String name) {
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            if (psiClass != null) {
                return SymbolPresentationUtil.getSymbolPresentableText((PsiElement)psiClass);
            }
            return SymbolPresentationUtil.getSymbolContainerText((PsiElement)element);
        }
    };

    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            HelidonClassAnnotator.$$$reportNull$$$0(0);
        }
        if (result == null) {
            HelidonClassAnnotator.$$$reportNull$$$0(1);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (HelidonCommonUtils.hasHelidonLibrary(module)) {
            for (PsiElement psiElement2 : elements) {
                HelidonClassAnnotator.collectNavigationMarkers(psiElement2, module, result);
            }
        }
    }

    protected static void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Module module, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        Set<UExpression> calls;
        Set targets;
        PsiElement parent;
        if (psiElement == null) {
            HelidonClassAnnotator.$$$reportNull$$$0(2);
        }
        if (module == null) {
            HelidonClassAnnotator.$$$reportNull$$$0(3);
        }
        if (result == null) {
            HelidonClassAnnotator.$$$reportNull$$$0(4);
        }
        if (psiElement instanceof PsiIdentifier && (parent = psiElement.getParent()) instanceof PsiClass && InheritanceUtil.isInheritor((PsiClass)((PsiClass)parent), (String)"io.helidon.webserver.Service") && (targets = (calls = HelidonClassAnnotator.getServiceRegisterExpressions(module, JavaPsiFacade.getInstance((Project)module.getProject()).getElementFactory().createType((PsiClass)parent))).stream().map(expression -> expression.getSourcePsi()).filter(Objects::nonNull).collect(Collectors.toSet())).size() > 0) {
            NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)HelidonIcons.HelidonGutter).setTargets(targets).setPopupTitle(HelidonBundle.message("gutter.choose.service.registration", new Object[0])).setTooltipText(HelidonBundle.message("gutter.navigate.to.service.registration", new Object[0])).setCellRenderer((PsiElementListCellRenderer)methodCallRenderer);
            result.add(builder.createLineMarkerInfo(psiElement));
        }
    }

    @NotNull
    private static Set<UExpression> getServiceRegisterExpressions(@NotNull Module module, @NotNull PsiClassType serviceType) {
        if (module == null) {
            HelidonClassAnnotator.$$$reportNull$$$0(5);
        }
        if (serviceType == null) {
            HelidonClassAnnotator.$$$reportNull$$$0(6);
        }
        HashSet<UExpression> expressions = new HashSet<UExpression>();
        for (UCallExpression call : HelidonClassAnnotator.getServiceRegistrationCalls(module, (PsiType)serviceType)) {
            PsiType expressionType;
            List arguments = call.getValueArguments();
            if (arguments.size() != 2 || (expressionType = ((UExpression)arguments.get(1)).getExpressionType()) == null || !serviceType.isAssignableFrom(expressionType)) continue;
            ContainerUtil.addIfNotNull(expressions, (Object)((UExpression)arguments.get(0)));
        }
        HashSet<UExpression> hashSet = expressions;
        if (hashSet == null) {
            HelidonClassAnnotator.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    @NotNull
    private static Set<UCallExpression> getServiceRegistrationCalls(@NotNull Module module, @NotNull PsiType type) {
        if (module == null) {
            HelidonClassAnnotator.$$$reportNull$$$0(8);
        }
        if (type == null) {
            HelidonClassAnnotator.$$$reportNull$$$0(9);
        }
        HashSet<UCallExpression> calls = new HashSet<UCallExpression>();
        for (Map.Entry<UastSmartPointer<UCallExpression>, PsiType> entry : HelidonCommonUtils.getServiceRegisterInvocations(module).entrySet()) {
            if (!entry.getValue().isAssignableFrom(type)) continue;
            ContainerUtil.addIfNotNull(calls, (Object)((UCallExpression)entry.getKey().getElement()));
        }
        HashSet<UCallExpression> hashSet = calls;
        if (hashSet == null) {
            HelidonClassAnnotator.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    @Nullable
    @NonNls
    public String getName() {
        return "Helidon Services";
    }

    public String getId() {
        return "HelidonClassAnnotator";
    }

    @Nullable
    public Icon getIcon() {
        return HelidonIcons.Helidon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceType";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/helidon/providers/HelidonClassAnnotator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/helidon/providers/HelidonClassAnnotator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceRegisterExpressions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceRegistrationCalls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectNavigationMarkers";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getServiceRegisterExpressions";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getServiceRegistrationCalls";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

