/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.swagger.SwaggerUtilsKt;
import com.intellij.swagger.model.api.SwDefinition;
import com.intellij.swagger.model.api.SwHttpOperation;
import com.intellij.swagger.model.api.SwModelElement;
import com.intellij.swagger.model.api.SwUrl;
import com.intellij.swagger.model.specification.SwSpecificationFile;
import com.intellij.swagger.model.specification.SwaggerFileHelper;
import com.intellij.swagger.traverser.SwTreeUtil;
import com.intellij.swagger.ui.SwaggerUIEditorWithPreview;
import com.intellij.swagger.ui.SwaggerUIScrollUtils;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefJSQuery;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.cef.browser.CefBrowser;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001a\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$H\u0002J\u001a\u0010%\u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$H\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010$2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\u001d\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b/J\u001a\u00100\u001a\u0002012\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u0004H\u0002J\u0018\u00104\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u001f2\u0006\u00105\u001a\u000206H\u0002J\u0018\u00107\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u001f2\u0006\u00108\u001a\u000209H\u0002J.\u0010:\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u001f2\u0006\u0010;\u001a\u00020(2\u0006\u0010<\u001a\u00020=2\u0006\u0010)\u001a\u00020*R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0014\u0010\u000eR\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0017\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0010\u001a\u0004\b\u0018\u0010\u000eR\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/intellij/swagger/ui/SwaggerUIScrollUtils;", "", "()V", "callbackArgumentName", "", "callbackInjectionMarker", "elementProcessingResource", "endpointMethodGroupIndex", "", "endpointPattern", "Lkotlin/text/Regex;", "endpointUrlGroupIndex", "modelElementsProcessingScript", "getModelElementsProcessingScript", "()Ljava/lang/String;", "modelElementsProcessingScript$delegate", "Lkotlin/Lazy;", "modelNameGroupIndex", "modelPattern", "previewToSourceNavigationScript", "getPreviewToSourceNavigationScript", "previewToSourceNavigationScript$delegate", "previewToSourceNavigationScriptResource", "sourceToPreviewNavigationScript", "getSourceToPreviewNavigationScript", "sourceToPreviewNavigationScript$delegate", "sourceToPreviewNavigationScriptResource", "executeScriptInBrowser", "", "script", "browser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "findEndpointPsiElement", "Lcom/intellij/psi/PsiElement;", "objectCoordinates", "specification", "Lcom/intellij/psi/PsiFile;", "findModelPsiElement", "findPsiWithLogging", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "installCustomMouseClickHandler", "jsQuery", "Lcom/intellij/ui/jcef/JBCefJSQuery;", "jbCefBrowser", "installCustomMouseClickHandler$intellij_swagger", "isAutoScrollEnabled", "", "readScriptFromResources", "scriptPath", "scrollToEndpoint", "endpoint", "Lcom/intellij/swagger/model/api/SwHttpOperation;", "scrollToModel", "definition", "Lcom/intellij/swagger/model/api/SwDefinition;", "setupPreviewToSourceScroll", "editedFile", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "intellij.swagger"})
public final class SwaggerUIScrollUtils {
    private static final Regex endpointPattern;
    private static final int endpointMethodGroupIndex = 1;
    private static final int endpointUrlGroupIndex = 2;
    private static final Regex modelPattern;
    private static final int modelNameGroupIndex = 1;
    private static final String elementProcessingResource = "js/ModelElementsProcessing.js";
    private static final String previewToSourceNavigationScriptResource = "js/PreviewToSourceNavigation.js";
    private static final String sourceToPreviewNavigationScriptResource = "js/SourceToPreviewNavigation.js";
    private static final String callbackInjectionMarker = "/*IntelliJ Swagger UI*/";
    private static final String callbackArgumentName = "objectCoordinates";
    private static final Lazy modelElementsProcessingScript$delegate;
    private static final Lazy previewToSourceNavigationScript$delegate;
    private static final Lazy sourceToPreviewNavigationScript$delegate;
    public static final SwaggerUIScrollUtils INSTANCE;

    private final String getModelElementsProcessingScript() {
        Lazy lazy = modelElementsProcessingScript$delegate;
        SwaggerUIScrollUtils swaggerUIScrollUtils = this;
        Object var3_3 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    private final String getPreviewToSourceNavigationScript() {
        Lazy lazy = previewToSourceNavigationScript$delegate;
        SwaggerUIScrollUtils swaggerUIScrollUtils = this;
        Object var3_3 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    private final String getSourceToPreviewNavigationScript() {
        Lazy lazy = sourceToPreviewNavigationScript$delegate;
        SwaggerUIScrollUtils swaggerUIScrollUtils = this;
        Object var3_3 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    public final void setupPreviewToSourceScroll(@NotNull JBCefJSQuery jsQuery, @NotNull JBCefBrowser jbCefBrowser, @NotNull VirtualFile editedFile, @NotNull TextEditor editor, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)jsQuery, (String)"jsQuery");
        Intrinsics.checkNotNullParameter((Object)jbCefBrowser, (String)"jbCefBrowser");
        Intrinsics.checkNotNullParameter((Object)editedFile, (String)"editedFile");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        jsQuery.addHandler((Function)new Function<String, JBCefJSQuery.Response>(editedFile, project, editor){
            final /* synthetic */ VirtualFile $editedFile;
            final /* synthetic */ Project $project;
            final /* synthetic */ TextEditor $editor;

            public final JBCefJSQuery.Response apply(String objectCoordinates) {
                PsiFile psiFile = SwaggerUIScrollUtils.access$findPsiWithLogging(SwaggerUIScrollUtils.INSTANCE, this.$editedFile, this.$project);
                if (psiFile == null) {
                    return null;
                }
                PsiFile specification = psiFile;
                String string = objectCoordinates;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"objectCoordinates");
                PsiElement psiElement = SwaggerUIScrollUtils.access$findEndpointPsiElement(SwaggerUIScrollUtils.INSTANCE, string, specification);
                if (psiElement == null) {
                    psiElement = SwaggerUIScrollUtils.access$findModelPsiElement(SwaggerUIScrollUtils.INSTANCE, objectCoordinates, specification);
                }
                if (psiElement == null) {
                    return null;
                }
                PsiElement psiElement2 = psiElement;
                ApplicationManager.getApplication().invokeLater(new Runnable(this, specification, psiElement2){
                    final /* synthetic */ setupPreviewToSourceScroll.1 this$0;
                    final /* synthetic */ PsiFile $specification;
                    final /* synthetic */ PsiElement $psiElement;

                    public final void run() {
                        VirtualFile virtualFile2 = this.$specification.getVirtualFile();
                        Project project = this.$specification.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"specification.project");
                        if (SwaggerUIScrollUtils.access$isAutoScrollEnabled(SwaggerUIScrollUtils.INSTANCE, virtualFile2, project)) {
                            Editor editor = this.this$0.$editor.getEditor();
                            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"editor.editor");
                            editor.getCaretModel().moveToOffset(UtilsKt.getStartOffset((PsiElement)this.$psiElement));
                            Editor editor2 = this.this$0.$editor.getEditor();
                            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"editor.editor");
                            editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$specification = psiFile;
                        this.$psiElement = psiElement;
                    }
                });
                return null;
            }
            {
                this.$editedFile = virtualFile2;
                this.$project = project;
                this.$editor = textEditor;
            }
        });
        Editor editor2 = editor.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"editor.editor");
        editor2.getCaretModel().addCaretListener(new CaretListener(editedFile, project, editor, jbCefBrowser){
            final /* synthetic */ VirtualFile $editedFile;
            final /* synthetic */ Project $project;
            final /* synthetic */ TextEditor $editor;
            final /* synthetic */ JBCefBrowser $jbCefBrowser;

            public void caretPositionChanged(@NotNull CaretEvent event) {
                block5: {
                    SwModelElement swModelElement;
                    SwModelElement parentModelElement;
                    block6: {
                        block4: {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            if (!SwaggerUIScrollUtils.access$isAutoScrollEnabled(SwaggerUIScrollUtils.INSTANCE, this.$editedFile, this.$project)) {
                                return;
                            }
                            Editor editor = this.$editor.getEditor();
                            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"editor.editor");
                            CaretModel caretModel = editor.getCaretModel();
                            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.editor.caretModel");
                            if (Intrinsics.areEqual((Object)caretModel.getPrimaryCaret(), (Object)event.getCaret()) ^ true) {
                                return;
                            }
                            Caret caret = event.getCaret();
                            int offset = caret != null ? caret.getOffset() : this.$editor.getEditor().logicalPositionToOffset(new LogicalPosition(event.getNewPosition().line, event.getNewPosition().column));
                            PsiFile psiFile = SwaggerUIScrollUtils.access$findPsiWithLogging(SwaggerUIScrollUtils.INSTANCE, this.$editedFile, this.$project);
                            if (psiFile == null || (psiFile = psiFile.findElementAt(offset)) == null) {
                                return;
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"findPsiWithLogging(edite\u2026ementAt(offset) ?: return");
                            PsiFile psiElement = psiFile;
                            SwModelElement swModelElement2 = (SwModelElement)SequencesKt.lastOrNull(SwTreeUtil.INSTANCE.getParentsOfTypes((PsiElement)psiElement, SwHttpOperation.class, SwDefinition.class, SwUrl.class));
                            if (swModelElement2 == null) {
                                return;
                            }
                            swModelElement = parentModelElement = swModelElement2;
                            if (!(swModelElement instanceof SwHttpOperation)) break block4;
                            SwaggerUIScrollUtils.access$scrollToEndpoint(SwaggerUIScrollUtils.INSTANCE, this.$jbCefBrowser, (SwHttpOperation)parentModelElement);
                            break block5;
                        }
                        if (!(swModelElement instanceof SwUrl)) break block6;
                        SwHttpOperation swHttpOperation = (SwHttpOperation)CollectionsKt.firstOrNull(((SwUrl)parentModelElement).getSupportedOperations());
                        if (swHttpOperation == null) break block5;
                        SwHttpOperation swHttpOperation2 = swHttpOperation;
                        boolean bl = false;
                        boolean bl2 = false;
                        SwHttpOperation it = swHttpOperation2;
                        boolean bl3 = false;
                        SwaggerUIScrollUtils.access$scrollToEndpoint(SwaggerUIScrollUtils.INSTANCE, this.$jbCefBrowser, it);
                        break block5;
                    }
                    if (!(swModelElement instanceof SwDefinition)) break block5;
                    SwaggerUIScrollUtils.access$scrollToModel(SwaggerUIScrollUtils.INSTANCE, this.$jbCefBrowser, (SwDefinition)parentModelElement);
                }
            }
            {
                this.$editedFile = $captured_local_variable$0;
                this.$project = $captured_local_variable$1;
                this.$editor = $captured_local_variable$2;
                this.$jbCefBrowser = $captured_local_variable$3;
            }
        }, (Disposable)jbCefBrowser);
    }

    private final PsiFile findPsiWithLogging(VirtualFile virtualFile2, Project project) {
        boolean $i$f$runReadAction = false;
        PsiFile psiFile = (PsiFile)ApplicationManager.getApplication().runReadAction(new Computable<T>(project, virtualFile2){
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ VirtualFile $virtualFile$inlined;
            {
                this.$project$inlined = project;
                this.$virtualFile$inlined = virtualFile2;
            }

            public final T compute() {
                boolean bl = false;
                return (T)PsiManager.getInstance((Project)this.$project$inlined).findFile(this.$virtualFile$inlined);
            }
        });
        if (psiFile == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SwaggerUIScrollUtils.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.info("Unable to find PsiFile for VirtualFile opened in SwaggerUI editor. Synced scroll is disabled.");
        }
        return psiFile;
    }

    private final boolean isAutoScrollEnabled(VirtualFile virtualFile2, Project project) {
        SwaggerUIEditorWithPreview swaggerUiEditor;
        FileEditor fileEditor;
        VirtualFile virtualFile3 = virtualFile2;
        if (virtualFile3 != null) {
            VirtualFile virtualFile4 = virtualFile3;
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile p1 = virtualFile4;
            boolean bl3 = false;
            fileEditor = fileEditorManager.getSelectedEditor(p1);
        } else {
            fileEditor = null;
        }
        FileEditor $this$castSafelyTo$iv = fileEditor;
        boolean $i$f$castSafelyTo = false;
        FileEditor fileEditor2 = $this$castSafelyTo$iv;
        if (!(fileEditor2 instanceof SwaggerUIEditorWithPreview)) {
            fileEditor2 = null;
        }
        SwaggerUIEditorWithPreview swaggerUIEditorWithPreview = swaggerUiEditor = (SwaggerUIEditorWithPreview)fileEditor2;
        return swaggerUIEditorWithPreview != null ? swaggerUIEditorWithPreview.getMyAutoScrollEnabled() : false;
    }

    private final void scrollToEndpoint(JBCefBrowser jbCefBrowser, SwHttpOperation endpoint) {
        String endpointDivClass = endpoint.isDeprecated().getValue() != false ? "opblock-summary-path__deprecated" : "opblock-summary-path";
        this.executeScriptInBrowser("scrollToElement(\"" + endpointDivClass + "\", \"Endpoint#" + endpoint.getHttpMethod().getValue() + '#' + endpoint.getUrl() + "\")", jbCefBrowser);
    }

    private final void scrollToModel(JBCefBrowser jbCefBrowser, SwDefinition definition) {
        this.executeScriptInBrowser(StringsKt.trimIndent((String)("\n      scrollToElement(\"model model-title\", \"Model#" + definition.getName().getValue() + "\") || \n      scrollToElement(\"model-title__text\", \"Model#" + definition.getName().getValue() + "\")\n    ")), jbCefBrowser);
    }

    private final void executeScriptInBrowser(@Language(value="JavaScript") String script, JBCefBrowser browser) {
        CefBrowser cefBrowser = browser.getCefBrowser();
        CefBrowser cefBrowser2 = browser.getCefBrowser();
        Intrinsics.checkNotNullExpressionValue((Object)cefBrowser2, (String)"browser.cefBrowser");
        cefBrowser.executeJavaScript(script, cefBrowser2.getURL(), 0);
    }

    private final String readScriptFromResources(String scriptPath) {
        Object object;
        block3: {
            block2: {
                object = SwaggerUtilsKt.getBundledResource(scriptPath);
                if (object == null) break block2;
                VirtualFile virtualFile2 = object;
                boolean bl = false;
                boolean bl2 = false;
                VirtualFile it = virtualFile2;
                boolean bl3 = false;
                object = ((Object)LoadTextUtil.loadText((VirtualFile)it)).toString();
                if (object != null) break block3;
            }
            object = "";
        }
        return object;
    }

    private final PsiElement findEndpointPsiElement(String objectCoordinates, PsiFile specification) {
        Object object;
        MatchResult matchResult;
        block7: {
            block6: {
                matchResult = endpointPattern.matchEntire((CharSequence)objectCoordinates);
                if (matchResult == null || matchResult.getGroups().size() < 2) {
                    return null;
                }
                object = matchResult.getGroups().get(1);
                if (object == null || (object = object.getValue()) == null) break block6;
                Object object2 = object;
                boolean bl = false;
                Object object3 = object2;
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string = ((String)object3).toUpperCase();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toUpperCase()");
                object = string;
                if (string != null) break block7;
            }
            return null;
        }
        Object method = object;
        Object object4 = matchResult.getGroups().get(2);
        if (object4 == null || (object4 = object4.getValue()) == null) {
            return null;
        }
        Object url2 = object4;
        boolean $i$f$runReadAction = false;
        return (PsiElement)ApplicationManager.getApplication().runReadAction(new Computable<T>(specification, (String)url2, (String)method){
            final /* synthetic */ PsiFile $specification$inlined;
            final /* synthetic */ String $url$inlined;
            final /* synthetic */ String $method$inlined;
            {
                this.$specification$inlined = psiFile;
                this.$url$inlined = string;
                this.$method$inlined = string2;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final T compute() {
                PsiElement psiElement;
                boolean bl = false;
                VirtualFile virtualFile2 = this.$specification$inlined.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"specification.virtualFile");
                Project project = this.$specification$inlined.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"specification.project");
                Object object = SwaggerFileHelper.createSpecificationFile$default(SwaggerFileHelper.INSTANCE, this.$specification$inlined, virtualFile2, project, true, false, 16, null);
                if (object != null && (object = ((SwSpecificationFile)object).getUrls()) != null) {
                    Object v3;
                    SwModelElement it;
                    boolean $i$f$firstOrNull;
                    Iterable $this$firstOrNull$iv;
                    block5: {
                        $this$firstOrNull$iv = (Iterable)object;
                        $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            it = (SwUrl)element$iv;
                            boolean bl2 = false;
                            if (!StringsKt.endsWith$default((String)((SwUrl)it).getUrlString(), (String)this.$url$inlined, (boolean)false, (int)2, null)) continue;
                            v3 = element$iv;
                            break block5;
                        }
                        v3 = null;
                    }
                    if ((object = (SwUrl)v3) != null && (object = ((SwUrl)object).getSupportedOperations()) != null) {
                        Object v4;
                        block6: {
                            $this$firstOrNull$iv = (Iterable)object;
                            $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                it = (SwHttpOperation)element$iv;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual((Object)it.getHttpMethod().getValue(), (Object)this.$method$inlined)) continue;
                                v4 = element$iv;
                                break block6;
                            }
                            v4 = null;
                        }
                        if ((object = (SwHttpOperation)v4) != null) {
                            psiElement = object.getSourcePsi();
                            return (T)psiElement;
                        }
                    }
                }
                psiElement = null;
                return (T)psiElement;
            }
        });
    }

    private final PsiElement findModelPsiElement(String objectCoordinates, PsiFile specification) {
        MatchResult matchResult = modelPattern.matchEntire((CharSequence)objectCoordinates);
        if (matchResult == null || matchResult.getGroups().size() < 1) {
            return null;
        }
        Object object = matchResult.getGroups().get(1);
        if (object == null || (object = object.getValue()) == null) {
            return null;
        }
        Object modelName = object;
        boolean $i$f$runReadAction = false;
        return (PsiElement)ApplicationManager.getApplication().runReadAction(new Computable<T>(specification, (String)modelName){
            final /* synthetic */ PsiFile $specification$inlined;
            final /* synthetic */ String $modelName$inlined;
            {
                this.$specification$inlined = psiFile;
                this.$modelName$inlined = string;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final T compute() {
                PsiElement psiElement;
                boolean bl = false;
                VirtualFile virtualFile2 = this.$specification$inlined.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"specification.virtualFile");
                Project project = this.$specification$inlined.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"specification.project");
                Object object = SwaggerFileHelper.createSpecificationFile$default(SwaggerFileHelper.INSTANCE, this.$specification$inlined, virtualFile2, project, true, false, 16, null);
                if (object != null && (object = ((SwSpecificationFile)object).getAllLocalObjectDefinitions()) != null) {
                    Object v3;
                    block3: {
                        Iterable $this$firstOrNull$iv = (Iterable)object;
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            SwDefinition it = (SwDefinition)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getName().getValue(), (Object)this.$modelName$inlined)) continue;
                            v3 = element$iv;
                            break block3;
                        }
                        v3 = null;
                    }
                    if ((object = (SwDefinition)v3) != null) {
                        psiElement = object.getSourcePsi();
                        return (T)psiElement;
                    }
                }
                psiElement = null;
                return (T)psiElement;
            }
        });
    }

    public final void installCustomMouseClickHandler$intellij_swagger(@NotNull JBCefJSQuery jsQuery, @NotNull JBCefBrowser jbCefBrowser) {
        Intrinsics.checkNotNullParameter((Object)jsQuery, (String)"jsQuery");
        Intrinsics.checkNotNullParameter((Object)jbCefBrowser, (String)"jbCefBrowser");
        Object[] objectArray = new String[3];
        objectArray[0] = this.getModelElementsProcessingScript();
        String string = this.getPreviewToSourceNavigationScript();
        String string2 = jsQuery.inject(callbackArgumentName);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jsQuery.inject(callbackArgumentName)");
        objectArray[1] = StringsKt.replace$default((String)string, (String)callbackInjectionMarker, (String)string2, (boolean)false, (int)4, null);
        String string3 = this.getSourceToPreviewNavigationScript();
        String string4 = jsQuery.inject(callbackArgumentName);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"jsQuery.inject(callbackArgumentName)");
        objectArray[2] = StringsKt.replace$default((String)string3, (String)callbackInjectionMarker, (String)string4, (boolean)false, (int)4, null);
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            INSTANCE.executeScriptInBrowser(it, jbCefBrowser);
        }
    }

    private SwaggerUIScrollUtils() {
    }

    static {
        SwaggerUIScrollUtils swaggerUIScrollUtils;
        INSTANCE = swaggerUIScrollUtils = new SwaggerUIScrollUtils();
        String string = "Endpoint#(.*)#(.*)";
        boolean bl = false;
        endpointPattern = new Regex(string);
        string = "Model#(.*)";
        bl = false;
        modelPattern = new Regex(string);
        modelElementsProcessingScript$delegate = LazyKt.lazy((Function0)modelElementsProcessingScript.2.INSTANCE);
        previewToSourceNavigationScript$delegate = LazyKt.lazy((Function0)previewToSourceNavigationScript.2.INSTANCE);
        sourceToPreviewNavigationScript$delegate = LazyKt.lazy((Function0)sourceToPreviewNavigationScript.2.INSTANCE);
    }

    public static final /* synthetic */ PsiFile access$findPsiWithLogging(SwaggerUIScrollUtils $this, VirtualFile virtualFile2, Project project) {
        return $this.findPsiWithLogging(virtualFile2, project);
    }

    public static final /* synthetic */ PsiElement access$findEndpointPsiElement(SwaggerUIScrollUtils $this, String objectCoordinates, PsiFile specification) {
        return $this.findEndpointPsiElement(objectCoordinates, specification);
    }

    public static final /* synthetic */ PsiElement access$findModelPsiElement(SwaggerUIScrollUtils $this, String objectCoordinates, PsiFile specification) {
        return $this.findModelPsiElement(objectCoordinates, specification);
    }

    public static final /* synthetic */ boolean access$isAutoScrollEnabled(SwaggerUIScrollUtils $this, VirtualFile virtualFile2, Project project) {
        return $this.isAutoScrollEnabled(virtualFile2, project);
    }

    public static final /* synthetic */ void access$scrollToEndpoint(SwaggerUIScrollUtils $this, JBCefBrowser jbCefBrowser, SwHttpOperation endpoint) {
        $this.scrollToEndpoint(jbCefBrowser, endpoint);
    }

    public static final /* synthetic */ void access$scrollToModel(SwaggerUIScrollUtils $this, JBCefBrowser jbCefBrowser, SwDefinition definition) {
        $this.scrollToModel(jbCefBrowser, definition);
    }

    public static final /* synthetic */ String access$readScriptFromResources(SwaggerUIScrollUtils $this, String scriptPath) {
        return $this.readScriptFromResources(scriptPath);
    }
}

