/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.ui;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.swagger.SwDownloadableFileType;
import com.intellij.swagger.SwaggerUtilsKt;
import com.intellij.swagger.npm.SwNpmDownloadManager;
import com.intellij.swagger.ui.SwaggerUIPage;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.StartupUiUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013J\n\u0010\u0018\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/swagger/ui/SwaggerUIManager;", "", "()V", "BUNDLED_SWAGGER_UI", "", "SWAGGER_CALL_GROUP_INDEX", "", "SWAGGER_CALL_REGION_REGEX", "Lkotlin/text/Regex;", "addCssStyles", "htmlContent", "addJsonSpecificationPathParameter", "indexHtml", "Lcom/intellij/openapi/vfs/VirtualFile;", "jsonToInline", "convertYamlToJson", "specificationText", "downloadLatestSourcesOrUseBundled", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "prepareUIWebPageSources", "Lcom/intellij/swagger/ui/SwaggerUIPage;", "specification", "Lcom/intellij/psi/PsiFile;", "unpackBundledResourcesIfNeeded", "writeFileToTheDisk", "", "content", "file", "Ljava/io/File;", "intellij.swagger"})
public final class SwaggerUIManager {
    private static final String BUNDLED_SWAGGER_UI = "META-INF/resources/webjars/swagger-ui";
    private static final int SWAGGER_CALL_GROUP_INDEX = 1;
    private static final Regex SWAGGER_CALL_REGION_REGEX;
    public static final SwaggerUIManager INSTANCE;

    @Nullable
    public final SwaggerUIPage prepareUIWebPageSources(@NotNull PsiFile specification, @NotNull ProgressIndicator indicator) {
        Object object;
        VirtualFile indexHtml;
        VirtualFile virtualFile2;
        boolean bl;
        String specificationTextJson;
        String string;
        Intrinsics.checkNotNullParameter((Object)specification, (String)"specification");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.checkCanceled();
        boolean $i$f$runReadAction = false;
        String text = (String)ApplicationManager.getApplication().runReadAction(new Computable<T>(specification){
            final /* synthetic */ PsiFile $specification$inlined;
            {
                this.$specification$inlined = psiFile;
            }

            public final T compute() {
                boolean bl = false;
                return (T)this.$specification$inlined.getText();
            }
        });
        if (specification.getFileType() instanceof YAMLFileType) {
            String string2 = text;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text");
            string = this.convertYamlToJson(string2);
        } else {
            string = specificationTextJson = text;
        }
        if (specificationTextJson == null) {
            Logger.getInstance(SwaggerUIManager.class).warn("Unable to convert specification to json format");
            return null;
        }
        indicator.checkCanceled();
        VirtualFile virtualFile3 = this.downloadLatestSourcesOrUseBundled(indicator);
        if (virtualFile3 != null && (virtualFile3 = virtualFile3.findChild("index.html")) != null) {
            VirtualFile virtualFile4 = virtualFile3;
            boolean bl2 = false;
            boolean bl3 = false;
            VirtualFile it = virtualFile4;
            bl = false;
            it.refresh(false, false);
            virtualFile2 = virtualFile4;
        } else {
            virtualFile2 = indexHtml = null;
        }
        if (indexHtml == null) {
            Logger.getInstance(SwaggerUIManager.class).warn("Unable to find index.html page");
            return null;
        }
        indicator.checkCanceled();
        String specificationSwaggerUi = this.addJsonSpecificationPathParameter(indexHtml, specificationTextJson);
        if (specificationSwaggerUi == null) {
            Logger.getInstance(SwaggerUIManager.class).warn("Unable to inline specification text into html page");
            return null;
        }
        String styledHtml = this.addCssStyles(specificationSwaggerUi);
        if (SystemInfo.isWindows) {
            Object object2;
            try {
                object2 = indexHtml.getParent().toNioPath().resolve(styledHtml.hashCode() + "_index.html");
                bl = false;
                boolean bl4 = false;
                Path path = object2;
                boolean bl5 = false;
                Path path2 = path;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                if (!PathKt.exists((Path)path2)) {
                    Files.createFile(path, new FileAttribute[0]);
                }
                File file = path.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"path.toFile()");
                INSTANCE.writeFileToTheDisk(styledHtml, file);
                VirtualFile virtualFile5 = VfsUtil.findFile((Path)path, (boolean)true);
                object2 = virtualFile5 != null ? virtualFile5.getUrl() : null;
            }
            catch (IOException ex) {
                Logger.getInstance(SwaggerUIManager.class).info("Unable to write effective main html page of Swagger UI", (Throwable)ex);
                return null;
            }
            object = object2;
        } else {
            object = indexHtml.getUrl();
        }
        String effectiveIndexHtmlUrl = object;
        Logger.getInstance(SwaggerUIManager.class).info("Swagger UI Path is: " + effectiveIndexHtmlUrl);
        return effectiveIndexHtmlUrl != null ? new SwaggerUIPage(styledHtml, effectiveIndexHtmlUrl) : null;
    }

    private final void writeFileToTheDisk(String content, File file) {
        FileUtil.writeToFile((File)file, (String)content, (boolean)false);
    }

    private final VirtualFile downloadLatestSourcesOrUseBundled(ProgressIndicator indicator) {
        VirtualFile virtualFile2 = SwNpmDownloadManager.INSTANCE.downloadOrGetCachedLibrary("swagger-ui-dist", indicator);
        if (virtualFile2 == null || (virtualFile2 = virtualFile2.findChild("package")) == null) {
            virtualFile2 = this.unpackBundledResourcesIfNeeded();
        }
        return virtualFile2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final VirtualFile unpackBundledResourcesIfNeeded() {
        VirtualFile[] virtualFileArray;
        try {
            boolean bl;
            Path npmLibrariesPath = SwNpmDownloadManager.INSTANCE.getLibraryPath(SwDownloadableFileType.NPM_LIBRARY.name());
            Path targetDirectory = Files.createDirectories(npmLibrariesPath, new FileAttribute[0]).resolve("swagger-ui-dist").resolve("package");
            VirtualFile[] virtualFileArray2 = SwaggerUtilsKt.getBundledResource(BUNDLED_SWAGGER_UI);
            if (virtualFileArray2 != null && (virtualFileArray2 = virtualFileArray2.getChildren()) != null && (virtualFileArray2 = (VirtualFile[])ArraysKt.firstOrNull((Object[])virtualFileArray2)) != null && (virtualFileArray2 = virtualFileArray2.getChildren()) != null) {
                VirtualFile[] $this$forEach$iv = virtualFileArray2;
                boolean $i$f$forEach = false;
                VirtualFile[] virtualFileArray3 = $this$forEach$iv;
                int n = virtualFileArray3.length;
                for (int i = 0; i < n; ++i) {
                    Path path;
                    VirtualFile element$iv;
                    VirtualFile virtualFile2 = element$iv = virtualFileArray3[i];
                    boolean bl2 = false;
                    VirtualFile virtualFile3 = virtualFile2;
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"virtualFile");
                    Path path2 = path = targetDirectory.resolve(virtualFile3.getName());
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                    if (PathKt.exists((Path)path2)) continue;
                    PathKt.createFile((Path)path);
                    Closeable closeable = virtualFile2.getInputStream();
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Throwable throwable = null;
                    try {
                        InputStream inputStream = (InputStream)closeable;
                        boolean bl5 = false;
                        long l = Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            }
            VirtualFile[] virtualFileArray4 = VfsUtil.findFile((Path)targetDirectory, (boolean)true);
            boolean bl6 = false;
            boolean bl7 = false;
            VirtualFile[] it = virtualFileArray4;
            boolean bl8 = false;
            VirtualFile[] virtualFileArray5 = it;
            if (it != null && (virtualFileArray5 = virtualFileArray5.getChildren()) != null) {
                VirtualFile[] virtualFileArray6 = virtualFileArray5;
                boolean bl9 = false;
                VirtualFile[] virtualFileArray7 = virtualFileArray6;
                boolean bl10 = false;
                bl = !(virtualFileArray7.length == 0);
            } else {
                bl = false;
            }
            virtualFileArray = bl ? virtualFileArray4 : null;
        }
        catch (IOException ex) {
            Logger.getInstance(SwaggerUIManager.class).warn("Unable to load bundled Swagger UI page sources", (Throwable)ex);
            virtualFileArray = null;
        }
        return virtualFileArray;
    }

    private final String convertYamlToJson(String specificationText) {
        String string;
        try {
            JsonNode yamlTree = new ObjectMapper((JsonFactory)new YAMLFactory()).readTree(specificationText);
            string = new ObjectMapper(new JsonFactory()).writeValueAsString((Object)yamlTree);
        }
        catch (JsonProcessingException ex) {
            Logger.getInstance(SwaggerUIManager.class).warn("Unable to convert yaml specification to json format", (Throwable)ex);
            string = null;
        }
        return string;
    }

    private final String addJsonSpecificationPathParameter(VirtualFile indexHtml, String jsonToInline) {
        String rawHtml = ((Object)LoadTextUtil.loadText((VirtualFile)indexHtml)).toString();
        String swaggerUiCall = StringsKt.trimIndent((String)("\n      \n      const ui = SwaggerUIBundle({\n        spec: " + jsonToInline + ",\n        dom_id: '#swagger-ui',\n        deepLinking: true,\n        presets: [\n          SwaggerUIBundle.presets.apis,\n          SwaggerUIStandalonePreset\n        ],\n        layout: \"StandaloneLayout\"\n      })\n      \n    "));
        MatchResult matchResult = Regex.find$default((Regex)SWAGGER_CALL_REGION_REGEX, (CharSequence)rawHtml, (int)0, (int)2, null);
        if (matchResult == null || (matchResult = matchResult.getGroups()) == null || (matchResult = matchResult.get(1)) == null || (matchResult = matchResult.getRange()) == null) {
            return null;
        }
        MatchResult range = matchResult;
        String string = rawHtml;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.replaceRange((CharSequence)string2, (IntRange)range, (CharSequence)swaggerUiCall)).toString();
    }

    private final String addCssStyles(String htmlContent) {
        String css = ".topbar {display: none;}\n.information-container .info {margin: 25px 0;}\n.swagger-ui .download-contents {display: none;}\n.swagger-ui input[type=file] {pointer-events: none;}\ninput[type=text] {outline: 0;}\n/* scrollbar styles */\n::-webkit-scrollbar {width: 6px; height: 6px;}\n::-webkit-scrollbar-thumb {-webkit-border-radius: 10px;}\n::-webkit-scrollbar-track:vertical {-webkit-box-shadow: -1px 0 0 #ededed;}\n::-webkit-scrollbar-track {background-color: transparent;}\n::-webkit-scrollbar {width: 6px;}\n::-webkit-scrollbar-thumb {background-color: rgba(115, 115, 115, 0.2);}";
        if (StartupUiUtil.isUnderDarcula()) {
            css = css + "\n" + "::-webkit-scrollbar-thumb { background-color: rgba(166, 166, 166, 0.27); }";
            StringBuilder stringBuilder = new StringBuilder().append(css).append("\n");
            URL uRL = this.getClass().getResource("/css/swagger-ui-dark.css");
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"javaClass.getResource(\"/css/swagger-ui-dark.css\")");
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
            boolean bl2 = false;
            boolean bl3 = false;
            css = stringBuilder.append(new String(byArray, charset)).toString();
        }
        return htmlContent + StringsKt.trimIndent((String)("\n      <style type=\"text/css\">\n      " + css + "\n      </style>\n    "));
    }

    private SwaggerUIManager() {
    }

    static {
        SwaggerUIManager swaggerUIManager;
        INSTANCE = swaggerUIManager = new SwaggerUIManager();
        String string = "// Begin Swagger UI call region([\\w\\W]*)// End Swagger UI call region";
        boolean bl = false;
        SWAGGER_CALL_REGION_REGEX = new Regex(string);
    }
}

