/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.traverser.impl;

import com.intellij.json.navigation.JsonQualifiedNameKind;
import com.intellij.json.navigation.JsonQualifiedNameProvider;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.swagger.model.api.SwLeafElement;
import com.intellij.swagger.model.specification.SwStringLeafElementKt;
import com.intellij.swagger.traverser.SpecificationTraverser;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0016J\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0016J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0016J\u0019\u0010\r\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0016J\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00142\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/swagger/traverser/impl/JsonSpecificationTraverser;", "Lcom/intellij/swagger/traverser/SpecificationTraverser;", "()V", "getChildValueByKeyName", "Lcom/intellij/psi/PsiElement;", "node", "name", "", "getFullElementPath", "getNameOr", "Lcom/intellij/swagger/model/api/SwLeafElement;", "value", "getParent", "getTopLevelValueOf", "Lcom/intellij/json/psi/JsonValue;", "Lorg/jetbrains/annotations/Nullable;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getValueIfKeyValue", "getValuesAsSequenceFrom", "Lkotlin/sequences/Sequence;", "intellij.swagger"})
public final class JsonSpecificationTraverser
extends SpecificationTraverser {
    @Override
    @Nullable
    public PsiElement getValueIfKeyValue(@Nullable PsiElement node) {
        JsonProperty jsonProperty;
        PsiElement psiElement = node;
        if (!(psiElement instanceof JsonProperty)) {
            psiElement = null;
        }
        return (jsonProperty = (JsonProperty)psiElement) != null && (jsonProperty = jsonProperty.getValue()) != null ? (PsiElement)jsonProperty : node;
    }

    @Override
    @Nullable
    public PsiElement getChildValueByKeyName(@Nullable PsiElement node, @NotNull String name2) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        PsiElement psiElement2 = node;
        if (psiElement2 instanceof JsonObject) {
            Object v2;
            block3: {
                List list = ((JsonObject)node).getPropertyList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"node.propertyList");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    JsonProperty it = (JsonProperty)element$iv;
                    boolean bl = false;
                    JsonProperty jsonProperty = it;
                    Intrinsics.checkNotNullExpressionValue((Object)jsonProperty, (String)"it");
                    if (!Intrinsics.areEqual((Object)jsonProperty.getName(), (Object)name2)) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = null;
            }
            psiElement = v2;
        } else {
            psiElement = null;
        }
        return psiElement;
    }

    @Override
    @NotNull
    public Sequence<PsiElement> getValuesAsSequenceFrom(@Nullable PsiElement node) {
        Sequence sequence;
        PsiElement psiElement = node;
        if (psiElement instanceof JsonObject) {
            List list = ((JsonObject)node).getPropertyList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"node.propertyList");
            sequence = CollectionsKt.asSequence((Iterable)list);
        } else if (psiElement instanceof JsonArray) {
            List list = ((JsonArray)node).getValueList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"node.valueList");
            sequence = CollectionsKt.asSequence((Iterable)list);
        } else {
            sequence = psiElement instanceof JsonProperty ? this.getValuesAsSequenceFrom((PsiElement)((JsonProperty)node).getValue()) : (psiElement instanceof JsonStringLiteral ? SequencesKt.sequenceOf((Object[])new JsonStringLiteral[]{(JsonStringLiteral)node}) : SequencesKt.emptySequence());
        }
        return sequence;
    }

    @Nullable
    public JsonValue getTopLevelValueOf(@Nullable PsiFile psiFile) {
        PsiFile psiFile2 = psiFile;
        if (!(psiFile2 instanceof JsonFile)) {
            psiFile2 = null;
        }
        JsonFile jsonFile = (JsonFile)psiFile2;
        return jsonFile != null ? jsonFile.getTopLevelValue() : null;
    }

    @Override
    @NotNull
    public SwLeafElement<String> getNameOr(@Nullable PsiElement node, @Nullable String value) {
        String string;
        Object object = node;
        if (object instanceof JsonStringLiteral) {
            string = ((JsonStringLiteral)node).getValue();
        } else if (object instanceof JsonBooleanLiteral) {
            string = String.valueOf(((JsonBooleanLiteral)node).getValue());
        } else {
            return super.getNameOr(node, value);
        }
        object = string;
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        String string2 = StringUtil.unquoteString((String)it);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"when (node) {\n        is\u2026gUtil.unquoteString(it) }");
        String textValue = string2;
        return SwStringLeafElementKt.wrapToLeafElement(textValue, node);
    }

    @Override
    @Nullable
    public String getFullElementPath(@Nullable PsiElement node) {
        if (node == null) {
            return null;
        }
        CharSequence charSequence = JsonQualifiedNameProvider.generateQualifiedName((PsiElement)node, (JsonQualifiedNameKind)JsonQualifiedNameKind.Qualified);
        boolean bl = false;
        String string = charSequence;
        if (string == null) {
            string = "";
        }
        charSequence = string;
        String string2 = "\\[.*]";
        boolean bl2 = false;
        string2 = new Regex(string2);
        String string3 = "";
        boolean bl3 = false;
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)string2.replace(charSequence, string3), (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
    }

    @Override
    @Nullable
    public PsiElement getParent(@Nullable PsiElement node) {
        PsiElement psiElement = node;
        return psiElement != null && (psiElement = PsiTreeUtilKt.getParents((PsiElement)psiElement)) != null ? (PsiElement)SequencesKt.firstOrNull((Sequence)psiElement) : null;
    }
}

