/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.remote;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.swagger.SwaggerUtilsKt;
import com.intellij.swagger.model.api.SwAuthority;
import com.intellij.swagger.model.api.SwModelElement;
import com.intellij.swagger.model.api.SwSchema;
import com.intellij.swagger.model.remote.RemoteSpecificationFile;
import com.intellij.swagger.model.remote.openapi.v3.Openapi3RemoteServer;
import com.intellij.swagger.model.remote.openapi.v3.Openapi3RemoteSpecificationFile;
import com.intellij.swagger.model.remote.swagger.v2.Swagger2RemoteSpecificationFile;
import com.intellij.util.Url;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u000b\u001a\u00020\f*\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\r\u001a\u00020\f*\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/swagger/remote/RemoteSpecificationEnricher;", "", "()V", "enrichSchemaAndHost", "", "specification", "Lcom/intellij/swagger/model/remote/swagger/v2/Swagger2RemoteSpecificationFile;", "url", "Lcom/intellij/util/Url;", "enrichServerObjects", "Lcom/intellij/swagger/model/remote/openapi/v3/Openapi3RemoteSpecificationFile;", "withExternalUrl", "Lcom/intellij/swagger/model/remote/RemoteSpecificationFile;", "withVirtualFile", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.swagger"})
public final class RemoteSpecificationEnricher {
    public static final RemoteSpecificationEnricher INSTANCE;

    @NotNull
    public final RemoteSpecificationFile withExternalUrl(@NotNull RemoteSpecificationFile $this$withExternalUrl, @NotNull Url url2) {
        Intrinsics.checkNotNullParameter((Object)$this$withExternalUrl, (String)"$this$withExternalUrl");
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        RemoteSpecificationFile remoteSpecificationFile = $this$withExternalUrl;
        boolean bl = false;
        boolean bl2 = false;
        RemoteSpecificationFile it = remoteSpecificationFile;
        boolean bl3 = false;
        RemoteSpecificationFile remoteSpecificationFile2 = $this$withExternalUrl;
        if (remoteSpecificationFile2 instanceof Openapi3RemoteSpecificationFile) {
            INSTANCE.enrichServerObjects((Openapi3RemoteSpecificationFile)$this$withExternalUrl, url2);
        } else if (remoteSpecificationFile2 instanceof Swagger2RemoteSpecificationFile) {
            INSTANCE.enrichSchemaAndHost((Swagger2RemoteSpecificationFile)$this$withExternalUrl, url2);
        } else {
            Logger.getInstance(RemoteSpecificationEnricher.class).warn("Unknown specification type received, nothing to enrich: " + $this$withExternalUrl.getClass());
        }
        return remoteSpecificationFile;
    }

    @NotNull
    public final RemoteSpecificationFile withVirtualFile(@NotNull RemoteSpecificationFile $this$withVirtualFile, @NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)$this$withVirtualFile, (String)"$this$withVirtualFile");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        RemoteSpecificationFile remoteSpecificationFile = $this$withVirtualFile;
        boolean bl = false;
        boolean bl2 = false;
        RemoteSpecificationFile it = remoteSpecificationFile;
        boolean bl3 = false;
        $this$withVirtualFile.setVirtualFile(virtualFile2);
        return remoteSpecificationFile;
    }

    private final void enrichServerObjects(Openapi3RemoteSpecificationFile specification, Url url2) {
        String schemeAndAuthority = url2.getScheme() + "://" + url2.getAuthority() + '/';
        List list = specification.get_servers();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List existingServers = list;
        Collection collection = existingServers;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Iterable $this$forEach$iv = existingServers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Openapi3RemoteServer it = (Openapi3RemoteServer)element$iv;
                boolean bl2 = false;
                if (it.getSchema() != null || it.getAuthority() != null) continue;
                String[] stringArray = new String[2];
                stringArray[0] = schemeAndAuthority;
                String string = it.get_url();
                boolean bl3 = false;
                String string2 = string;
                if (string2 == null) {
                    string2 = "";
                }
                stringArray[1] = string2;
                it.set_url(SwaggerUtilsKt.buildUrlFromSegments(stringArray));
            }
        } else {
            specification.set_servers(CollectionsKt.listOf((Object)new Openapi3RemoteServer(schemeAndAuthority)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void enrichSchemaAndHost(Swagger2RemoteSpecificationFile specification, Url url2) {
        boolean hasSchemaFromRemoteUrl;
        boolean bl;
        List<SwSchema> existingSchemes;
        block12: {
            block11: {
                if (specification.get_host() == null) break block11;
                SwModelElement swModelElement = specification.get_host();
                CharSequence charSequence = swModelElement != null && (swModelElement = ((SwAuthority)swModelElement).getAuthorityValue()) != null ? (String)swModelElement.getValue() : null;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!(charSequence == null || charSequence.length() == 0)) break block12;
            }
            specification.set_host(new SwAuthority(url2.getAuthority()));
        }
        List<SwSchema> list = existingSchemes = specification.get_schemes();
        if (list != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SwSchema swSchema = (SwSchema)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                String string = it.getSchemaValue().getValue();
                collection.add(string);
            }
            bl = CollectionsKt.contains((Iterable)((List)destination$iv$iv), (Object)url2.getScheme());
        } else {
            bl = hasSchemaFromRemoteUrl = false;
        }
        if (!hasSchemaFromRemoteUrl) {
            SwSchema[] swSchemaArray;
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)new SwSchema(url2.getScheme()));
            List<SwSchema> list2 = existingSchemes;
            if (list2 != null) {
                Collection $this$toTypedArray$iv = list2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                SwSchema[] swSchemaArray2 = thisCollection$iv.toArray(new SwSchema[0]);
                if (swSchemaArray2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                swSchemaArray = swSchemaArray2;
            } else {
                swSchemaArray = null;
            }
            SwSchema[] $this$orEmpty$iv = swSchemaArray;
            boolean $i$f$orEmpty = false;
            SwSchema[] swSchemaArray3 = $this$orEmpty$iv;
            if ($this$orEmpty$iv == null) {
                swSchemaArray3 = new SwSchema[]{};
            }
            spreadBuilder.addSpread(swSchemaArray3);
            specification.set_schemes(CollectionsKt.listOfNotNull((Object[])((SwSchema[])spreadBuilder.toArray((Object[])new SwSchema[spreadBuilder.size()]))));
        }
    }

    private RemoteSpecificationEnricher() {
    }

    static {
        RemoteSpecificationEnricher remoteSpecificationEnricher;
        INSTANCE = remoteSpecificationEnricher = new RemoteSpecificationEnricher();
    }
}

