/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.reference.definitions.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.swagger.SwaggerBundle;
import com.intellij.swagger.model.SwaggerMergedModel;
import com.intellij.swagger.model.api.SwDefinition;
import com.intellij.swagger.model.api.SwModelBase;
import com.intellij.swagger.model.api.SwParameter;
import com.intellij.swagger.model.api.SwResponse;
import com.intellij.swagger.model.specification.SpecificationObjectDefinition;
import com.intellij.swagger.model.specification.SwSpecificationFile;
import com.intellij.swagger.model.specification.light.SwFakeMetaHolderKt;
import com.intellij.swagger.model.specification.openapi.v3.Openapi3Definition;
import com.intellij.swagger.reference.definitions.SwDefinitionCoordinatesParser;
import com.intellij.swagger.reference.definitions.SwObjectCoordinates;
import com.intellij.swagger.reference.definitions.SwObjectDefinitionReferenceKt;
import com.intellij.swagger.reference.definitions.completion.LocalFileCompletionProvider;
import com.intellij.swagger.reference.definitions.completion.LocalFileCompletionProvider$completeFileSystemItems$;
import com.intellij.util.ProcessingContext;
import icons.SwaggerIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u0010\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0016H\u0002J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a8\u0006\u001f"}, d2={"Lcom/intellij/swagger/reference/definitions/completion/LocalFileCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "()V", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "completeDefinitions", "element", "Lcom/intellij/psi/PsiElement;", "coordinates", "Lcom/intellij/swagger/reference/definitions/SwObjectCoordinates;", "completeFileSystemItems", "caretOffset", "", "createDefinitionLookup", "Lcom/intellij/codeInsight/lookup/LookupElement;", "objectDefinition", "Lcom/intellij/swagger/model/api/SwDefinition;", "definitionCoordinates", "", "createFileSystemItemLookup", "fileSystemItem", "Lcom/intellij/psi/PsiFileSystemItem;", "getDefinitionHint", "definition", "getFileSystemItemHint", "intellij.swagger"})
final class LocalFileCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        block3: {
            SwObjectCoordinates coordinates;
            int caretOffsetInElement;
            PsiElement element;
            block4: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                    PsiElement psiElement = parameters2.getPosition();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"parameters.position");
                    PsiFile psiFile = psiElement.getContainingFile();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"parameters.position\n    \u2026          .containingFile");
                    PsiElement psiElement2 = psiFile.getOriginalFile().findElementAt(parameters2.getOffset());
                    if (psiElement2 == null || (psiElement2 = psiElement2.getParent()) == null) {
                        return;
                    }
                    element = psiElement2;
                    caretOffsetInElement = parameters2.getOffset() - UtilsKt.getStartOffset((PsiElement)element);
                    TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)element);
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"ElementManipulators.getValueTextRange(element)");
                    TextRange rangeInElement = textRange;
                    String string = element.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
                    coordinates = SwDefinitionCoordinatesParser.INSTANCE.parseObjectCoordinates(string, rangeInElement);
                    if (coordinates.isWebCoordinates()) {
                        return;
                    }
                    if (!coordinates.isEmpty()) break block2;
                    this.completeDefinitions(element, coordinates, result);
                    this.completeFileSystemItems(element, coordinates, caretOffsetInElement, result);
                    break block3;
                }
                if (!coordinates.isStorageEdited(caretOffsetInElement)) break block4;
                this.completeFileSystemItems(element, coordinates, caretOffsetInElement, result);
                break block3;
            }
            if (!coordinates.isDefinitionEdited(caretOffsetInElement)) break block3;
            this.completeDefinitions(element, coordinates, result);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void completeFileSystemItems(PsiElement element, SwObjectCoordinates coordinates, int caretOffset, CompletionResultSet result) {
        void completeSegment;
        Pair<String, String> pair = coordinates.computeCompletedStorageUriSegment(caretOffset);
        if (pair == null) {
            return;
        }
        Pair<String, String> pair2 = pair;
        String string = (String)pair2.component1();
        String incompleteSegment = (String)pair2.component2();
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"element.containingFile");
        PsiFile psiFile2 = psiFile.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"element.containingFile.originalFile");
        VirtualFile virtualFile2 = SwObjectDefinitionReferenceKt.findByRelativePath(psiFile2, (String)completeSegment);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile directory = virtualFile2;
        PsiDirectory psiDirectory = PsiManager.getInstance((Project)element.getProject()).findDirectory(directory);
        Object[] $this$orEmpty$iv = psiDirectory != null ? psiDirectory.getChildren() : null;
        boolean $i$f$orEmpty = false;
        Object[] objectArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            objectArray = new PsiElement[]{};
        }
        Sequence $this$filterIsInstance$iv = ArraysKt.asSequence((Object[])objectArray);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)completeFileSystemItems$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        Sequence $this$forEach$iv = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)sequence, (Function1)completeFileSystemItems.1.INSTANCE), (Function1)((Function1)new Function1<PsiFileSystemItem, LookupElement>(this, coordinates){
            final /* synthetic */ LocalFileCompletionProvider this$0;
            final /* synthetic */ SwObjectCoordinates $coordinates;

            @NotNull
            public final LookupElement invoke(@NotNull PsiFileSystemItem it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return LocalFileCompletionProvider.access$createFileSystemItemLookup(this.this$0, it, this.$coordinates);
            }
            {
                this.this$0 = localFileCompletionProvider;
                this.$coordinates = swObjectCoordinates;
                super(1);
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LookupElement it = (LookupElement)element$iv;
            boolean bl = false;
            result.withPrefixMatcher(incompleteSegment).consume(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void completeDefinitions(PsiElement element, SwObjectCoordinates coordinates, CompletionResultSet result) {
        Object object;
        String prefix;
        SwModelBase swModelBase;
        SwModelBase swModelBase2;
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"element.containingFile");
        PsiFile psiFile2 = psiFile.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"element.containingFile.originalFile");
        PsiFile originalFile = psiFile2;
        PsiFile externalFile = SwObjectDefinitionReferenceKt.findStorageFile(originalFile, coordinates.getUriValue());
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
        SwaggerMergedModel swaggerMergedModel = SwaggerMergedModel.Companion.getInstance(project);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)originalFile);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.fileScope(originalFile)");
        SwModelBase swModelBase3 = (SwModelBase)CollectionsKt.firstOrNull(swaggerMergedModel.getBaseModelElements(globalSearchScope));
        if (swModelBase3 != null) {
            Project project2 = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
            swModelBase2 = swModelBase3.substitute(project2);
        } else {
            swModelBase2 = swModelBase = null;
        }
        if (!(swModelBase2 instanceof SwSpecificationFile)) {
            swModelBase = null;
        }
        SwSpecificationFile swSpecificationFile = (SwSpecificationFile)swModelBase;
        if (swSpecificationFile == null) {
            return;
        }
        SwSpecificationFile currentSpecification = swSpecificationFile;
        SwSpecificationFile specificationFile = externalFile == null ? currentSpecification : SwFakeMetaHolderKt.createFakeSecondarySpecification(currentSpecification, externalFile);
        String string = coordinates.getDefinitionCoordinates();
        String string2 = string != null ? StringsKt.substringAfter$default((String)string, (String)"#/", null, (int)2, null) : null;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            string3 = prefix = "";
        }
        if ((object = specificationFile) != null && (object = ((SwSpecificationFile)object).getAllLocalObjectDefinitions()) != null) {
            Iterable $this$sortedBy$iv = (Iterable)object;
            boolean $i$f$sortedBy = false;
            boolean bl2 = false;
            object = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    SwDefinition it = (SwDefinition)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it.getName().getValue());
                    it = (SwDefinition)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = it.getName().getValue();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            });
            if (object != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SwDefinition swDefinition = (SwDefinition)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    LookupElement lookupElement = this.createDefinitionLookup((SwDefinition)it, coordinates.getDefinitionCoordinates());
                    collection.add(lookupElement);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    LookupElement it = (LookupElement)element$iv;
                    boolean bl4 = false;
                    result.withPrefixMatcher(prefix).consume(it);
                }
            }
        }
    }

    private final LookupElement createDefinitionLookup(SwDefinition objectDefinition, String definitionCoordinates) {
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)objectDefinition.getElementPath()).withPresentableText(objectDefinition.getName().getValue()).withTypeText(this.getDefinitionHint(objectDefinition)).withIcon(SwaggerIcons.Entity).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(definitionCoordinates){
            final /* synthetic */ String $definitionCoordinates;

            public final void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                String string = this.$definitionCoordinates;
                boolean hasReferenceAttribute = string != null ? StringsKt.startsWith$default((String)string, (String)"#/", (boolean)false, (int)2, null) : false;
                String string2 = hasReferenceAttribute ? item.getLookupString() : "#/" + item.getLookupString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"if (hasReferenceAttribut\u2026OOT}${item.lookupString}\"");
                String replacement = string2;
                context.getDocument().replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)replacement);
            }
            {
                this.$definitionCoordinates = string;
            }
        });
        boolean bl = false;
        boolean bl2 = false;
        LookupElementBuilder it = lookupElementBuilder;
        boolean bl3 = false;
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)it), (double)10.0);
        Intrinsics.checkNotNullExpressionValue((Object)lookupElement, (String)"LookupElementBuilder.cre\u2026.withPriority(it, 10.0) }");
        return lookupElement;
    }

    private final String getDefinitionHint(SwDefinition definition) {
        SwDefinition swDefinition = definition;
        return swDefinition instanceof SpecificationObjectDefinition || swDefinition instanceof Openapi3Definition ? SwaggerBundle.message("object.definitions.swagger.v2.definition.hint", new Object[0]) : (swDefinition instanceof SwResponse ? SwaggerBundle.message("object.definitions.response.hint", new Object[0]) : (swDefinition instanceof SwParameter ? SwaggerBundle.message("object.definitions.parameter.hint", new Object[0]) : "Unknown"));
    }

    private final LookupElement createFileSystemItemLookup(PsiFileSystemItem fileSystemItem, SwObjectCoordinates coordinates) {
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)fileSystemItem.getName()).withIcon(fileSystemItem.getIcon(0)).withTypeText(this.getFileSystemItemHint(fileSystemItem)).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(coordinates, fileSystemItem){
            final /* synthetic */ SwObjectCoordinates $coordinates;
            final /* synthetic */ PsiFileSystemItem $fileSystemItem;

            public final void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                boolean bl = false;
                boolean bl2 = false;
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl3 = false;
                boolean bl4 = false;
                StringBuilder $this$buildString = stringBuilder;
                boolean bl5 = false;
                String relativePath = this.$coordinates.getUriValue();
                CharSequence charSequence = relativePath;
                boolean bl6 = false;
                boolean bl7 = false;
                if (!(charSequence == null || charSequence.length() == 0) && Intrinsics.areEqual((Object)context.getDocument().getText(TextRange.create((int)(context.getStartOffset() - 1), (int)context.getStartOffset())), (Object)"/") ^ true) {
                    $this$buildString.append("/");
                }
                $this$buildString.append(item.getLookupString());
                if (this.$fileSystemItem.isDirectory()) {
                    $this$buildString.append("/");
                }
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                String replacement = string;
                context.getDocument().replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)replacement);
            }
            {
                this.$coordinates = swObjectCoordinates;
                this.$fileSystemItem = psiFileSystemItem;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"LookupElementBuilder.cre\u2026cement)\n        }\n      )");
        return (LookupElement)lookupElementBuilder;
    }

    private final String getFileSystemItemHint(PsiFileSystemItem fileSystemItem) {
        PsiFileSystemItem psiFileSystemItem = fileSystemItem;
        return psiFileSystemItem instanceof PsiFile ? SwaggerBundle.message("completion.file.hint", new Object[0]) : (psiFileSystemItem instanceof PsiDirectory ? SwaggerBundle.message("completion.directory.hint", new Object[0]) : "");
    }

    public static final /* synthetic */ LookupElement access$createFileSystemItemLookup(LocalFileCompletionProvider $this, PsiFileSystemItem fileSystemItem, SwObjectCoordinates coordinates) {
        return $this.createFileSystemItemLookup(fileSystemItem, coordinates);
    }
}

